/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.springservices;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class GenericApplicationContextUtil {
    public static final String SPRING_APPLICATION_CONTEXT = "SpringApplicationContext";

    public static GenericApplicationContext getSpringApplicationContext(InputStream applicationContxtInStream, String springBeansFilePath) throws AxisFault {
        GenericApplicationContext appContext = new GenericApplicationContext();
        XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
        xbdr.setValidating(false);
        xbdr.loadBeanDefinitions((Resource)new InputStreamResource(applicationContxtInStream));
        appContext.refresh();
        return appContext;
    }

    public static GenericApplicationContext getSpringApplicationContextClassPath(ClassLoader classLoader, String relPath) throws AxisFault {
        GenericApplicationContext appContext = new GenericApplicationContext();
        appContext.setClassLoader(classLoader);
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
            xbdr.setValidating(false);
            InputStream in = classLoader.getResourceAsStream(relPath);
            if (in == null) {
                throw new AxisFault("Spring context cannot be located for AxisService");
            }
            xbdr.loadBeanDefinitions((Resource)new InputStreamResource(in));
            appContext.refresh();
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
        return appContext;
    }

    public static GenericApplicationContext getSpringApplicationContext(String applicationContxtFilePath, ClassLoader springBeansClassLoader) throws AxisFault {
        GenericApplicationContext appContext = new GenericApplicationContext();
        appContext.setClassLoader(springBeansClassLoader);
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)new MultiParentClassLoader(new URL[0], new ClassLoader[]{springBeansClassLoader, prevCl}));
            XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
            xbdr.setValidating(false);
            xbdr.loadBeanDefinitions((Resource)new InputStreamResource((InputStream)new FileInputStream(new File(applicationContxtFilePath))));
            appContext.refresh();
        }
        catch (FileNotFoundException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
        return appContext;
    }

    public static GenericApplicationContext getSpringApplicationContext(String applicationContxtFilePath, String springBeansFilePath) throws AxisFault {
        try {
            return GenericApplicationContextUtil.getSpringApplicationContext(new FileInputStream(new File(applicationContxtFilePath)), springBeansFilePath);
        }
        catch (FileNotFoundException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public static GenericApplicationContext getSpringApplicationContext(AxisService axisService, String contextLocation) throws AxisFault {
        Parameter appContextParameter = axisService.getParameter(SPRING_APPLICATION_CONTEXT);
        if (appContextParameter != null) {
            return (GenericApplicationContext)appContextParameter.getValue();
        }
        GenericApplicationContext appContext = new GenericApplicationContext();
        ClassLoader classLoader = axisService.getClassLoader();
        appContext.setClassLoader(classLoader);
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
            xbdr.setValidating(false);
            InputStream in = classLoader.getResourceAsStream(contextLocation);
            if (in == null) {
                throw new AxisFault("Spring context cannot be located for AxisService");
            }
            xbdr.loadBeanDefinitions((Resource)new InputStreamResource(in));
            appContext.refresh();
            axisService.addParameter(new Parameter(SPRING_APPLICATION_CONTEXT, (Object)appContext));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
        return appContext;
    }
}

