/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.persistence.jms.util;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;

public class JMSUtil {
    public static Connection createConnection(ConnectionFactory connectionFactory, String userName, String password, boolean jmsSpec11) throws JMSException {
        Connection connection;
        if (jmsSpec11) {
            connection = userName != null && password != null ? connectionFactory.createConnection(userName, password) : connectionFactory.createConnection();
        } else {
            QueueConnectionFactory qConFac = (QueueConnectionFactory)connectionFactory;
            connection = userName != null && password != null ? qConFac.createQueueConnection(userName, password) : qConFac.createQueueConnection();
        }
        return connection;
    }

    public static MessageProducer createProducer(Session session, Destination destination, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11) {
            return session.createProducer(destination);
        }
        return ((QueueSession)session).createSender((Queue)destination);
    }

    public static MessageConsumer createConsumer(Session session, Destination destination, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11) {
            return session.createConsumer(destination);
        }
        return ((QueueSession)session).createReceiver((Queue)destination);
    }

    public static Session createSession(Connection connection, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11) {
            return connection.createSession(false, 1);
        }
        return ((QueueConnection)connection).createQueueSession(false, 1);
    }
}

