/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediators.router.impl.config.xml;

import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.TargetFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediators.router.impl.Route;
import org.wso2.carbon.mediators.router.impl.RouterMediator;

public class RouterMediatorFactory
extends AbstractMediatorFactory {
    private static final QName ROUTER_Q = new QName("http://ws.apache.org/ns/synapse", "router");
    private static final QName ROUTE_Q = new QName("http://ws.apache.org/ns/synapse", "route");
    private static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    private static final QName ATT_CONTINUE_AFTER = new QName("continueAfter");
    private static final QName ATT_MATCH = new QName("match");
    private static final QName ATT_BREAK_ROUTER = new QName("breakRouter");

    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        if (!ROUTER_Q.equals(elem.getQName())) {
            this.handleException("Unable to create the Router mediator. Unexpected element as the Router mediator configuration");
        }
        RouterMediator m = new RouterMediator();
        OMAttribute continueAfterAttr = elem.getAttribute(ATT_CONTINUE_AFTER);
        if (continueAfterAttr != null && continueAfterAttr.getAttributeValue() != null) {
            m.setContinueAfter(Boolean.parseBoolean(continueAfterAttr.getAttributeValue()));
        }
        Iterator itr = elem.getChildrenWithName(ROUTE_Q);
        while (itr.hasNext()) {
            OMElement routeElement = (OMElement)itr.next();
            OMAttribute expressionAttr = routeElement.getAttribute(ATT_EXPRN);
            OMAttribute matchAttr = routeElement.getAttribute(ATT_MATCH);
            OMAttribute breakRouterAttr = routeElement.getAttribute(ATT_BREAK_ROUTER);
            OMElement targetElem = routeElement.getFirstChildWithName(TARGET_Q);
            Route route = new Route();
            if (expressionAttr != null && expressionAttr.getAttributeValue() != null) {
                try {
                    route.setExpression(SynapseXPathFactory.getSynapseXPath((OMElement)routeElement, (QName)ATT_EXPRN));
                }
                catch (JaxenException e) {
                    this.handleException("Couldn't build the xpath from the expression : " + expressionAttr.getAttributeValue(), (Exception)((Object)e));
                }
            } else {
                this.handleException("Route without an expression attribute has been found, but it is required to have an expression for all routes");
            }
            if (matchAttr != null && matchAttr.getAttributeValue() != null) {
                route.setMatch(Pattern.compile(matchAttr.getAttributeValue()));
            }
            if (breakRouterAttr != null && breakRouterAttr.getAttributeValue() != null) {
                route.setBreakRouter(Boolean.parseBoolean(breakRouterAttr.getAttributeValue()));
            }
            if (targetElem != null) {
                route.setTarget(TargetFactory.createTarget((OMElement)targetElem, (Properties)properties));
            } else {
                this.handleException("Route has to have a target for it, missing the taregt of the route");
            }
            m.addRoute(route);
        }
        return m;
    }

    public QName getTagQName() {
        return ROUTER_Q;
    }
}

