/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jexl;

import com.sun.script.jexl.JexlScriptEngineFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;

public class JexlScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private ScriptEngineFactory factory;

    public CompiledScript compile(String script) throws ScriptException {
        Expression expr = this.compileExpr(script);
        return new JexlCompiledScript(expr);
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        Expression expr = this.compileExpr(str);
        return this.evalExpr(expr, ctx);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        JexlScriptEngine jexlScriptEngine = this;
        synchronized (jexlScriptEngine) {
            if (this.factory == null) {
                this.factory = new JexlScriptEngineFactory();
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private Expression compileExpr(String str) throws ScriptException {
        try {
            return ExpressionFactory.createExpression((String)str);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private Object evalExpr(Expression expr, final ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        try {
            return expr.evaluate(new JexlContext(){

                public Map getVars() {
                    return new Map(){

                        public int size() {
                            Bindings b = ctx.getBindings(100);
                            return b.size();
                        }

                        public boolean isEmpty() {
                            Bindings b = ctx.getBindings(100);
                            return b.isEmpty();
                        }

                        public boolean containsKey(Object key) {
                            if (key instanceof String) {
                                return ctx.getAttributesScope((String)key) != -1;
                            }
                            return false;
                        }

                        public boolean containsValue(Object value) {
                            Iterator<Integer> i$ = ctx.getScopes().iterator();
                            while (i$.hasNext()) {
                                int scope = i$.next();
                                Bindings b = ctx.getBindings(scope);
                                if (b == null) continue;
                                return b.containsValue(value);
                            }
                            return false;
                        }

                        public Object get(Object key) {
                            String name;
                            int scope;
                            if (key instanceof String && (scope = ctx.getAttributesScope(name = (String)key)) != -1) {
                                return ctx.getAttribute(name, scope);
                            }
                            return null;
                        }

                        public Object put(Object key, Object value) {
                            if (!(key instanceof String)) {
                                return null;
                            }
                            String name = (String)key;
                            int scope = ctx.getAttributesScope(name);
                            if (scope == -1) {
                                scope = 100;
                            }
                            Object old = ctx.getAttribute(name, scope);
                            ctx.setAttribute(name, value, scope);
                            return old;
                        }

                        public Object remove(Object key) {
                            if (!(key instanceof String)) {
                                return null;
                            }
                            String name = (String)key;
                            int scope = ctx.getAttributesScope(name);
                            if (scope == -1) {
                                scope = 100;
                            }
                            Object old = ctx.getAttribute(name, scope);
                            ctx.removeAttribute(name, scope);
                            return old;
                        }

                        public void putAll(Map m) {
                            Bindings b = ctx.getBindings(100);
                            b.putAll(m);
                        }

                        public void clear() {
                            Bindings b = ctx.getBindings(100);
                            b.clear();
                        }

                        public Set keySet() {
                            Bindings b = ctx.getBindings(100);
                            return b.keySet();
                        }

                        public Collection values() {
                            Bindings b = ctx.getBindings(100);
                            return b.values();
                        }

                        public Set entrySet() {
                            Bindings b = ctx.getBindings(100);
                            return b.entrySet();
                        }
                    };
                }

                public void setVars(Map vars) {
                    ctx.setBindings(new SimpleBindings(vars), 100);
                }
            });
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    static Object access$000(JexlScriptEngine x0, Expression x1, ScriptContext x2) throws ScriptException {
        return x0.evalExpr(x1, x2);
    }

    private class JexlCompiledScript
    extends CompiledScript {
        private Expression expr;

        JexlCompiledScript(Expression expr) {
            this.expr = expr;
        }

        public ScriptEngine getEngine() {
            return JexlScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JexlScriptEngine.access$000(JexlScriptEngine.this, this.expr, ctx);
        }
    }
}

