/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jaxwsservices;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.jaxwsservices.JAXServiceData;

public class JAXWSServiceUploader
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(JAXWSServiceUploader.class);

    public void uploadService(JAXServiceData[] serviceDataList) throws AxisFault {
        try {
            AxisConfiguration axisConfig = this.getAxisConfig();
            String repo = axisConfig.getRepository().getPath();
            for (JAXServiceData serviceData : serviceDataList) {
                String serviceHierarchy = serviceData.getServiceHierarchy();
                StringBuilder destDir = new StringBuilder();
                destDir.append(repo + File.separator + "servicejars");
                if (serviceHierarchy != null) {
                    String[] hierarchyParts;
                    for (String part : hierarchyParts = serviceHierarchy.split("/")) {
                        boolean status;
                        destDir.append(File.separator + part);
                        File hierarchyFolder = new File(destDir.toString());
                        if (hierarchyFolder.exists() || (status = hierarchyFolder.mkdir())) continue;
                        throw new AxisFault("Error while creating directory structure");
                    }
                }
                if (serviceData.getFileName() == null || serviceData.getFileName().equals("")) {
                    throw new AxisFault("Invalid file name");
                }
                if (serviceData.getFileName().endsWith(".aar")) {
                    throw new AxisFault("File with extension " + serviceData.getFileName() + " is not supported!");
                }
                this.writeResource(serviceData.getDataHandler(), destDir.toString(), serviceData.getFileName());
            }
        }
        catch (IOException e) {
            throw new AxisFault("Error occurred while uploading service artifacts", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResource(DataHandler dataHandler, String destPath, String fileName) throws IOException {
        File destFile = new File(destPath, fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to close FileOutputStream for file " + fileName), (Throwable)e);
                }
            }
        }
    }
}

