/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.router;

import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.target.TargetMediator;

public class RouteMediator
extends AbstractListMediator {
    private static final QName ATT_MATCH = new QName("match");
    private static final QName ATT_BREAK_ROUTER = new QName("breakRouter");
    private SynapseXPath expression;
    private Pattern match;
    private boolean breakRouter = true;

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public Pattern getMatch() {
        return this.match;
    }

    public boolean isBreakRouter() {
        return this.breakRouter;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public void setMatch(Pattern match) {
        this.match = match;
    }

    public void setBreakRouter(boolean breakRouter) {
        this.breakRouter = breakRouter;
    }

    public RouteMediator() {
        this.addChild((Mediator)new TargetMediator());
    }

    public OMElement serialize(OMElement parent) {
        OMElement routeElem = fac.createOMElement("route", synNS);
        if (this.expression == null) {
            throw new MediatorException("Incomplete route has been found in the serialization of the RouterMediator");
        }
        SynapseXPathSerializer.serializeXPath((SynapseXPath)this.expression, (OMElement)routeElem, (String)"expression");
        if (this.match != null) {
            routeElem.addAttribute(fac.createOMAttribute("match", nullNS, this.match.pattern()));
        }
        if (!this.breakRouter) {
            routeElem.addAttribute(fac.createOMAttribute("breakRouter", nullNS, "false"));
        }
        this.serializeChildren(routeElem, this.getList());
        if (parent != null) {
            parent.addChild((OMNode)routeElem);
        }
        return routeElem;
    }

    public void build(OMElement elem) {
        OMAttribute expressionAttr = elem.getAttribute(ATT_EXPRN);
        OMAttribute matchAttr = elem.getAttribute(ATT_MATCH);
        OMAttribute breakRouterAttr = elem.getAttribute(ATT_BREAK_ROUTER);
        this.expression = null;
        this.match = null;
        this.breakRouter = true;
        this.getList().clear();
        if (expressionAttr != null && expressionAttr.getAttributeValue() != null) {
            try {
                this.expression = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_EXPRN);
            }
            catch (JaxenException e) {
                throw new MediatorException("Couldn't build the xpath from the expression : " + expressionAttr.getAttributeValue());
            }
        } else {
            throw new MediatorException("Route without an expression attribute has been found, but it is required to have an expression for all routes");
        }
        if (matchAttr != null && matchAttr.getAttributeValue() != null) {
            this.match = Pattern.compile(matchAttr.getAttributeValue());
        }
        if (breakRouterAttr != null && breakRouterAttr.getAttributeValue() != null) {
            this.breakRouter = Boolean.parseBoolean(breakRouterAttr.getAttributeValue());
        }
        this.addChildren(elem, (ListMediator)this);
    }

    public String getTagLocalName() {
        return "route";
    }
}

