/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class EJBMediator
extends AbstractMediator {
    private static final QName EJB_Q = new QName("http://ws.apache.org/ns/synapse", "ejb");
    private static final QName ARGS_Q = new QName("http://ws.apache.org/ns/synapse", "args");
    private static final QName ARG_Q = new QName("http://ws.apache.org/ns/synapse", "arg");
    private static final QName ATT_CLASS = new QName("class");
    private static final QName ATT_BEANSTALK = new QName("beanstalk");
    private static final QName ATT_METHOD = new QName("method");
    private static final QName ATT_TARGET = new QName("target");
    private static final QName ATT_JNDI_NAME = new QName("jndiName");
    private static final QName ATT_STATEFUL = new QName("stateful");
    private static final QName ATT_ID = new QName("id");
    private static final QName ATT_REMOVE = new QName("remove");
    private String clazz;
    private String beanstalk;
    private String method;
    private String target;
    private String jndiName;
    private Value id;
    private Boolean stateful;
    private Boolean remove;
    private List<Value> arguments = new ArrayList<Value>();

    public String getTagLocalName() {
        return "ejb";
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getBeanstalk() {
        return this.beanstalk;
    }

    public void setBeanstalk(String beanstalk) {
        this.beanstalk = beanstalk;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Value getId() {
        return this.id;
    }

    public void setId(Value id) {
        this.id = id;
    }

    public Boolean getStateful() {
        return this.stateful;
    }

    public void setStateful(Boolean stateful) {
        this.stateful = stateful;
    }

    public List<Value> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Value> arguments) {
        this.arguments = arguments;
    }

    public void addArguments(Value value) {
        this.arguments.add(value);
    }

    public Boolean getRemove() {
        return this.remove;
    }

    public void setRemove(Boolean remove) {
        this.remove = remove;
    }

    public OMElement serialize(OMElement parent) {
        OMElement ejbElem = fac.createOMElement(EJB_Q);
        if (this.clazz != null && !this.clazz.isEmpty()) {
            OMAttribute clazzAtt = fac.createOMAttribute("class", nullNS, this.clazz);
            ejbElem.addAttribute(clazzAtt);
        }
        if (this.beanstalk != null && !this.beanstalk.isEmpty()) {
            OMAttribute beanstalkAtt = fac.createOMAttribute("beanstalk", nullNS, this.beanstalk);
            ejbElem.addAttribute(beanstalkAtt);
        }
        if (this.method != null && !this.method.isEmpty()) {
            OMAttribute methodAtt = fac.createOMAttribute("method", nullNS, this.method);
            ejbElem.addAttribute(methodAtt);
        }
        if (this.target != null && !this.target.isEmpty()) {
            OMAttribute targetAtt = fac.createOMAttribute("target", nullNS, this.target);
            ejbElem.addAttribute(targetAtt);
        }
        if (this.jndiName != null && !this.jndiName.isEmpty()) {
            OMAttribute jndiNameAtt = fac.createOMAttribute("jndiName", nullNS, this.jndiName);
            ejbElem.addAttribute(jndiNameAtt);
        }
        if (this.id != null) {
            new ValueSerializer().serializeValue(this.id, "id", ejbElem);
        }
        if (this.stateful != null) {
            OMAttribute statefulAttr = fac.createOMAttribute("stateful", nullNS, this.stateful.toString());
            ejbElem.addAttribute(statefulAttr);
        }
        if (this.remove != null) {
            OMAttribute removeAttr = fac.createOMAttribute("remove", nullNS, this.remove.toString());
            ejbElem.addAttribute(removeAttr);
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            OMElement argumentsElem = fac.createOMElement("args", synNS);
            for (Value arg : this.arguments) {
                OMElement argElem = fac.createOMElement("arg", synNS);
                new ValueSerializer().serializeValue(arg, "value", argElem);
                argumentsElem.addChild((OMNode)argElem);
            }
            ejbElem.addChild((OMNode)argumentsElem);
        }
        this.validateEJBMethod();
        if (parent != null) {
            parent.addChild((OMNode)ejbElem);
        }
        return ejbElem;
    }

    private void validateEJBMethod() throws MediatorException {
        try {
            Class<?> clazz;
            if (this.clazz != null) {
                Class.forName(this.clazz.trim());
            }
            if (this.clazz != null && this.method != null && (clazz = Class.forName(this.clazz.trim())) != null) {
                boolean foundMethod = false;
                for (Method method : clazz.getMethods()) {
                    if (!this.method.equals(method.getName())) continue;
                    foundMethod = true;
                }
                if (!foundMethod) {
                    throw new MediatorException("Couldn't load method definition " + this.method + " name under the class " + this.clazz);
                }
            }
            if (this.clazz != null && this.method != null && this.arguments != null && (clazz = Class.forName(this.clazz)) != null) {
                boolean argumetnsOk = false;
                for (Method method : clazz.getMethods()) {
                    if (!this.method.equals(method.getName()) || !method.getName().equals(this.method) || method.getParameterTypes().length != this.arguments.size()) continue;
                    argumetnsOk = true;
                }
                if (!argumetnsOk) {
                    throw new MediatorException("Invalid number of argments provided for method " + this.method);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new MediatorException("Couldn't load class name " + this.clazz);
        }
    }

    public void build(OMElement elem) {
        Iterator argsitr;
        OMAttribute id;
        OMAttribute method;
        OMAttribute target;
        OMAttribute jndiName;
        OMAttribute remove;
        OMAttribute stateful;
        OMAttribute beanstalk;
        this.processAuditStatus((Mediator)this, elem);
        ValueFactory valueFactory = new ValueFactory();
        OMAttribute clazz = elem.getAttribute(ATT_CLASS);
        if (clazz != null) {
            this.clazz = clazz.getAttributeValue();
        }
        if ((beanstalk = elem.getAttribute(ATT_BEANSTALK)) != null) {
            this.beanstalk = beanstalk.getAttributeValue();
        }
        if ((stateful = elem.getAttribute(ATT_STATEFUL)) != null) {
            this.stateful = new Boolean(stateful.getAttributeValue());
        }
        if ((remove = elem.getAttribute(ATT_REMOVE)) != null) {
            this.remove = new Boolean(remove.getAttributeValue());
        }
        if ((jndiName = elem.getAttribute(ATT_JNDI_NAME)) != null) {
            this.jndiName = jndiName.getAttributeValue();
        }
        if ((target = elem.getAttribute(ATT_TARGET)) != null) {
            this.target = target.getAttributeValue();
        }
        if ((method = elem.getAttribute(ATT_METHOD)) != null) {
            this.method = method.getAttributeValue();
        }
        if ((id = elem.getAttribute(ATT_ID)) != null) {
            Value beanId;
            this.id = beanId = valueFactory.createValue("id", elem);
        }
        if ((argsitr = elem.getChildrenWithName(ARGS_Q)) != null) {
            ArrayList<Value> args = new ArrayList<Value>();
            while (argsitr.hasNext()) {
                Iterator argItr;
                OMElement argsElm = (OMElement)argsitr.next();
                if (argsElm == null || (argItr = argsElm.getChildrenWithName(ARG_Q)) == null) continue;
                while (argItr.hasNext()) {
                    OMElement argElm = (OMElement)argItr.next();
                    if (argElm == null) continue;
                    Value value = valueFactory.createValue("value", argElm);
                    args.add(value);
                }
            }
            this.arguments.addAll(args);
        }
    }

    private void handleException(String msg) {
        LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)msg);
        throw new SynapseException(msg);
    }
}

