/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class CommandMediator
extends AbstractMediator {
    protected static final QName ATT_ACTION = new QName("action");
    protected static final QName ATT_CTXNAME = new QName("context-name");
    protected static final String RM_ACTION = "ReadMessage";
    protected static final String UM_ACTION = "UpdateMessage";
    protected static final String RC_ACTION = "ReadContext";
    protected static final String UC_ACTION = "UpdateContext";
    protected static final String RAUM_ACTION = "ReadAndUpdateMessage";
    protected static final String RAUC_ACTION = "ReadAndUpdateContext";
    private String command = null;
    private final Map<String, Object> staticSetterProperties = new HashMap<String, Object>();
    private final Map<String, SynapseXPath> messageSetterProperties = new HashMap<String, SynapseXPath>();
    private final Map<String, String> contextSetterProperties = new HashMap<String, String>();
    private final Map<String, String> contextGetterProperties = new HashMap<String, String>();
    private final Map<String, SynapseXPath> messageGetterProperties = new HashMap<String, SynapseXPath>();

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void addStaticSetterProperty(String name, Object value) {
        this.staticSetterProperties.put(name, value);
    }

    public void addMessageSetterProperty(String name, SynapseXPath xpath) {
        this.messageSetterProperties.put(name, xpath);
    }

    public void addContextSetterProperty(String name, String ctxName) {
        this.contextSetterProperties.put(name, ctxName);
    }

    public void addContextGetterProperty(String name, String value) {
        this.contextGetterProperties.put(name, value);
    }

    public void addMessageGetterProperty(String name, SynapseXPath xpath) {
        this.messageGetterProperties.put(name, xpath);
    }

    public Map<String, Object> getStaticSetterProperties() {
        return this.staticSetterProperties;
    }

    public Map<String, SynapseXPath> getMessageSetterProperties() {
        return this.messageSetterProperties;
    }

    public Map<String, String> getContextSetterProperties() {
        return this.contextSetterProperties;
    }

    public Map<String, String> getContextGetterProperties() {
        return this.contextGetterProperties;
    }

    public Map<String, SynapseXPath> getMessageGetterProperties() {
        return this.messageGetterProperties;
    }

    public OMElement serialize(OMElement parent) {
        OMElement prop;
        OMElement prop2;
        Object value;
        OMElement pojoCommand = fac.createOMElement("pojoCommand", synNS);
        CommandMediator.saveTracingState((OMElement)pojoCommand, (Mediator)this);
        if (this.command == null) {
            throw new MediatorException("Invalid POJO Command mediator. The command class name is required");
        }
        pojoCommand.addAttribute(fac.createOMAttribute("name", nullNS, this.command));
        for (String propName : this.getStaticSetterProperties().keySet()) {
            value = this.getStaticSetterProperties().get(propName);
            prop2 = fac.createOMElement(PROP_Q.getLocalPart(), synNS);
            prop2.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            if (value instanceof String) {
                prop2.addAttribute(fac.createOMAttribute("value", nullNS, (String)value));
            } else if (value instanceof OMElement) {
                prop2.addChild((OMNode)((OMElement)value));
            } else {
                throw new MediatorException("Unable to serialize the command mediator property with the naem " + propName + " : Unknown type");
            }
            if (this.getContextGetterProperties().containsKey(propName)) {
                prop2.addAttribute(fac.createOMAttribute("context-name", nullNS, this.getContextGetterProperties().get(propName)));
            } else if (this.getMessageGetterProperties().containsKey(propName)) {
                SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getMessageGetterProperties().get(propName), (OMElement)prop2, (String)"expression");
            }
            pojoCommand.addChild((OMNode)prop2);
        }
        for (String propName : this.getMessageSetterProperties().keySet()) {
            prop = fac.createOMElement(PROP_Q.getLocalPart(), synNS);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getMessageSetterProperties().get(propName), (OMElement)prop, (String)"expression");
            if (this.getMessageGetterProperties().containsKey(propName)) {
                prop.addAttribute(fac.createOMAttribute("action", nullNS, RAUM_ACTION));
            } else if (this.getContextGetterProperties().containsKey(propName)) {
                prop.addAttribute(fac.createOMAttribute("context-name", nullNS, this.getContextGetterProperties().get(propName)));
                prop.addAttribute(fac.createOMAttribute("action", nullNS, RM_ACTION));
            } else {
                prop.addAttribute(fac.createOMAttribute("action", nullNS, RM_ACTION));
            }
            pojoCommand.addChild((OMNode)prop);
        }
        for (String propName : this.getContextSetterProperties().keySet()) {
            prop = fac.createOMElement(PROP_Q.getLocalPart(), synNS);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            prop.addAttribute(fac.createOMAttribute("context-name", nullNS, this.getContextSetterProperties().get(propName)));
            if (this.getContextGetterProperties().containsKey(propName)) {
                prop.addAttribute(fac.createOMAttribute("action", nullNS, RAUC_ACTION));
            } else if (this.getMessageGetterProperties().containsKey(propName)) {
                SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getMessageGetterProperties().get(propName), (OMElement)prop, (String)"expression");
                prop.addAttribute(fac.createOMAttribute("action", nullNS, RC_ACTION));
            } else {
                prop.addAttribute(fac.createOMAttribute("action", nullNS, RC_ACTION));
            }
            pojoCommand.addChild((OMNode)prop);
        }
        for (String propName : this.getContextGetterProperties().keySet()) {
            if (this.isSerialized(propName)) continue;
            value = this.getContextGetterProperties().get(propName);
            prop2 = fac.createOMElement(PROP_Q.getLocalPart(), synNS);
            prop2.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            prop2.addAttribute(fac.createOMAttribute("context-name", nullNS, (String)value));
            prop2.addAttribute(fac.createOMAttribute("action", nullNS, UC_ACTION));
            pojoCommand.addChild((OMNode)prop2);
        }
        for (String propName : this.getMessageGetterProperties().keySet()) {
            if (this.isSerialized(propName)) continue;
            prop = fac.createOMElement(PROP_Q.getLocalPart(), synNS);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getMessageGetterProperties().get(propName), (OMElement)prop, (String)"expression");
            prop.addAttribute(fac.createOMAttribute("action", nullNS, UM_ACTION));
            pojoCommand.addChild((OMNode)prop);
        }
        if (parent != null) {
            parent.addChild((OMNode)pojoCommand);
        }
        return pojoCommand;
    }

    private boolean isSerialized(String propName) {
        return this.getContextSetterProperties().containsKey(propName) || this.getStaticSetterProperties().containsKey(propName) || this.getMessageSetterProperties().containsKey(propName);
    }

    public void build(OMElement elem) {
        OMAttribute name = elem.getAttribute(ATT_NAME);
        if (name == null) {
            String msg = "The name of the actual POJO command implementation class is a required attribute";
            throw new MediatorException(msg);
        }
        this.command = name.getAttributeValue();
        Iterator it = elem.getChildElements();
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            if (!"property".equals(child.getLocalName())) continue;
            OMAttribute nameAttr = child.getAttribute(ATT_NAME);
            if (nameAttr != null && nameAttr.getAttributeValue() != null && !"".equals(nameAttr.getAttributeValue())) {
                this.handlePropertyAction(nameAttr.getAttributeValue(), child);
                continue;
            }
            throw new MediatorException("A POJO command mediator property must specify the name attribute");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlePropertyAction(String name, OMElement propElem) {
        OMAttribute valueAttr = propElem.getAttribute(ATT_VALUE);
        OMAttribute exprAttr = propElem.getAttribute(ATT_EXPRN);
        OMAttribute ctxNameAttr = propElem.getAttribute(ATT_CTXNAME);
        OMAttribute actionAttr = propElem.getAttribute(ATT_ACTION);
        SynapseXPath xpath = null;
        try {
            if (exprAttr != null) {
                xpath = SynapseXPathFactory.getSynapseXPath((OMElement)propElem, (QName)ATT_EXPRN);
            }
        }
        catch (JaxenException e) {
            throw new MediatorException("Error in building the expression as an SynapseXPath" + (Object)((Object)e));
        }
        if (valueAttr != null) {
            String value = valueAttr.getAttributeValue();
            if (exprAttr != null && ctxNameAttr != null) {
                throw new MediatorException("Command properties can not contain all three 'value', 'expression' and 'context-name' attributes. Only one or combination of two can be there.");
            }
            this.addStaticSetterProperty(name, value);
            if (exprAttr != null) {
                this.addMessageGetterProperty(name, xpath);
                return;
            } else {
                if (ctxNameAttr == null) return;
                this.addContextGetterProperty(name, ctxNameAttr.getAttributeValue());
            }
            return;
        } else if (propElem.getFirstElement() != null) {
            if (exprAttr != null && ctxNameAttr != null) {
                throw new MediatorException("Command properties can not contain all the 'expression' and 'context-name' attributes with a child. Only one attribute of those can co-exists with a child");
            }
            this.addStaticSetterProperty(name, propElem.getFirstElement());
            if (exprAttr != null) {
                this.addMessageGetterProperty(name, xpath);
                return;
            } else {
                if (ctxNameAttr == null) return;
                this.addContextGetterProperty(name, ctxNameAttr.getAttributeValue());
            }
            return;
        } else if (exprAttr != null && ctxNameAttr != null) {
            if (actionAttr == null || actionAttr.getAttributeValue() == null) throw new MediatorException("Action attribute is required for the command property with name " + name);
            String action = actionAttr.getAttributeValue();
            if (RM_ACTION.equals(action) || UC_ACTION.equals(action)) {
                this.addMessageSetterProperty(name, xpath);
                this.addContextGetterProperty(name, ctxNameAttr.getAttributeValue());
                return;
            } else {
                if (!RC_ACTION.equals(action) && !UM_ACTION.equals(action)) throw new MediatorException("Invalid action for the command property with the name " + name);
                this.addContextSetterProperty(name, ctxNameAttr.getAttributeValue());
                this.addMessageGetterProperty(name, xpath);
            }
            return;
        } else if (actionAttr != null && actionAttr.getAttributeValue() != null) {
            String action = actionAttr.getAttributeValue();
            if (exprAttr != null) {
                if (RM_ACTION.equals(action)) {
                    this.addMessageSetterProperty(name, xpath);
                    return;
                } else if (UM_ACTION.equals(action)) {
                    this.addMessageGetterProperty(name, xpath);
                    return;
                } else {
                    if (!RAUM_ACTION.equals(action)) throw new MediatorException("Invalid action for the command property with the name " + name);
                    this.addMessageSetterProperty(name, xpath);
                    this.addMessageGetterProperty(name, xpath);
                }
                return;
            } else {
                if (ctxNameAttr == null) throw new MediatorException("Unrecognized command property with the name " + name);
                String ctxName = ctxNameAttr.getAttributeValue();
                if (RC_ACTION.equals(action)) {
                    this.addContextSetterProperty(name, ctxName);
                    return;
                } else if (UC_ACTION.equals(action)) {
                    this.addContextGetterProperty(name, ctxName);
                    return;
                } else {
                    if (!RAUC_ACTION.equals(action)) throw new MediatorException("Invalid action for the command property with the name " + name);
                    this.addContextSetterProperty(name, ctxName);
                    this.addContextGetterProperty(name, ctxName);
                }
            }
            return;
        } else if (exprAttr != null) {
            this.addMessageSetterProperty(name, xpath);
            this.addMessageGetterProperty(name, xpath);
            return;
        } else {
            if (ctxNameAttr == null) throw new MediatorException("Unrecognized command property with the name " + name);
            String ctxName = ctxNameAttr.getAttributeValue();
            this.addContextSetterProperty(name, ctxName);
            this.addContextGetterProperty(name, ctxName);
        }
    }

    public String getTagLocalName() {
        return "pojoCommand";
    }
}

