/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.service.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.builtin.SequenceMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class TemplateMediator
extends SequenceMediator {
    private static final QName TEMPLATE_Q = new QName("http://ws.apache.org/ns/synapse", "template");
    private static final QName TEMPLATE_BODY_Q = new QName("http://ws.apache.org/ns/synapse", "sequence");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    private Collection<String> paramNames = new ArrayList<String>();
    private String eipPatternName;

    public void setParameters(Collection<String> paramNames) {
        this.paramNames = paramNames;
    }

    public void addParameter(String paramName) {
        if (paramName != null && !"".equals(paramName)) {
            this.paramNames.add(paramName);
        }
    }

    public Collection<String> getParameters() {
        return this.paramNames;
    }

    public void setName(String name) {
        this.eipPatternName = name;
    }

    public String getName() {
        return this.eipPatternName;
    }

    public OMElement serialize(OMElement parent) {
        TemplateMediator mediator = this;
        OMElement templateElem = fac.createOMElement("template", synNS);
        if (mediator.getName() != null) {
            templateElem.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
            if (mediator.getErrorHandler() != null) {
                templateElem.addAttribute(fac.createOMAttribute("onError", nullNS, mediator.getErrorHandler()));
            }
            this.serializeParams(templateElem, mediator);
            this.serializeBody(templateElem, mediator.getList());
            TemplateMediator.saveTracingState((OMElement)templateElem, (Mediator)mediator);
        }
        return templateElem;
    }

    private void serializeParams(OMElement templateElem, TemplateMediator mediator) {
        Collection<String> params = mediator.getParameters();
        for (String paramName : params) {
            if ("".equals(paramName)) continue;
            OMElement paramEl = fac.createOMElement("parameter", synNS);
            paramEl.addAttribute(fac.createOMAttribute("name", nullNS, paramName));
            templateElem.addChild((OMNode)paramEl);
        }
    }

    private void serializeBody(OMElement templateElem, List<Mediator> childMediatorList) {
        OMElement seqEl = fac.createOMElement("sequence", synNS);
        templateElem.addChild((OMNode)seqEl);
        this.serializeChildren(seqEl, childMediatorList);
    }

    public void build(OMElement elem) {
        OMElement templateElem = elem;
        OMAttribute nameAttr = templateElem.getAttribute(ATT_NAME);
        OMAttribute errorHandlerAttr = templateElem.getAttribute(ATT_ONERROR);
        if (nameAttr != null) {
            this.setName(nameAttr.getAttributeValue());
            if (errorHandlerAttr != null) {
                this.setErrorHandler(errorHandlerAttr.getAttributeValue());
            }
            this.processAuditStatus((Mediator)this, templateElem);
            this.initParameters(templateElem);
            OMElement templateBodyElem = templateElem.getFirstChildWithName(TEMPLATE_BODY_Q);
            this.addChildren(templateBodyElem, (ListMediator)this);
        } else {
            String msg = "A EIP template should be a named mediator .";
        }
    }

    private void initParameters(OMElement templateElem) {
        Iterator subElements = templateElem.getChildElements();
        ArrayList<String> paramNames = new ArrayList<String>();
        while (subElements.hasNext()) {
            OMElement child = (OMElement)subElements.next();
            if (!child.getQName().equals(PARAMETER_Q)) continue;
            OMAttribute paramNameAttr = child.getAttribute(ATT_NAME);
            if (paramNameAttr != null) {
                paramNames.add(paramNameAttr.getAttributeValue());
            }
            child.detach();
        }
        this.setParameters(paramNames);
    }
}

