/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.property;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class PropertyMediator
extends AbstractMediator {
    private String name = null;
    private String value = null;
    private SynapseXPath expression = null;
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    private int action = 0;
    private static final QName ATT_SCOPE = new QName("scope");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName ATT_PATTERN = new QName("pattern");
    private static final QName ATT_GROUP = new QName("group");
    private static final QName ATT_TYPE = new QName("type");
    private String scope = null;
    private String type = null;
    private int group = 0;
    private String pattern = null;
    private OMElement valueElement = null;

    public String getScope() {
        return this.scope;
    }

    public int getAction() {
        return this.action;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getType() {
        return this.type;
    }

    public int getGroup() {
        return this.group;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public OMElement getValueElement() {
        return this.valueElement;
    }

    public void setValueElement(OMElement valueElement) {
        this.valueElement = valueElement;
    }

    public String getTagLocalName() {
        return "property";
    }

    public OMElement serialize(OMElement parent) {
        OMElement property = fac.createOMElement("property", synNS);
        PropertyMediator.saveTracingState((OMElement)property, (Mediator)this);
        if (this.name == null) {
            throw new MediatorException("Property name not specified");
        }
        property.addAttribute(fac.createOMAttribute("name", nullNS, this.name));
        if (this.action == 0) {
            if (this.value != null) {
                property.addAttribute(fac.createOMAttribute("value", nullNS, this.value));
            } else if (this.expression != null) {
                SynapseXPathSerializer.serializeXPath((SynapseXPath)this.expression, (OMElement)property, (String)"expression");
            } else if (this.valueElement != null) {
                property.addChild((OMNode)this.valueElement);
            } else {
                throw new MediatorException("Property value, expression or inline element must be set");
            }
            if (this.pattern != null) {
                property.addAttribute(fac.createOMAttribute("pattern", nullNS, this.pattern));
                if (this.group != 0) {
                    property.addAttribute(fac.createOMAttribute("group", nullNS, Integer.toString(this.group)));
                }
            }
        } else if (this.action == 1) {
            property.addAttribute(fac.createOMAttribute("action", nullNS, "remove"));
        }
        if (this.scope != null) {
            property.addAttribute(fac.createOMAttribute("scope", nullNS, this.scope));
        }
        if (this.type != null) {
            property.addAttribute(fac.createOMAttribute("type", nullNS, this.type));
        }
        if (parent != null) {
            parent.addChild((OMNode)property);
        }
        return property;
    }

    public void build(OMElement elem) {
        OMAttribute nameAttr = elem.getAttribute(ATT_NAME);
        OMAttribute valueAttr = elem.getAttribute(ATT_VALUE);
        OMAttribute expressionAttr = elem.getAttribute(ATT_EXPRN);
        OMAttribute scopeAttr = elem.getAttribute(ATT_SCOPE);
        OMAttribute actionAttr = elem.getAttribute(ATT_ACTION);
        OMAttribute typeAttr = elem.getAttribute(ATT_TYPE);
        OMAttribute patternAttr = elem.getAttribute(ATT_PATTERN);
        OMAttribute groupAttr = elem.getAttribute(ATT_GROUP);
        OMElement valueElement = elem.getFirstElement();
        if (nameAttr == null) {
            String msg = "'name' attribute is required for the configuration of a property mediator";
            throw new MediatorException(msg);
        }
        if (!(valueAttr != null || valueElement != null || expressionAttr != null || actionAttr != null && "remove".equals(actionAttr.getAttributeValue()))) {
            String msg = "A child element or 'value' attribute or 'expression' attribute is required for a property mediator when action is SET";
            throw new MediatorException(msg);
        }
        this.name = nameAttr.getAttributeValue();
        if (actionAttr != null && "remove".equals(actionAttr.getAttributeValue())) {
            this.action = 1;
        }
        if (valueAttr != null) {
            this.value = valueAttr.getAttributeValue();
        } else if (valueElement != null) {
            this.valueElement = valueElement;
        } else if (expressionAttr != null) {
            try {
                this.expression = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_EXPRN);
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute 'expression' : " + expressionAttr.getAttributeValue();
                throw new MediatorException(msg);
            }
        }
        if (scopeAttr != null) {
            String valueStr = scopeAttr.getAttributeValue();
            if (!("axis2".equals(valueStr) || "transport".equals(valueStr) || "default".equals(valueStr) || "axis2-client".equals(valueStr))) {
                String msg = "Only 'axis2' or 'transport' or 'axis2-client' values are allowed for attribute scope for a property mediator, Unsupported scope " + valueStr;
                throw new MediatorException(msg);
            }
            this.scope = valueStr;
        }
        if (typeAttr != null) {
            this.type = typeAttr.getAttributeValue();
        }
        if (patternAttr != null) {
            this.pattern = patternAttr.getAttributeValue();
            if (groupAttr != null) {
                this.group = Integer.parseInt(groupAttr.getAttributeValue());
            }
        }
        if (this.value != null && this.type != null) {
            this.convertValue(this.value, this.type);
        }
        this.processAuditStatus((Mediator)this, elem);
    }

    private Object convertValue(String value, String type) {
        if (type == null) {
            return value;
        }
        try {
            XMLConfigConstants.DATA_TYPES dataType = XMLConfigConstants.DATA_TYPES.valueOf((String)type);
            switch (dataType) {
                case BOOLEAN: {
                    return JavaUtils.isTrueExplicitly((String)value);
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case INTEGER: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case OM: {
                    return SynapseConfigUtils.stringToOM((String)value);
                }
                case SHORT: {
                    return Short.parseShort(value);
                }
            }
            return value;
        }
        catch (IllegalArgumentException e) {
            String msg = "For value [" + value + " ] unknown type : [" + type + "] for the property mediator or the " + "property value cannot be converted into the specified type.";
            throw new SynapseException(msg, (Throwable)e);
        }
    }
}

