/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.xslt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.service.util.MediatorProperty;

public class XSLTMediator
extends AbstractMediator {
    private static final QName ATTRIBUTE_Q = new QName("http://ws.apache.org/ns/synapse", "attribute");
    private Value xsltKey = null;
    private SynapseXPath source = null;
    private String targetPropertyName = null;
    private final List<MediatorProperty> properties = new ArrayList<MediatorProperty>();
    private final List<MediatorProperty> transformerFactoryFeatures = new ArrayList<MediatorProperty>();
    private final List<MediatorProperty> transformerFactoryAttributes = new ArrayList<MediatorProperty>();
    Map<String, String> resources = new HashMap<String, String>();

    public String getTagLocalName() {
        return "xslt";
    }

    public OMElement serialize(OMElement parent) {
        OMElement xslt = fac.createOMElement("xslt", synNS);
        if (this.xsltKey == null) {
            throw new MediatorException("Invalid XSLT mediator. XSLT registry key is required");
        }
        ValueSerializer keySerializer = new ValueSerializer();
        keySerializer.serializeValue(this.xsltKey, "key", xslt);
        XSLTMediator.saveTracingState((OMElement)xslt, (Mediator)this);
        if (this.source != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.source, (OMElement)xslt, (String)"source");
        }
        if (this.targetPropertyName != null) {
            xslt.addAttribute(fac.createOMAttribute("target", nullNS, this.targetPropertyName));
        }
        this.serializeMediatorProperties(xslt, this.properties, PROP_Q);
        if (!this.transformerFactoryFeatures.isEmpty()) {
            for (MediatorProperty mp : this.transformerFactoryFeatures) {
                OMElement prop = fac.createOMElement("feature", synNS, (OMContainer)xslt);
                if (mp.getName() == null) {
                    throw new MediatorException("The Feature name is missing");
                }
                prop.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
                if (mp.getValue() != null) {
                    prop.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                    continue;
                }
                throw new MediatorException("The Feature value is missing");
            }
        }
        this.serializeMediatorProperties(xslt, this.transformerFactoryAttributes, ATTRIBUTE_Q);
        if (this.resources.size() > 0) {
            Set<String> resourceKeys = this.resources.keySet();
            Iterator<String> i = resourceKeys.iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                String value = this.resources.get(key);
                OMElement resource = fac.createOMElement("resource", synNS);
                resource.addAttribute("location", key, nullNS);
                resource.addAttribute("key", value, nullNS);
                xslt.addChild((OMNode)resource);
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)xslt);
        }
        return xslt;
    }

    public void build(OMElement elem) {
        OMAttribute attXslt = elem.getAttribute(ATT_KEY);
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        OMAttribute attTarget = elem.getAttribute(ATT_TARGET);
        QName ATT_RESOURCE_QNAME = new QName("resource");
        Iterator itr = elem.getChildrenWithName(ATT_RESOURCE_QNAME);
        HashMap<String, String> xsltResourecMap = new HashMap<String, String>();
        while (itr.hasNext()) {
            OMElement resourceElement = (OMElement)itr.next();
            QName ATT_RESOURCE_LOCATION_QNAME = new QName("location");
            QName ATT_RESOURCE_KEY_QNAME = new QName("key");
            OMAttribute locationAttr = resourceElement.getAttribute(ATT_RESOURCE_LOCATION_QNAME);
            OMAttribute keyAttr = resourceElement.getAttribute(ATT_RESOURCE_KEY_QNAME);
            xsltResourecMap.put(locationAttr.getAttributeValue(), keyAttr.getAttributeValue());
        }
        this.resources = xsltResourecMap;
        if (attXslt == null) {
            throw new MediatorException("The 'key' attribute is required for the XSLT mediator");
        }
        ValueFactory keyFactory = new ValueFactory();
        this.xsltKey = keyFactory.createValue("key", elem);
        if (attSource != null) {
            try {
                this.source = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_SOURCE);
            }
            catch (JaxenException e) {
                throw new MediatorException("Invalid XPath specified for the source attribute : " + attSource.getAttributeValue());
            }
        }
        if (attTarget != null) {
            this.targetPropertyName = attTarget.getAttributeValue();
        }
        this.processAuditStatus((Mediator)this, elem);
        for (Map.Entry entry : this.collectNameValuePairs(elem, FEATURE_Q).entrySet()) {
            boolean isFeatureEnabled;
            String value = (String)entry.getValue();
            if ("true".equals(value)) {
                isFeatureEnabled = true;
            } else if ("false".equals(value)) {
                isFeatureEnabled = false;
            } else {
                throw new MediatorException("The feature must have value true or false");
            }
            this.addFeature((String)entry.getKey(), isFeatureEnabled);
        }
        for (Map.Entry entry : this.collectNameValuePairs(elem, ATTRIBUTE_Q).entrySet()) {
            this.addAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        this.properties.addAll(XSLTMediator.getMediatorProperties((OMElement)elem));
    }

    public void addFeature(String featureName, boolean isFeatureEnable) {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(featureName);
        if (isFeatureEnable) {
            mp.setValue("true");
        } else {
            mp.setValue("false");
        }
        this.transformerFactoryFeatures.add(mp);
    }

    public void addAttribute(String name, String value) {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(name);
        mp.setValue(value);
        this.transformerFactoryAttributes.add(mp);
    }

    public List<MediatorProperty> getFeatures() {
        return this.transformerFactoryFeatures;
    }

    public List<MediatorProperty> getAttributes() {
        return this.transformerFactoryAttributes;
    }

    public void addAllProperties(List<MediatorProperty> list) {
        this.properties.addAll(list);
    }

    public List<MediatorProperty> getProperties() {
        return this.properties;
    }

    public String getTargetPropertyName() {
        return this.targetPropertyName;
    }

    public void setTargetPropertyName(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
    }

    public SynapseXPath getSource() {
        return this.source;
    }

    public void setSource(SynapseXPath source) {
        this.source = source;
    }

    public Value getXsltKey() {
        return this.xsltKey;
    }

    public void setXsltKey(Value xsltKey) {
        this.xsltKey = xsltKey;
    }

    public void addProperty(MediatorProperty p) {
        this.properties.add(p);
    }

    public void setResources(Map<String, String> resources) {
        this.resources = resources;
    }

    public Map<String, String> getResources() {
        return this.resources;
    }
}

