/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.templates.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.templates.common.TemplateInfo;
import org.wso2.carbon.mediation.templates.common.factory.TemplateInfoFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class TemplateEditorAdmin
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(TemplateEditorAdmin.class);
    public static final String WSO2_TEMPLATE_MEDIA_TYPE = "application/vnd.wso2.template";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateInfo[] getTemplates(int pageNumber, int templatePerPage) throws AxisFault {
        Lock lock = this.getLock();
        Collection templates = null;
        try {
            lock.lock();
            templates = this.getSynapseConfiguration().getSequenceTemplates().values();
            TemplateInfo[] info = TemplateInfoFactory.getSortedTemplateInfoArray(templates);
            TemplateInfo[] ret = info.length >= templatePerPage * pageNumber + templatePerPage ? new TemplateInfo[templatePerPage] : new TemplateInfo[info.length - templatePerPage * pageNumber];
            for (int i = 0; i < templatePerPage; ++i) {
                if (ret.length <= i) continue;
                ret[i] = info[templatePerPage * pageNumber + i];
            }
            TemplateInfo[] templateInfoArray = ret;
            return templateInfoArray;
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the available templates", fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTemplatesCount() throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int n = this.getSynapseConfiguration().getSequenceTemplates().values().size();
            return n;
        }
        catch (Exception e) {
            this.handleException("Couldn't get the Synapse Configuration to get Sequence count", e);
        }
        finally {
            lock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateInfo[] getDynamicTemplates(int pageNumber, int sequencePerPage) throws AxisFault {
        TemplateInfo[] ret;
        Lock lock = this.getLock();
        try {
            lock.lock();
            String[] configInfo = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            String[] govInfo = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            Object[] info = new String[configInfo.length + govInfo.length];
            int ptr = 0;
            for (String aConfigInfo : configInfo) {
                info[ptr] = "conf:" + aConfigInfo;
                ++ptr;
            }
            for (String aGovInfo : govInfo) {
                info[ptr] = "gov:" + aGovInfo;
                ++ptr;
            }
            Arrays.sort(info);
            ret = info.length >= sequencePerPage * pageNumber + sequencePerPage ? new TemplateInfo[sequencePerPage] : new TemplateInfo[info.length - sequencePerPage * pageNumber];
            for (int i = 0; i < sequencePerPage; ++i) {
                if (ret.length <= i) continue;
                TemplateInfo seq = new TemplateInfo();
                seq.setName((String)info[sequencePerPage * pageNumber + i]);
                ret[i] = seq;
            }
        }
        catch (Exception e) {
            this.handleException("Unable to get Dynamic Template Info", e);
            TemplateInfo[] templateInfoArray = null;
            return templateInfoArray;
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public int getDynamicTemplateCount() throws AxisFault {
        try {
            String[] govList = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            String[] confList = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            return confList.length + govList.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String[] getMimeTypeResult(Registry targetRegistry) throws Exception {
        String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE = ?";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", sql);
        parameters.put("1", WSO2_TEMPLATE_MEDIA_TYPE);
        org.wso2.carbon.registry.core.Collection result = targetRegistry.executeQuery(null, parameters);
        return (String[])result.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemplate(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synCfg = this.getSynapseConfiguration();
            TemplateMediator sequence = (TemplateMediator)synCfg.getSequenceTemplates().get(templateName);
            if (sequence != null) {
                synCfg.removeSequenceTemplate(templateName);
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.deleteItem(templateName, sequence.getFileName(), 9);
            } else {
                this.handleException("No defined sequence with name " + templateName + " found to delete in the Synapse configuration");
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getTemplate(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            TemplateMediator template = synapseConfiguration.getSequenceTemplate(templateName);
            if (template != null) {
                OMElement oMElement = MediatorSerializerFinder.getInstance().getSerializer((Mediator)template).serializeMediator(null, (Mediator)template);
                return oMElement;
            }
            this.handleException("Template with the name " + templateName + " does not exist");
        }
        catch (SynapseException syne) {
            this.handleException("Unable to get the sequence : " + templateName, syne);
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the Template", fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public void addTemplate(OMElement templateElement) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            if (templateElement.getLocalName().equals(XMLConfigConstants.TEMPLATE_ELT.getLocalPart())) {
                String templateName = templateElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = this.getSynapseConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding template : " + templateName + " to the configuration"));
                }
                if (config.getLocalRegistry().get(templateName) != null) {
                    this.handleException("The name '" + templateName + "' is already used within the configuration");
                } else {
                    SynapseXMLConfigurationFactory.defineTemplate((SynapseConfiguration)config, (OMElement)templateElement, (Properties)this.getSynapseConfiguration().getProperties());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added template : " + templateName + " to the configuration"));
                    }
                    TemplateMediator templ = (TemplateMediator)config.getSequenceTemplates().get(templateName);
                    templ.setFileName(ServiceBusUtils.generateFileName((String)templateName));
                    templ.init(this.getSynapseEnvironment());
                    this.persistTemplate((Mediator)templ);
                }
            } else {
                this.handleException("Invalid template definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Error adding template : " + fault.getMessage(), fault);
        }
        catch (Error error) {
            throw new AxisFault("Unexpected error occured while adding the template : " + error.getMessage(), (Throwable)error);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemplate(OMElement templateElement) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            if (templateElement != null && templateElement.getLocalName().equals(XMLConfigConstants.TEMPLATE_ELT.getLocalPart())) {
                String templateName = templateElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = this.getSynapseConfiguration();
                log.debug((Object)("Saving template : " + templateName));
                TemplateMediator preSeq = (TemplateMediator)config.getSequenceTemplates().get(templateName);
                if (preSeq == null) {
                    this.handleException("Unable to save template " + templateName + ". Does not exist");
                } else {
                    Mediator mediator = MediatorFactoryFinder.getInstance().getMediator(templateElement, this.getSynapseConfiguration().getProperties());
                    boolean statisticsEnable = preSeq.isStatisticsEnable();
                    config.removeSequenceTemplate(templateName);
                    if (mediator instanceof TemplateMediator) {
                        if (statisticsEnable) {
                            ((TemplateMediator)mediator).enableStatistics();
                        }
                        ((TemplateMediator)mediator).setFileName(preSeq.getFileName());
                        config.addSequenceTemplate(templateName, (TemplateMediator)mediator);
                    }
                    log.debug((Object)("Saved template : " + templateName + " to the configuration"));
                    TemplateMediator templ = (TemplateMediator)config.getSequenceTemplates().get(templateName);
                    if (templ != null) {
                        templ.init(this.getSynapseEnvironment());
                        this.persistTemplate((Mediator)templ);
                    }
                }
            } else {
                this.handleException("Unable to save template. Invalid definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Unable to save the Template : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableStatistics(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            TemplateMediator template = this.getSynapseConfiguration().getSequenceTemplate(templateName);
            if (template != null) {
                template.enableStatistics();
                this.persistTemplate((Mediator)template);
                String string = templateName;
                return string;
            }
            this.handleException("No defined template with name " + templateName + " found to enable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable statistics of the template " + templateName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableStatistics(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            TemplateMediator template = this.getSynapseConfiguration().getSequenceTemplate(templateName);
            if (template != null) {
                template.disableStatistics();
                this.persistTemplate((Mediator)template);
                String string = templateName;
                return string;
            }
            this.handleException("No defined template with name " + templateName + " found to disable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable statistics of the template " + templateName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableTracing(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            TemplateMediator template = this.getSynapseConfiguration().getSequenceTemplate(templateName);
            if (template != null) {
                template.setTraceState(1);
                this.persistTemplate((Mediator)template);
                String string = templateName;
                return string;
            }
            this.handleException("No defined template with name " + templateName + " found to enable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable tracing of the template " + templateName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableTracing(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            TemplateMediator template = this.getSynapseConfiguration().getSequenceTemplate(templateName);
            if (template != null) {
                template.setTraceState(0);
                this.persistTemplate((Mediator)template);
                String string = templateName;
                return string;
            }
            this.handleException("No defined template with name " + templateName + " found to disable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable tracing of the template " + templateName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    private void handleException(String message, Throwable cause) throws AxisFault {
        log.error((Object)message, cause);
        throw new AxisFault(message, cause);
    }

    private void handleException(String message) throws AxisFault {
        log.error((Object)message);
        throw new AxisFault(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDynamicTemplate(String key, OMElement omElement) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.deleteDynamicTemplate(key);
            this.addDynamicTemplate(key, omElement);
        }
        finally {
            lock.unlock();
        }
    }

    public void deleteDynamicTemplate(String key) throws AxisFault {
        SynapseConfiguration synConfig = this.getSynapseConfiguration();
        org.apache.synapse.registry.Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("The key '" + key + "' cannot be found within the configuration");
            } else {
                registry.delete(key);
            }
        } else {
            this.handleException("Unable to access the registry instance for the ESB");
        }
    }

    public void addDynamicTemplate(String key, OMElement sequence) throws AxisFault {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.reset();
        try {
            XMLPrettyPrinter.prettify((OMElement)sequence, (OutputStream)stream);
        }
        catch (Exception e) {
            this.handleException("Unable to pretty print configuration", e);
        }
        try {
            Registry registry;
            if (key.startsWith("conf:")) {
                registry = this.getConfigSystemRegistry();
                key = key.replace("conf:", "");
            } else {
                registry = this.getGovernanceRegistry();
                key = key.replace("gov:", "");
            }
            if (registry.resourceExists(key)) {
                this.handleException("Resource is already exists");
            }
            Resource resource = registry.newResource();
            resource.setMediaType(WSO2_TEMPLATE_MEDIA_TYPE);
            resource.setContent((Object)new String(stream.toByteArray()).trim());
            registry.put(key, resource);
        }
        catch (RegistryException e) {
            this.handleException("WSO2 Registry Exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getDynamicTemplate(String key) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synConfig = this.getSynapseConfiguration();
            org.apache.synapse.registry.Registry registry = synConfig.getRegistry();
            if (registry != null) {
                if (registry.getRegistryEntry(key).getType() == null) {
                    this.handleException("No resource is available by the key '" + key + "'");
                }
                OMElement oMElement = (OMElement)registry.getResource(new Entry(key), this.getSynapseConfiguration().getProperties());
                return oMElement;
            }
            this.handleException("Unable to access the registry instance for the ESB");
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDynamicTemplate(String key, OMElement sequence) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synConfig = this.getSynapseConfiguration();
            org.apache.synapse.registry.Registry registry = synConfig.getRegistry();
            if (registry != null) {
                if (registry.getRegistryEntry(key).getType() == null) {
                    this.handleException("Unable to save the template. No resource is available by the key '" + key + "'");
                }
                registry.updateResource(key, (Object)sequence);
            } else {
                this.handleException("Unable to access the registry instance for the ESB");
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void persistTemplate(Mediator template) throws AxisFault {
        if (template instanceof TemplateMediator) {
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            pm.saveItem(((TemplateMediator)template).getName(), 9);
        }
    }
}

