/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.callout;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class CalloutMediator
extends AbstractMediator {
    private static final QName ATT_URL = new QName("serviceURL");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName ATT_AXIS2XML = new QName("axis2xml");
    private static final QName ATT_REPOSITORY = new QName("repository");
    private static final QName ATT_INIT_AXIS2_CLIENT_OPTIONS = new QName("initAxis2ClientOptions");
    private static final QName Q_CONFIG = new QName("http://ws.apache.org/ns/synapse", "configuration");
    private static final QName Q_SOURCE = new QName("http://ws.apache.org/ns/synapse", "source");
    private static final QName Q_TARGET = new QName("http://ws.apache.org/ns/synapse", "target");
    private String serviceURL = null;
    private String action = null;
    private String requestKey = null;
    private SynapseXPath requestXPath = null;
    private SynapseXPath targetXPath = null;
    private String targetKey = null;
    private String clientRepository = null;
    private String axis2xml = null;
    private String initAxis2ClientOptions = null;
    public static final String DEFAULT_CLIENT_REPO = "./samples/axis2Client/client_repo";
    public static final String DEFAULT_AXIS2_XML = "./samples/axis2Client/client_repo/conf/axis2.xml";

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getInitAxis2ClientOptions() {
        return this.initAxis2ClientOptions;
    }

    public void setInitAxis2ClientOptions(String initAxis2ClientOptions) {
        this.initAxis2ClientOptions = initAxis2ClientOptions;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public void setRequestXPath(SynapseXPath requestXPath) throws JaxenException {
        this.requestXPath = requestXPath;
    }

    public void setTargetXPath(SynapseXPath targetXPath) throws JaxenException {
        this.targetXPath = targetXPath;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public SynapseXPath getRequestXPath() {
        return this.requestXPath;
    }

    public SynapseXPath getTargetXPath() {
        return this.targetXPath;
    }

    public String getClientRepository() {
        return this.clientRepository;
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public String getAxis2xml() {
        return this.axis2xml;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }

    public String getTagLocalName() {
        return "callout";
    }

    public OMElement serialize(OMElement parent) {
        OMElement callout = fac.createOMElement("callout", synNS);
        CalloutMediator.saveTracingState((OMElement)callout, (Mediator)this);
        callout.addAttribute(fac.createOMAttribute("serviceURL", nullNS, this.serviceURL));
        if (this.action != null) {
            callout.addAttribute(fac.createOMAttribute("action", nullNS, this.action));
        }
        if (this.clientRepository != null || this.axis2xml != null) {
            OMElement config = fac.createOMElement("configuration", synNS);
            if (this.clientRepository != null) {
                config.addAttribute(fac.createOMAttribute("repository", nullNS, this.clientRepository));
            }
            if (this.axis2xml != null) {
                config.addAttribute(fac.createOMAttribute("axis2xml", nullNS, this.axis2xml));
            }
            callout.addChild((OMNode)config);
        }
        if (this.initAxis2ClientOptions != null) {
            callout.addAttribute(fac.createOMAttribute("initAxis2ClientOptions", nullNS, this.initAxis2ClientOptions));
        }
        OMElement source = fac.createOMElement("source", synNS, (OMContainer)callout);
        if (this.requestXPath != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.requestXPath, (OMElement)source, (String)"xpath");
        } else if (this.requestKey != null) {
            source.addAttribute(fac.createOMAttribute("key", nullNS, this.requestKey));
        }
        OMElement target = fac.createOMElement("target", synNS, (OMContainer)callout);
        if (this.targetXPath != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.targetXPath, (OMElement)target, (String)"xpath");
        } else if (this.targetKey != null) {
            target.addAttribute(fac.createOMAttribute("key", nullNS, this.targetKey));
        }
        if (parent != null) {
            parent.addChild((OMNode)callout);
        }
        return callout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void build(OMElement elem) {
        OMAttribute attServiceURL = elem.getAttribute(ATT_URL);
        OMAttribute attAction = elem.getAttribute(ATT_ACTION);
        OMAttribute attInitAxis2ClientOptions = elem.getAttribute(ATT_INIT_AXIS2_CLIENT_OPTIONS);
        OMElement configElt = elem.getFirstChildWithName(Q_CONFIG);
        OMElement sourceElt = elem.getFirstChildWithName(Q_SOURCE);
        OMElement targetElt = elem.getFirstChildWithName(Q_TARGET);
        if (attServiceURL == null) {
            throw new MediatorException("The 'serviceURL' attribute is required for the Callout mediator");
        }
        this.serviceURL = attServiceURL.getAttributeValue();
        if (attAction != null) {
            this.action = attAction.getAttributeValue();
        }
        if (attInitAxis2ClientOptions != null) {
            this.initAxis2ClientOptions = attInitAxis2ClientOptions.getAttributeValue();
        }
        if (configElt != null) {
            OMAttribute axis2xmlAttr = configElt.getAttribute(ATT_AXIS2XML);
            OMAttribute repoAttr = configElt.getAttribute(ATT_REPOSITORY);
            if (axis2xmlAttr != null && axis2xmlAttr.getAttributeValue() != null) {
                this.axis2xml = axis2xmlAttr.getAttributeValue();
            }
            if (repoAttr != null && repoAttr.getAttributeValue() != null) {
                this.clientRepository = repoAttr.getAttributeValue();
            }
        }
        if (sourceElt == null) throw new MediatorException("The message 'source' must be specified for a Callout mediator");
        if (sourceElt.getAttribute(ATT_XPATH) != null) {
            try {
                this.requestXPath = SynapseXPathFactory.getSynapseXPath((OMElement)sourceElt, (QName)ATT_XPATH);
            }
            catch (JaxenException e) {
                throw new MediatorException("Invalid source XPath : " + sourceElt.getAttributeValue(ATT_XPATH));
            }
        } else {
            if (sourceElt.getAttribute(ATT_KEY) == null) throw new MediatorException("A 'xpath' or 'key' attribute is required for the Callout 'source'");
            this.requestKey = sourceElt.getAttributeValue(ATT_KEY);
        }
        if (targetElt == null) throw new MediatorException("The message 'target' must be specified for a Callout mediator");
        if (targetElt.getAttribute(ATT_XPATH) != null) {
            try {
                this.targetXPath = SynapseXPathFactory.getSynapseXPath((OMElement)targetElt, (QName)ATT_XPATH);
                return;
            }
            catch (JaxenException e) {
                throw new MediatorException("Invalid target XPath : " + targetElt.getAttributeValue(ATT_XPATH));
            }
        } else {
            if (targetElt.getAttribute(ATT_KEY) == null) throw new MediatorException("A 'xpath' or 'key' attribute is required for the Callout 'target'");
            this.targetKey = targetElt.getAttributeValue(ATT_KEY);
        }
    }
}

