/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.proxyadmin.observer.ProxyObserver;
import org.wso2.carbon.registry.core.service.RegistryService;

public class ConfigHolder {
    private static ConfigHolder instance;
    private static final Log log;
    private RegistryService registryService;
    private Map<Integer, ProxyObserver> proxyObservers = new HashMap<Integer, ProxyObserver>();
    private Map<Integer, SynapseEnvironmentService> synapseEnvironmentServices = new HashMap<Integer, SynapseEnvironmentService>();

    private ConfigHolder() {
    }

    public static ConfigHolder getInstance() {
        if (instance == null) {
            instance = new ConfigHolder();
        }
        return instance;
    }

    public RegistryService getRegistryService() throws ProxyAdminException {
        this.assertNull("Registry", this.registryService);
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    private void assertNull(String name, Object object) throws ProxyAdminException {
        if (object == null) {
            String message = name + " reference in the proxy admin config holder is null";
            log.error((Object)message);
            throw new ProxyAdminException(message);
        }
    }

    public ProxyObserver getProxyObsever(int id) {
        return this.proxyObservers.get(id);
    }

    public void addProxyObserver(int id, ProxyObserver observer) {
        this.proxyObservers.put(id, observer);
    }

    public void removeProxyObserver(int id) {
        this.proxyObservers.remove(id);
    }

    public SynapseEnvironmentService getSynapseEnvironmentService(int id) {
        return this.synapseEnvironmentServices.get(id);
    }

    public void addSynapseEnvironmentService(int id, SynapseEnvironmentService synapseEnvironmentService) {
        this.synapseEnvironmentServices.put(id, synapseEnvironmentService);
    }

    public void removeSynapseEnvironmentService(int id) {
        this.synapseEnvironmentServices.remove(id);
    }

    public Map<Integer, SynapseEnvironmentService> getSynapseEnvironmentServices() {
        return this.synapseEnvironmentServices;
    }

    public Map<Integer, ProxyObserver> getProxyObservers() {
        return this.proxyObservers;
    }

    static {
        log = LogFactory.getLog(ConfigHolder.class);
    }
}

