/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ProxyServiceFactory;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.util.PolicyInfo;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.proxyadmin.Entry;
import org.wso2.carbon.proxyadmin.MetaData;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.proxyadmin.ProxyData;
import org.wso2.carbon.proxyadmin.ProxyServicePolicyInfo;
import org.wso2.carbon.proxyadmin.observer.ProxyServiceParameterObserver;
import org.wso2.carbon.proxyadmin.util.ConfigHolder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class ProxyServiceAdmin
extends AbstractServiceBusAdmin {
    private static String SUCCESSFUL = "successful";
    private static String FAILED = "failed";
    private static Log log = LogFactory.getLog(ProxyServiceAdmin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableStatistics(String proxyName) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(proxyName);
            if (proxy != null) {
                if (proxy.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(proxyName);
                    config.enableStatistics();
                    proxy.configure(config);
                } else {
                    proxy.getAspectConfiguration().enableStatistics();
                }
            } else {
                log.error((Object)("Couldn't find the proxy service with name " + proxyName + " to enable statistics"));
                String string = FAILED;
                return string;
            }
            this.persistProxyService(proxy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enabled statistics on proxy service : " + proxyName));
            }
            String string = SUCCESSFUL;
            return string;
        }
        catch (Exception e) {
            this.handleException(log, "Unable to enable statistics for proxy service " + proxyName, e);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableStatistics(String proxyName) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(proxyName);
            if (proxy != null) {
                if (proxy.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(proxyName);
                    config.disableStatistics();
                    proxy.configure(config);
                } else {
                    proxy.getAspectConfiguration().disableStatistics();
                }
            } else {
                log.error((Object)("Couldn't find the proxy service with name " + proxyName + " to disable statistics"));
                String string = FAILED;
                return string;
            }
            this.persistProxyService(proxy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Disabled statistics on proxy service : " + proxyName));
            }
            String string = SUCCESSFUL;
            return string;
        }
        catch (Exception e) {
            this.handleException(log, "Unable to disable statistics for proxy service " + proxyName, e);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableTracing(String proxyName) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(proxyName);
            proxy.setTraceState(1);
            this.persistProxyService(proxy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enabled tracing on proxy service : " + proxyName));
            }
            String string = SUCCESSFUL;
            return string;
        }
        catch (Exception e) {
            this.handleException(log, "Unable to enable tracing for proxy service " + proxyName, e);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableTracing(String proxyName) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(proxyName);
            proxy.setTraceState(0);
            this.persistProxyService(proxy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Disabled tracing on proxy service : " + proxyName));
            }
            String string = SUCCESSFUL;
            return string;
        }
        catch (Exception e) {
            this.handleException(log, "Unable to disable tracing for proxy service " + proxyName, e);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    private void addProxyService(OMElement proxyServiceElement, String fileName, boolean updateMode) throws ProxyAdminException {
        block19: {
            try {
                if (proxyServiceElement.getQName().getLocalPart().equals(XMLConfigConstants.PROXY_ELT.getLocalPart())) {
                    String proxyName = proxyServiceElement.getAttributeValue(new QName("name"));
                    if (this.getSynapseConfiguration().getProxyService(proxyName) != null || this.getSynapseConfiguration().getAxisConfiguration().getService(proxyName) != null) {
                        this.handleException(log, "A service named " + proxyName + " already exists", null);
                        break block19;
                    }
                    ProxyService proxy = ProxyServiceFactory.createProxy((OMElement)proxyServiceElement, (Properties)this.getSynapseConfiguration().getProperties());
                    if (updateMode) {
                        proxy.setFileName(fileName);
                    } else if (fileName != null) {
                        proxy.setFileName(fileName);
                    } else {
                        proxy.setFileName(ServiceBusUtils.generateFileName((String)proxy.getName()));
                    }
                    try {
                        this.getSynapseConfiguration().addProxyService(proxy.getName(), proxy);
                        proxy.buildAxisService(this.getSynapseConfiguration(), this.getAxisConfig());
                        this.addParameterObserver(proxy.getName());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Added proxy service : " + proxyName));
                        }
                        if (!proxy.isStartOnLoad()) {
                            proxy.stop(this.getSynapseConfiguration());
                        }
                        if (proxy.getTargetInLineInSequence() != null) {
                            proxy.getTargetInLineInSequence().init(this.getSynapseEnvironment());
                        }
                        if (proxy.getTargetInLineOutSequence() != null) {
                            proxy.getTargetInLineOutSequence().init(this.getSynapseEnvironment());
                        }
                        if (proxy.getTargetInLineFaultSequence() != null) {
                            proxy.getTargetInLineFaultSequence().init(this.getSynapseEnvironment());
                        }
                        if (proxy.getTargetInLineEndpoint() != null) {
                            proxy.getTargetInLineEndpoint().init(this.getSynapseEnvironment());
                        }
                        this.persistProxyService(proxy);
                    }
                    catch (Exception e) {
                        this.getSynapseConfiguration().removeProxyService(proxyName);
                        try {
                            if (this.getAxisConfig().getService(proxy.getName()) != null) {
                                this.getAxisConfig().removeService(proxy.getName());
                            }
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        this.handleException(log, "Error trying to add the proxy service to the ESB configuration : " + proxy.getName(), e);
                    }
                    break block19;
                }
                this.handleException(log, "Invalid proxy service definition", null);
            }
            catch (AxisFault af) {
                this.handleException(log, "Invalid proxy service definition", (Exception)((Object)af));
            }
        }
    }

    private void modifyProxyService(OMElement proxyServiceElement) throws ProxyAdminException {
        block20: {
            try {
                if (proxyServiceElement.getQName().getLocalPart().equals(XMLConfigConstants.PROXY_ELT.getLocalPart())) {
                    String proxyName = proxyServiceElement.getAttributeValue(new QName("name"));
                    SynapseConfiguration synapseConfig = this.getSynapseConfiguration();
                    ProxyService currentProxy = synapseConfig.getProxyService(proxyName);
                    if (currentProxy == null) {
                        this.handleException(log, "A proxy service named " + proxyName + " does not exist", null);
                        break block20;
                    }
                    boolean wasRunning = currentProxy.isRunning();
                    log.debug((Object)("Deleting existing proxy service : " + proxyName));
                    AxisService axisService = synapseConfig.getAxisConfiguration().getService(proxyName);
                    if (axisService != null) {
                        axisService.getParent().addParameter("keepServiceHistory", (Object)"true");
                        this.updateAndSyncServiceParameters(currentProxy, axisService);
                    }
                    this.deleteProxyService(proxyName);
                    try {
                        log.debug((Object)("Adding proxy service : " + proxyName));
                        this.addProxyService(proxyServiceElement, currentProxy.getFileName(), true);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Modified proxy service : " + proxyName));
                        }
                        if (!wasRunning && synapseConfig.getProxyService(proxyName).isRunning()) {
                            synapseConfig.getProxyService(proxyName).stop(synapseConfig);
                        } else if (wasRunning && !synapseConfig.getProxyService(proxyName).isRunning()) {
                            synapseConfig.getProxyService(proxyName).start(synapseConfig);
                        }
                        ProxyService proxy = synapseConfig.getProxyService(proxyName);
                        if (proxy != null) {
                            if (proxy.getTargetInLineInSequence() != null) {
                                proxy.getTargetInLineInSequence().init(this.getSynapseEnvironment());
                            }
                            if (proxy.getTargetInLineOutSequence() != null) {
                                proxy.getTargetInLineOutSequence().init(this.getSynapseEnvironment());
                            }
                            if (proxy.getTargetInLineFaultSequence() != null) {
                                proxy.getTargetInLineFaultSequence().init(this.getSynapseEnvironment());
                            }
                            if (proxy.getTargetInLineEndpoint() != null) {
                                proxy.getTargetInLineEndpoint().init(this.getSynapseEnvironment());
                            }
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to save changes made for the proxy service : " + proxyName + ". Restoring the existing proxy.."));
                        try {
                            synapseConfig.addProxyService(proxyName, currentProxy);
                            this.persistProxyService(currentProxy);
                            currentProxy.buildAxisService(synapseConfig, this.getAxisConfig());
                            this.addParameterObserver(currentProxy.getName());
                            if (!wasRunning) {
                                currentProxy.stop(synapseConfig);
                            } else {
                                currentProxy.start(synapseConfig);
                            }
                        }
                        catch (Exception af) {
                            this.handleException(log, "Unable to restore the existing proxy", af);
                        }
                        this.handleException(log, "Unable to save changes made for the proxy service : " + proxyName + ". Restored the existing proxy...", e);
                    }
                    break block20;
                }
                this.handleException(log, "Invalid proxy service definition", null);
            }
            catch (AxisFault af) {
                this.handleException(log, "Invalid proxy service definition", (Exception)((Object)af));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteProxyService(String proxyName) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            SynapseConfiguration synapseConfiguration;
            ProxyService proxy;
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting proxy service : " + proxyName));
            }
            if ((proxy = (synapseConfiguration = this.getSynapseConfiguration()).getProxyService(proxyName)) != null) {
                synapseConfiguration.removeProxyService(proxyName);
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.deleteItem(proxyName, proxy.getFileName(), 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Proxy service : " + proxyName + " deleted"));
                }
                String string = SUCCESSFUL;
                return string;
            }
            log.warn((Object)("No proxy service exists by the name : " + proxyName));
            String string = FAILED;
            return string;
        }
        catch (Exception e) {
            this.handleException(log, "Unable to delete proxy service : " + proxyName, e);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    public String[] getAvailableTransports() throws ProxyAdminException {
        Object[] transports = this.getAxisConfig().getTransportsIn().keySet().toArray();
        String[] ret = new String[transports.length];
        for (int i = 0; i < transports.length; ++i) {
            ret[i] = (String)transports[i];
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableSequences() throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            Object[] sequences = this.getSynapseConfiguration().getDefinedSequences().keySet().toArray();
            String[] ret = new String[sequences.length];
            for (int i = 0; i < sequences.length; ++i) {
                ret[i] = (String)sequences[i];
            }
            String[] stringArray = ret;
            return stringArray;
        }
        catch (Exception af) {
            this.handleException(log, "Unable to get available sequences", af);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableEndpoints() throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            Object[] endpoints = this.getSynapseConfiguration().getDefinedEndpoints().keySet().toArray();
            String[] ret = new String[endpoints.length];
            for (int i = 0; i < endpoints.length; ++i) {
                ret[i] = (String)endpoints[i];
            }
            String[] stringArray = ret;
            return stringArray;
        }
        catch (Exception af) {
            this.handleException(log, "Unable to get available endpoints", af);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndpoint(String name) throws ProxyAdminException {
        String epXML = null;
        Lock lock = this.getLock();
        try {
            lock.lock();
            Endpoint ep = (Endpoint)this.getSynapseConfiguration().getDefinedEndpoints().get(name);
            epXML = EndpointSerializer.getElementFromEndpoint((Endpoint)ep).toString();
        }
        catch (Exception axisFault) {
            this.handleException(log, "No endpoint defined by the name: " + name, axisFault);
        }
        finally {
            lock.unlock();
        }
        return epXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData getMetaData() throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            MetaData metaData = new MetaData();
            String[] arr = this.getAvailableTransports();
            if (arr.length != 0) {
                metaData.setTransportsAvailable(true);
                metaData.setTransports(arr);
            }
            if ((arr = this.getAvailableEndpoints()).length != 0) {
                metaData.setEndpointsAvailable(true);
                metaData.setEndpoints(arr);
            }
            if ((arr = this.getAvailableSequences()).length != 0) {
                metaData.setSequencesAvailable(true);
                metaData.setSequences(arr);
            }
            MetaData metaData2 = metaData;
            return metaData2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startProxyService(String proxyName) throws ProxyAdminException {
        log.debug((Object)("Starting/Re-starting proxy service : " + proxyName));
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(proxyName);
            List pinnedServers = proxy.getPinnedServers();
            if (pinnedServers.isEmpty() || pinnedServers.contains(this.getServerConfigurationInformation().getServerName())) {
                proxy.start(this.getSynapseConfiguration());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Started/Re-started proxy service : " + proxyName));
            }
            String string = SUCCESSFUL;
            return string;
        }
        catch (Exception af) {
            this.handleException(log, "Unable to start/re-start proxy service: " + proxyName, af);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stopProxyService(String proxyName) throws ProxyAdminException {
        log.debug((Object)("Stopping proxy service : " + proxyName));
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            ProxyService proxy = this.getSynapseConfiguration().getProxyService(proxyName);
            List pinnedServers = proxy.getPinnedServers();
            if (pinnedServers.isEmpty() || pinnedServers.contains(this.getServerConfigurationInformation().getSynapseXMLLocation())) {
                proxy.stop(this.getSynapseConfiguration());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopped proxy service : " + proxyName));
            }
            String string = SUCCESSFUL;
            return string;
        }
        catch (Exception af) {
            this.handleException(log, "Unable to stop proxy service : " + proxyName, af);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String redeployProxyService(String proxyName) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            ProxyService currentProxy = this.getSynapseConfiguration().getProxyService(proxyName);
            if (currentProxy != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redeploying proxy service : " + proxyName));
                }
                OMElement proxyElement = ProxyServiceSerializer.serializeProxy(null, (ProxyService)currentProxy);
                this.modifyProxyService(proxyElement);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redeployed proxy service : " + proxyName));
                }
                String string = SUCCESSFUL;
                return string;
            }
        }
        catch (Exception af) {
            this.handleException(log, "Unable to redeploy proxy service : " + proxyName, af);
        }
        finally {
            lock.unlock();
        }
        return FAILED;
    }

    public String getSourceView(ProxyData pd) throws ProxyAdminException {
        return pd.retrieveOM().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyData getProxy(String proxyName) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            ProxyService ps = this.proxyForName(proxyName);
            ProxyData proxyData = this.generateProxyDataFor(ps);
            return proxyData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addProxy(ProxyData pd) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            this.addProxyService(pd.retrieveOM(), null, false);
            String string = SUCCESSFUL;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modifyProxy(ProxyData pd) throws ProxyAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
            this.modifyProxyService(pd.retrieveOM());
            String string = SUCCESSFUL;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private ProxyService proxyForName(String proxyName) throws ProxyAdminException {
        try {
            ProxyService ps = this.getSynapseConfiguration().getProxyService(proxyName);
            if (ps != null) {
                return ps;
            }
            this.handleException(log, "A proxy service named : " + proxyName + " does not exist", null);
        }
        catch (Exception af) {
            this.handleException(log, "Unable to get the proxy service definition for : " + proxyName, af);
        }
        return null;
    }

    private ProxyData generateProxyDataFor(ProxyService ps) throws ProxyAdminException {
        Map map;
        int i;
        Entry[] entries;
        int i2;
        String[] arr;
        ProxyData pd = new ProxyData();
        pd.setName(ps.getName());
        pd.setRunning(ps.isRunning());
        if (ps.getAspectConfiguration() != null && ps.getAspectConfiguration().isStatisticsEnable()) {
            pd.setEnableStatistics(true);
        } else {
            pd.setEnableStatistics(false);
        }
        if (ps.getTraceState() == 1) {
            pd.setEnableTracing(true);
        } else if (ps.getTraceState() == 0) {
            pd.setEnableTracing(false);
        }
        if (ps.getWsdlURI() != null || ps.getWSDLKey() != null || ps.getInLineWSDL() != null) {
            pd.setWsdlAvailable(true);
        } else {
            pd.setWsdlAvailable(false);
        }
        if (ps.isStartOnLoad()) {
            pd.setStartOnLoad(true);
        } else {
            pd.setStartOnLoad(false);
        }
        List list = ps.getTransports();
        if (list != null && !list.isEmpty()) {
            arr = new String[list.size()];
            for (i2 = 0; i2 < list.size(); ++i2) {
                arr[i2] = (String)list.get(i2);
            }
            pd.setTransports(arr);
        }
        if ((list = ps.getPinnedServers()) != null && !list.isEmpty()) {
            arr = new String[list.size()];
            for (i2 = 0; i2 < list.size(); ++i2) {
                arr[i2] = (String)list.get(i2);
            }
            pd.setPinnedServers(arr);
        }
        if (ps.getServiceGroup() != null) {
            pd.setServiceGroup(ps.getServiceGroup());
        }
        if (ps.getDescription() != null) {
            pd.setDescription(ps.getDescription());
        }
        SequenceMediatorSerializer seqMedSerializer = new SequenceMediatorSerializer();
        if (ps.getTargetInSequence() != null) {
            pd.setInSeqKey(ps.getTargetInSequence());
        } else if (ps.getTargetInLineInSequence() != null) {
            OMElement inSeq = seqMedSerializer.serializeAnonymousSequence(null, ps.getTargetInLineInSequence());
            inSeq.setLocalName("inSequence");
            pd.setInSeqXML(inSeq.toString());
        }
        if (ps.getTargetOutSequence() != null) {
            pd.setOutSeqKey(ps.getTargetOutSequence());
        } else if (ps.getTargetInLineOutSequence() != null) {
            OMElement outSeq = seqMedSerializer.serializeAnonymousSequence(null, ps.getTargetInLineOutSequence());
            outSeq.setLocalName("outSequence");
            pd.setOutSeqXML(outSeq.toString());
        }
        if (ps.getTargetFaultSequence() != null) {
            pd.setFaultSeqKey(ps.getTargetFaultSequence());
        } else if (ps.getTargetInLineFaultSequence() != null) {
            OMElement faultSeq = seqMedSerializer.serializeAnonymousSequence(null, ps.getTargetInLineFaultSequence());
            faultSeq.setLocalName("faultSequence");
            pd.setFaultSeqXML(faultSeq.toString());
        }
        if (ps.getTargetEndpoint() != null) {
            pd.setEndpointKey(ps.getTargetEndpoint());
        } else if (ps.getTargetInLineEndpoint() != null) {
            pd.setEndpointXML(EndpointSerializer.getElementFromEndpoint((Endpoint)ps.getTargetInLineEndpoint()).toString());
        }
        if (pd.isWsdlAvailable()) {
            Map map2;
            if (ps.getWSDLKey() != null) {
                pd.setWsdlKey(ps.getWSDLKey());
            } else if (ps.getWsdlURI() != null) {
                pd.setWsdlURI(ps.getWsdlURI().toString());
            } else if (ps.getInLineWSDL() != null) {
                pd.setWsdlDef(ps.getInLineWSDL().toString());
            }
            if (ps.getResourceMap() != null && (map2 = ps.getResourceMap().getResources()) != null && !map2.isEmpty()) {
                entries = new Entry[map2.size()];
                i = 0;
                for (Map.Entry key : map2.entrySet()) {
                    entries[i] = new Entry((String)key.getKey(), (String)key.getValue());
                    ++i;
                }
                pd.setWsdlResources(entries);
            }
        }
        if ((map = ps.getParameterMap()) != null && !map.isEmpty()) {
            entries = new Entry[map.size()];
            i = 0;
            for (Map.Entry key : map.entrySet()) {
                Object o = key.getValue();
                if (o instanceof String) {
                    entries[i] = new Entry((String)key.getKey(), (String)o);
                } else if (o instanceof OMElement) {
                    entries[i] = new Entry((String)key.getKey(), o.toString());
                }
                ++i;
            }
            pd.setServiceParams(entries);
        }
        if (ps.isWsSecEnabled()) {
            pd.setEnableSecurity(true);
        }
        if (ps.getPolicies() != null && ps.getPolicies().size() > 0) {
            ArrayList<ProxyServicePolicyInfo> policies = new ArrayList<ProxyServicePolicyInfo>();
            for (PolicyInfo policyInfo : ps.getPolicies()) {
                if (policyInfo.getPolicyKey() != null) {
                    ProxyServicePolicyInfo policy = new ProxyServicePolicyInfo();
                    policy.setKey(policyInfo.getPolicyKey());
                    if (policyInfo.getType() != 0) {
                        policy.setType(policyInfo.getMessageLable());
                    }
                    if (policyInfo.getOperation() != null) {
                        policy.setOperationName(policyInfo.getOperation().getLocalPart());
                        if (policyInfo.getOperation().getNamespaceURI() != null) {
                            policy.setOperationNS(policyInfo.getOperation().getNamespaceURI());
                        }
                    }
                    policies.add(policy);
                    continue;
                }
                throw new ProxyAdminException("A policy without a key was found on the proxy service : " + ps.getName());
            }
            pd.setPolicies(policies.toArray(new ProxyServicePolicyInfo[policies.size()]));
        }
        return pd;
    }

    private void addParameterObserver(String serviceName) throws AxisFault {
        AxisService service = this.getAxisConfig().getService(serviceName);
        ProxyServiceParameterObserver paramObserver = new ProxyServiceParameterObserver(service);
        service.addParameterObserver((ParameterObserver)paramObserver);
    }

    private void persistProxyService(ProxyService proxy) throws ProxyAdminException {
        MediationPersistenceManager pm = this.getMediationPersistenceManager();
        if (pm != null) {
            pm.saveItem(proxy.getName(), 0);
        }
    }

    private void updateAndSyncServiceParameters(ProxyService service, AxisService axisService) throws ProxyAdminException, AxisFault {
        String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/" + "services" + "/" + axisService.getName();
        String serviceParametersPath = servicePath + "/" + "parameters";
        UserRegistry registry = null;
        try {
            registry = ConfigHolder.getInstance().getRegistryService().getConfigSystemRegistry();
        }
        catch (RegistryException e) {
            this.handleException(log, "Error while accessing the Registry", (Exception)((Object)e));
        }
        try {
            Resource serviceParamsResource;
            Map params = service.getParameterMap();
            if (registry.resourceExists(serviceParametersPath) && (serviceParamsResource = registry.get(serviceParametersPath)) instanceof Collection) {
                Collection serviceParamsCollection = (Collection)serviceParamsResource;
                for (String serviceParamResourcePath : serviceParamsCollection.getChildren()) {
                    String[] elems = serviceParamResourcePath.split("/");
                    String name = elems[elems.length - 1];
                    if ("serviceType".equals(name)) continue;
                    registry.delete(serviceParamResourcePath);
                }
            }
            for (Map.Entry entry : params.entrySet()) {
                axisService.addParameter((String)entry.getKey(), entry.getValue());
            }
        }
        catch (RegistryException e) {
            this.handleException(log, "Error while accessing the Registry", (Exception)((Object)e));
        }
    }

    private void handleException(Log log, String message, Exception e) throws ProxyAdminException {
        if (e == null) {
            ProxyAdminException paf = new ProxyAdminException(message);
            log.error((Object)message, (Throwable)paf);
            throw paf;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new ProxyAdminException(message, e);
    }
}

