/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.ui.client;

import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.endpoint.stub.types.EndpointAdminStub;
import org.wso2.carbon.endpoint.stub.types.common.ConfigurationObject;
import org.wso2.carbon.endpoint.stub.types.service.EndpointMetaData;
import org.wso2.carbon.endpoint.ui.endpoints.EndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.EndpointStore;

public class EndpointAdminClient {
    private EndpointAdminStub stub;
    private static final Log log = LogFactory.getLog(EndpointAdminClient.class);

    public EndpointAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "EndpointAdmin";
        this.stub = new EndpointAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void addEndpoint(String endpointString) throws Exception {
        try {
            this.stub.addEndpoint(endpointString);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void switchOn(String name) throws Exception {
        try {
            this.stub.switchOn(name);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void switchOff(String name) throws Exception {
        try {
            this.stub.switchOff(name);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void deleteEndpoint(String epName) throws Exception {
        try {
            this.stub.deleteEndpoint(epName);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void deleteDynamicEndpoint(String key) throws Exception {
        try {
            this.stub.deleteDynamicEndpoint(key);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public ConfigurationObject[] getDependents(String epName) throws Exception {
        try {
            ConfigurationObject[] dependents = this.stub.getDependents(epName);
            if (dependents != null && dependents.length > 0 && dependents[0] != null) {
                return dependents;
            }
        }
        catch (RemoteException e) {
            this.handleFault(e);
        }
        return null;
    }

    public void updateDynamicEndpoint(String key, String epConfiguration) throws Exception {
        try {
            this.stub.deleteDynamicEndpoint(key);
            this.stub.addDynamicEndpoint(key, epConfiguration);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public String getEndpoint(String epName) throws Exception {
        try {
            return this.stub.getEndpointConfiguration(epName);
        }
        catch (Exception e) {
            this.handleFault(e);
            return null;
        }
    }

    public String[] getEndpoints() throws Exception {
        try {
            return this.stub.getEndpoints();
        }
        catch (Exception e) {
            this.handleFault(e);
            return null;
        }
    }

    public String getDynamicEndpoint(String key) throws Exception {
        String data = null;
        try {
            data = this.stub.getDynamicEndpoint(key);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
        return data;
    }

    public String[] getDynamicEndpoints() throws Exception {
        String[] endpoints = null;
        try {
            endpoints = this.stub.getDynamicEndpoints();
        }
        catch (Exception e) {
            this.handleFault(e);
        }
        return endpoints;
    }

    public EndpointService getEndpointService(EndpointMetaData metaData) throws XMLStreamException {
        String endpointString = metaData.getEndpointString();
        OMElement endpointElement = AXIOMUtil.stringToOM((String)endpointString);
        EndpointService endpointService = EndpointStore.getInstance().getEndpointService(endpointElement);
        return endpointService;
    }

    public EndpointService getEndpointService(String endpointString) throws XMLStreamException {
        OMElement endpointElement = AXIOMUtil.stringToOM((String)endpointString);
        EndpointService endpointService = EndpointStore.getInstance().getEndpointService(endpointElement);
        return endpointService;
    }

    public EndpointMetaData[] getEndpointMetaData() throws Exception {
        try {
            return this.stub.getEndpointsData();
        }
        catch (Exception e) {
            this.handleFault(e);
            return null;
        }
    }

    public void enableStatistics(String name) throws Exception {
        try {
            this.stub.enableStatistics(name);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void disableStatistics(String name) throws Exception {
        try {
            this.stub.disableStatistics(name);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void addDynamicEndpoint(String key, String epName) throws Exception {
        try {
            if (!this.stub.addDynamicEndpoint(key, epName)) {
                throw new Exception("Endpoint '" + key + "' is already found in Registry");
            }
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void saveDynamicEndpoint(String key, String epName) throws Exception {
        try {
            this.stub.saveDynamicEndpoint(key, epName);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    private void handleFault(Exception e) throws Exception {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw e;
    }

    public void saveEndpoint(String epName) throws Exception {
        try {
            this.stub.saveEndpoint(epName);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }
}

