/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.ui.util.ns;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.sequences.ui.util.SequenceEditorHelper;
import org.wso2.carbon.sequences.ui.util.ns.NameSpacesInformation;
import org.wso2.carbon.sequences.ui.util.ns.NameSpacesInformationRepository;

public class XPathFactory {
    private static final Log log = LogFactory.getLog(XPathFactory.class);
    private static final XPathFactory ourInstance = new XPathFactory();

    public static XPathFactory getInstance() {
        return ourInstance;
    }

    private XPathFactory() {
    }

    public AXIOMXPath createAXIOMXPath(String id, String source, HttpSession httpSession) {
        try {
            if (!XPathFactory.assertIDNotEmpty(id) || !XPathFactory.assertSourceNotEmpty(source)) {
                return null;
            }
            AXIOMXPath xPath = new AXIOMXPath(source.trim());
            this.addNameSpaces(xPath, id, httpSession);
            return xPath;
        }
        catch (JaxenException e) {
            String msg = "Error creating a XPath from text : " + source;
            throw new RuntimeException(msg, e);
        }
    }

    public SynapseXPath createSynapseXPath(String id, String source, HttpSession httpSession) {
        try {
            if (!XPathFactory.assertIDNotEmpty(id) || !XPathFactory.assertSourceNotEmpty(source)) {
                return null;
            }
            SynapseXPath xPath = new SynapseXPath(source.trim());
            this.addNameSpaces((AXIOMXPath)xPath, id, httpSession);
            return xPath;
        }
        catch (JaxenException e) {
            String msg = "Error creating a XPath from text : " + source;
            throw new RuntimeException(msg, e);
        }
    }

    public AXIOMXPath createAXIOMXPath(String id, HttpServletRequest request, HttpSession httpSession) {
        return this.createAXIOMXPath(id, request.getParameter(id), httpSession);
    }

    public SynapseXPath createSynapseXPath(String id, HttpServletRequest request, HttpSession httpSession) {
        return this.createSynapseXPath(id, request.getParameter(id), httpSession);
    }

    private AXIOMXPath addNameSpaces(AXIOMXPath xPath, String id, HttpSession httpSession) {
        NameSpacesInformationRepository repository = (NameSpacesInformationRepository)httpSession.getAttribute("NameSpacesInformationRepository");
        if (repository == null) {
            return xPath;
        }
        NameSpacesInformation information = repository.getNameSpacesInformation(SequenceEditorHelper.getEditingMediatorPosition(httpSession), id);
        if (information == null) {
            return xPath;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting NameSpaces :" + information + " for id :" + id));
        }
        Iterator<String> iterator = information.getPrefixes();
        while (iterator.hasNext()) {
            String prefix = iterator.next();
            String nsURI = information.getNameSpaceURI(prefix);
            try {
                xPath.addNamespace(prefix, nsURI);
            }
            catch (JaxenException je) {
                String msg = "Error adding declared name space with prefix : " + prefix + "and uri : " + nsURI + " to the xPath : " + xPath;
                throw new RuntimeException(msg, je);
            }
        }
        information.removeAllNameSpaces();
        return xPath;
    }

    private static boolean assertIDNotEmpty(String id) {
        if (id == null || "".equals(id)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided id is empty or null ,returning a null as XPath");
            }
            return false;
        }
        return true;
    }

    private static boolean assertSourceNotEmpty(String source) {
        if (source == null || "".equals(source)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided source is empty or null ,returning a null as XPath");
            }
            return false;
        }
        return true;
    }
}

