/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.ui.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.mediator.service.MediatorService;
import org.wso2.carbon.mediator.service.MediatorStore;
import org.wso2.carbon.mediator.service.builtin.SequenceMediator;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.ui.client.EditorUIClient;
import org.wso2.carbon.sequences.ui.factory.EditorUIClientFactory;
import org.wso2.carbon.sequences.ui.factory.impl.SequenceEditorClientFactory;
import org.wso2.carbon.sequences.ui.util.ns.NameSpacesRegistrar;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;

public class SequenceEditorHelper {
    public static final String BUNDLE = "org.wso2.carbon.sequences.ui.i18n.Resources";

    public static OMElement parseStringToElement(String xml) throws SequenceEditorException {
        OMElement elem;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)bais);
            elem = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new SequenceEditorException("Couldn't parse the sequence source as XML", (Throwable)e);
        }
        return elem;
    }

    public static SequenceMediator parseStringToSequence(String sequenceXML) throws SequenceEditorException {
        OMElement elem = SequenceEditorHelper.parseStringToElement(sequenceXML);
        if (elem != null) {
            MediatorService service = MediatorStore.getInstance().getMediatorService(elem);
            if (service != null) {
                SequenceMediator sequence = (SequenceMediator)service.getMediator();
                sequence.build(elem);
                return sequence;
            }
            return null;
        }
        return null;
    }

    public static Mediator parseStringToMediator(String mediatorXML) throws SequenceEditorException {
        OMElement elem = SequenceEditorHelper.parseStringToElement(mediatorXML);
        if (elem != null) {
            MediatorService service = MediatorStore.getInstance().getMediatorService(elem);
            if (service != null) {
                Mediator m = service.getMediator();
                m.build(elem);
                return m;
            }
            return null;
        }
        return null;
    }

    public static String parseSequenceToString(SequenceMediator sequence) {
        OMElement elem = sequence.serialize(null);
        if (elem != null) {
            return elem.toString();
        }
        return null;
    }

    public static String parseSequenceToPrettyfiedString(SequenceMediator sequence) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(SequenceEditorHelper.parseSequenceToString(sequence).getBytes());
        XMLPrettyPrinter printer = new XMLPrettyPrinter((InputStream)byteArrayInputStream);
        return printer.xmlFormat();
    }

    public static OMElement parseAnonSequenceToOM(SequenceMediator seqMediator) {
        OMElement elem = seqMediator.serialize(null);
        elem.removeAttribute(elem.getAttribute(new QName("name")));
        return elem;
    }

    public static String parseAnonSequenceToString(SequenceMediator seqMediator, String targetSeqName) {
        OMElement elem = SequenceEditorHelper.parseAnonSequenceToOM(seqMediator);
        elem.setLocalName(targetSeqName + "Sequence");
        return elem.toString();
    }

    public static String parseAnonSequenceToPrettyfiedString(SequenceMediator seqMediator, String targetSeqName) {
        OMElement elem = SequenceEditorHelper.parseAnonSequenceToOM(seqMediator);
        elem.setLocalName(targetSeqName + "Sequence");
        ByteArrayInputStream stream = new ByteArrayInputStream(elem.toString().getBytes());
        XMLPrettyPrinter printer = new XMLPrettyPrinter((InputStream)stream);
        return printer.xmlFormat();
    }

    public static String parseAnonSequenceToPrettyfiedString(SequenceMediator seqMediator) {
        OMElement elem = SequenceEditorHelper.parseAnonSequenceToOM(seqMediator);
        ByteArrayInputStream stream = new ByteArrayInputStream(elem.toString().getBytes());
        XMLPrettyPrinter printer = new XMLPrettyPrinter((InputStream)stream);
        return printer.xmlFormat();
    }

    public static Mediator getMediatorAt(AbstractListMediator sequence, String position) {
        if (position != null && sequence != null) {
            int i = position.indexOf(".");
            if (i == -1) {
                if ("00".equals(position)) {
                    return sequence;
                }
                int pos = Integer.parseInt(position);
                if (pos < sequence.getList().size()) {
                    return (Mediator)sequence.getList().get(pos);
                }
                return sequence;
            }
            int index = Integer.parseInt(position.substring(0, i));
            return SequenceEditorHelper.getMediatorAt((AbstractListMediator)sequence.getList().get(index), position.substring(i + 1));
        }
        return null;
    }

    public static Mediator getEditingMediator(HttpServletRequest request, HttpSession session) {
        String mediatorPosition = request.getParameter("mediatorID");
        SequenceMediator sequence = SequenceEditorHelper.getEditingSequence(session);
        if (mediatorPosition != null && !"null".equals(mediatorPosition)) {
            Mediator editingMediator = SequenceEditorHelper.getMediatorAt((AbstractListMediator)sequence, mediatorPosition.substring(9));
            session.setAttribute("editingMediator", (Object)editingMediator);
            session.setAttribute("editingMediatorPosition", (Object)mediatorPosition);
            return editingMediator;
        }
        return (Mediator)session.getAttribute("editingMediator");
    }

    public static String getEditingMediatorPosition(HttpSession session) {
        return (String)session.getAttribute("editingMediatorPosition");
    }

    public static SequenceMediator getEditingSequence(HttpSession session) {
        return (SequenceMediator)session.getAttribute("editingSequence");
    }

    public static SequenceMediator getEditingActualSequence(HttpSession session) {
        return SequenceEditorHelper.getEditingSequence(session);
    }

    public static void removeEditingSequence(HttpSession session) {
        session.removeAttribute("editingSequence");
    }

    public static String getEditingSequenceAction(HttpSession session) {
        return session.getAttribute("editingSequenceAction") != null ? session.getAttribute("editingSequenceAction").toString() : "anonify";
    }

    public static void removeEditingSequenceAction(HttpSession session) {
        session.removeAttribute("editingSequenceAction");
    }

    public static boolean isIconAvailable(MediatorService mediatorService, ServletConfig config) {
        Set resourcePaths = config.getServletContext().getResourcePaths("/" + mediatorService.getUIFolderName() + "-mediator/images");
        return resourcePaths != null && resourcePaths.contains("/" + mediatorService.getUIFolderName() + "-mediator/images/mediator-icon.gif");
    }

    public static String getMediatorHTML(Mediator mediator, boolean last, String position, ServletConfig config, Mediator before, Mediator after, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE, locale);
        MediatorService mediatorInfo = MediatorStore.getInstance().getMediatorService(mediator.getTagLocalName());
        String mediatorName = mediatorInfo != null ? mediatorInfo.getDisplayName() : mediator.getTagLocalName();
        String url = "../" + mediatorInfo.getUIFolderName() + "-mediator/images/mediator-icon.gif";
        String mediatorIconURL = mediatorInfo != null && SequenceEditorHelper.isIconAvailable(mediatorInfo, config) ? url : "./images/node-normal.gif";
        String html = "<div class=\"minus-icon\" onclick=\"treeColapse(this)\"></div>";
        if (!(mediator instanceof AbstractListMediator) || ((AbstractListMediator)mediator).getList().isEmpty()) {
            html = "<div class=\"dot-icon\"></div>";
        }
        html = html + "<div class=\"mediators\" style=\"background-image: url(" + mediatorIconURL + ") !important\" id=\"mediator-" + position + "\">" + "<a class=\"mediatorLink\" id=\"mediator-" + position + "\">" + mediatorName + "</a><div class=\"sequenceToolbar\" style=\"display:none\" >";
        if (mediator instanceof AbstractListMediator) {
            if (mediatorInfo == null || mediatorInfo.isAddChildEnabled()) {
                html = html + "<div><a class=\"addChildStyle\">" + bundle.getString("sequence.add.child.action") + "</a></div>" + "<div class=\"sequenceSep\">&nbsp;</div>";
            }
            if (mediatorInfo == null || mediatorInfo.isAddSiblingEnabled()) {
                html = html + "<div><a class=\"addSiblingStyle\">" + bundle.getString("sequence.add.sibling.action") + "</a></div>" + "<div class=\"sequenceSep\">&nbsp;</div>";
            }
            html = html + "<div><a class=\"deleteStyle\">" + bundle.getString("sequence.delete.action") + "</a></div>";
            if (before != null && MediatorStore.getInstance().getMediatorService(before.getTagLocalName()).isMovingAllowed() && mediatorInfo.isMovingAllowed()) {
                html = html + "<div class=\"sequenceSep\">&nbsp;</div><div><a class=\"moveUpStyle\" title=\"" + bundle.getString("mediator.move.up") + "\"></a></div>";
            }
            if (after != null && MediatorStore.getInstance().getMediatorService(after.getTagLocalName()).isMovingAllowed() && mediatorInfo.isMovingAllowed()) {
                html = html + "<div class=\"sequenceSep\">&nbsp;</div><div><a class=\"moveDownStyle\" title=\"" + bundle.getString("mediator.move.down") + "\"></a></div>";
            }
            html = html + "</div></div>";
            AbstractListMediator listMediator = (AbstractListMediator)mediator;
            if (!listMediator.getList().isEmpty()) {
                html = last ? "<li>" + html : "<li class=\"vertical-line\">" + html;
                html = html + "<div class=\"branch-node\"></div>";
                html = html + "<ul class=\"child-list\">";
                int count = listMediator.getList().size();
                int mediatorPosition = 0;
                for (Mediator med : listMediator.getList()) {
                    Mediator beforeMed = mediatorPosition > 0 ? (Mediator)listMediator.getList().get(mediatorPosition - 1) : null;
                    Mediator afterMed = mediatorPosition + 1 < listMediator.getList().size() ? (Mediator)listMediator.getList().get(mediatorPosition + 1) : null;
                    html = html + SequenceEditorHelper.getMediatorHTML(med, --count == 0, position + "." + mediatorPosition, config, beforeMed, afterMed, locale);
                    ++mediatorPosition;
                }
                html = html + "</ul>";
            } else {
                html = !last ? "<li>" + html + "<div class=\"vertical-line-alone\"/>" : "<li>" + html;
            }
        } else {
            if (mediatorInfo == null || mediatorInfo.isAddSiblingEnabled()) {
                html = html + "<div><a class=\"addSiblingStyle\">" + bundle.getString("sequence.add.sibling.action") + "</a></div>" + "<div class=\"sequenceSep\">&nbsp;</div>";
            }
            html = html + "<div><a class=\"deleteStyle\">" + bundle.getString("sequence.delete.action") + "</a></div>";
            if (before != null && MediatorStore.getInstance().getMediatorService(before.getTagLocalName()).isMovingAllowed() && mediatorInfo.isMovingAllowed()) {
                html = html + "<div class=\"sequenceSep\">&nbsp;</div><div><a class=\"moveUpStyle\" title=\"" + bundle.getString("mediator.move.up") + "\"></a></div>";
            }
            if (after != null && MediatorStore.getInstance().getMediatorService(after.getTagLocalName()).isMovingAllowed() && mediatorInfo.isMovingAllowed()) {
                html = html + "<div class=\"sequenceSep\">&nbsp;</div><div><a class=\"moveDownStyle\" title=\"" + bundle.getString("mediator.move.down") + "\"></a></div>";
            }
            html = html + "</div></div>";
            html = !last ? "<li>" + html + "<div class=\"vertical-line-alone\"/>" : "<li>" + html;
        }
        return html + "</li>";
    }

    public static Mediator getNewMediator(String mediatorName) throws RemoteException {
        MediatorStore store = MediatorStore.getInstance();
        MediatorService mediatorInfo = store.getMediatorService(mediatorName);
        if (mediatorInfo != null) {
            return mediatorInfo.getMediator();
        }
        throw new RuntimeException("Couldn't find the mediator information in the mediator store for the mediator with logical name " + mediatorName);
    }

    public static Mediator removeMediatorAt(AbstractListMediator sequence, String position) {
        if (position != null && sequence != null) {
            int i = position.indexOf(".");
            if (i == -1) {
                if ("00".equals(position)) {
                    return null;
                }
                return (Mediator)sequence.getList().remove(Integer.parseInt(position));
            }
            int index = Integer.parseInt(position.substring(0, i));
            return SequenceEditorHelper.removeMediatorAt((AbstractListMediator)sequence.getList().get(index), position.substring(i + 1));
        }
        return null;
    }

    public static boolean deleteMediatorAt(String position, HttpSession session) {
        SequenceMediator sequence = SequenceEditorHelper.getEditingSequence(session);
        return SequenceEditorHelper.removeMediatorAt((AbstractListMediator)sequence, position.substring(9)) != null;
    }

    public static void moveMediatorDown(String position, HttpSession session) {
        SequenceMediator sequence = SequenceEditorHelper.getEditingSequence(session);
        Mediator movingMediator = SequenceEditorHelper.removeMediatorAt((AbstractListMediator)sequence, position.substring(9));
        SequenceEditorHelper.insertMediator((AbstractListMediator)sequence, movingMediator, position.substring(9), 1);
    }

    public static void moveMediatorUp(String position, HttpSession session) {
        SequenceMediator sequence = SequenceEditorHelper.getEditingSequence(session);
        Mediator movingMediator = SequenceEditorHelper.removeMediatorAt((AbstractListMediator)sequence, position.substring(9));
        SequenceEditorHelper.insertMediator((AbstractListMediator)sequence, movingMediator, position.substring(9), -1);
    }

    public static boolean insertMediator(AbstractListMediator listMediator, Mediator mediator, String position, int after) {
        if (position != null && listMediator != null && mediator != null) {
            int i = position.indexOf(".");
            if (i == -1) {
                if ("00".equals(position)) {
                    listMediator.addChild(mediator);
                    return false;
                }
                listMediator.getList().add(Integer.parseInt(position) + after, mediator);
                return true;
            }
            int index = Integer.parseInt(position.substring(0, i));
            return SequenceEditorHelper.insertMediator((AbstractListMediator)listMediator.getList().get(index), mediator, position.substring(i + 1), after);
        }
        return false;
    }

    public static String serializeMediator(Mediator mediator) throws SequenceEditorException {
        OMElement ele = mediator.serialize(null);
        if (ele != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ele.toString().getBytes());
            XMLPrettyPrinter printer = new XMLPrettyPrinter((InputStream)byteArrayInputStream);
            return printer.xmlFormat();
        }
        return null;
    }

    public static boolean isRedirected(HttpServletRequest request) {
        String followupAction = request.getParameter("followupAction");
        return followupAction == null || "source".equals(followupAction);
    }

    public static void clearSessionCache(HttpSession session) {
        NameSpacesRegistrar.getInstance().unRegisterNameSpaces(session);
        session.removeAttribute("throttle_policy_map");
        session.removeAttribute("mediator.position");
    }

    public static EditorUIClient getClientForEditor(ServletConfig config, HttpSession session) {
        EditorUIClientFactory factory = SequenceEditorHelper.getFactoryFrom(session);
        return factory.createClient(config, session);
    }

    public static SequenceMediator getSequenceForEditor(HttpSession session) {
        EditorUIClientFactory factory = SequenceEditorHelper.getFactoryFrom(session);
        return (SequenceMediator)factory.createEditingMediator();
    }

    public static String getUIMetadataForEditor(String key, HttpSession session) {
        EditorUIClientFactory factory = SequenceEditorHelper.getFactoryFrom(session);
        String tag = factory.getUIMetaInfo().get(key);
        if (tag != null && !"".equals(tag)) {
            return tag;
        }
        return key;
    }

    private static EditorUIClientFactory getFactoryFrom(HttpSession session) {
        EditorUIClientFactory factory = (EditorUIClientFactory)session.getAttribute("editorClientFactory");
        if (factory == null) {
            factory = new SequenceEditorClientFactory();
        }
        return factory;
    }

    public static String getForwardToFrom(HttpSession session) {
        EditorUIClientFactory factory = SequenceEditorHelper.getFactoryFrom(session);
        String mode = SequenceEditorHelper.getEditorMode(factory);
        if (mode == null || mode != null && "sequence".equals(mode)) {
            return "list_sequences.jsp";
        }
        return factory.getUIMetaInfo().get("forwardPage");
    }

    private static String getEditorMode(EditorUIClientFactory factory) {
        return factory.getUIMetaInfo().get("editorMode");
    }

    public static String getEditorMode(HttpSession session) {
        return SequenceEditorHelper.getEditorMode(SequenceEditorHelper.getFactoryFrom(session));
    }
}

