/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.processor.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MessageProcessorFactory;
import org.apache.synapse.config.xml.MessageProcessorSerializer;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.message.processors.MessageProcessor;
import org.apache.synapse.message.processors.ScheduledMessageProcessor;
import org.apache.synapse.message.processors.forward.BlockingMessageSender;
import org.apache.synapse.message.processors.forward.MessageForwardingProcessorView;
import org.apache.synapse.message.processors.forward.ScheduledMessageForwardingProcessor;
import org.apache.synapse.message.processors.sampler.SamplingProcessor;
import org.apache.synapse.message.processors.sampler.SamplingProcessorView;
import org.apache.synapse.message.store.MessageStore;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;

public class MessageProcessorAdminService
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(MessageProcessorAdminService.class);
    public static final int MSGS_PER_PAGE = 10;

    public void addMessageProcessor(String xml) throws AxisFault {
        try {
            OMElement msElem = this.createElement(xml);
            MessageProcessor messageProcessor = MessageProcessorFactory.createMessageProcessor((OMElement)msElem);
            if (messageProcessor != null && messageProcessor.getName() != null) {
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                String fileName = ServiceBusUtils.generateFileName((String)messageProcessor.getName());
                messageProcessor.init(this.getSynapseEnvironment());
                messageProcessor.setFileName(fileName);
                synapseConfiguration.addMessageProcessor(messageProcessor.getName(), messageProcessor);
                MediationPersistenceManager mp = this.getMediationPersistenceManager();
                mp.saveItem(messageProcessor.getName(), 11);
            } else {
                String message = "Unable to create Message Processor ";
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to create Message Processor ";
            this.handleException(log, message, e);
        }
    }

    public void modifyMessageProcessor(String xml) throws AxisFault {
        try {
            OMElement msElem = this.createElement(xml);
            MessageProcessor messageProcessor = MessageProcessorFactory.createMessageProcessor((OMElement)msElem);
            if (messageProcessor != null && messageProcessor.getName() != null) {
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                MessageProcessor removedProcessor = synapseConfiguration.removeMessageProcessor(messageProcessor.getName());
                if (removedProcessor != null) {
                    removedProcessor.destroy();
                }
                messageProcessor.init(this.getSynapseEnvironment());
                String fileName = ServiceBusUtils.generateFileName((String)messageProcessor.getName());
                messageProcessor.setFileName(fileName);
                synapseConfiguration.addMessageProcessor(messageProcessor.getName(), messageProcessor);
                MediationPersistenceManager mp = this.getMediationPersistenceManager();
                mp.saveItem(messageProcessor.getName(), 11);
            } else {
                String message = "Unable to Update Message Processor ";
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to Modify Message Processor ";
            this.handleException(log, message, e);
        }
    }

    public String getMessageProcessor(String name) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(name);
        String xml = null;
        if (processor != null) {
            xml = MessageProcessorSerializer.serializeMessageProcessor(null, (MessageProcessor)processor).toString();
        } else {
            this.handleException(log, "Message Processor " + name + " does not exist", null);
        }
        return xml;
    }

    public void deleteMessageProcessor(String name) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        if (configuration.getMessageProcessors().containsKey(name)) {
            MessageProcessor processor = configuration.removeMessageProcessor(name);
            String fileName = processor.getFileName();
            if (processor != null) {
                processor.destroy();
            }
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            pm.deleteItem(processor.getName(), fileName, 11);
        } else {
            this.handleException(log, "Message Store " + name + " does not exist", null);
        }
    }

    public String[] getMessageProcessorNames() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        Set names = configuration.getMessageProcessors().keySet();
        return names.toArray(new String[names.size()]);
    }

    public String[] getMessageIds(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        String[] messageIds = null;
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    List msgList = view.messageIdList();
                    messageIds = msgList.toArray(new String[msgList.size()]);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return messageIds;
    }

    public String getEnvelope(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        String message = null;
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    message = view.getEnvelope(messageId);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return message;
    }

    public void deleteMessage(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.delete(messageId);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void deleteFirstMessages(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageForwardingProcessorView view;
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor && !(view = ((ScheduledMessageForwardingProcessor)processor).getView()).isActive()) {
                configuration.getMessageStore(processor.getMessageStoreName()).remove();
                log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor");
            throw new AxisFault(e.getMessage());
        }
    }

    public void deleteAllMessages(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.deleteAll();
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void resend(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.resend(messageId);
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void resendFirstMessage(String processorName, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                BlockingMessageSender sender = ((ScheduledMessageForwardingProcessor)processor).getSender();
                if (!view.isActive()) {
                    MessageStore messageStore;
                    MessageContext msgCtx;
                    if (messageId != null && !"".equals(messageId.trim()) && (msgCtx = (messageStore = configuration.getMessageStore(processor.getMessageStoreName())).get(messageId)) != null) {
                        this.sendMessage(msgCtx, false, messageStore, sender);
                        messageStore.remove();
                    }
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void resendAll(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    view.resendAll();
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public int getSize(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        int size = 0;
        try {
            MessageProcessor processor;
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName) && (processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName)) instanceof ScheduledMessageProcessor) {
                MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                if (!view.isActive()) {
                    size = view.getSize();
                } else {
                    log.warn((Object)"Can't access Scheduled Message Forwarding Processor - Processor is active");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return size;
    }

    public boolean isActive(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        boolean active = false;
        try {
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName)) {
                MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName);
                if (processor instanceof ScheduledMessageForwardingProcessor) {
                    MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                    active = view.isActive();
                } else if (processor instanceof SamplingProcessor) {
                    SamplingProcessorView view = ((SamplingProcessor)processor).getView();
                    active = view.isActive();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
        return active;
    }

    public void activate(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName)) {
                MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName);
                if (processor instanceof ScheduledMessageForwardingProcessor) {
                    MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                    if (!view.isActive()) {
                        view.activate();
                    } else {
                        log.warn((Object)"Scheduled Message Forwarding Processor is already active");
                    }
                } else if (processor instanceof SamplingProcessor) {
                    SamplingProcessorView view = ((SamplingProcessor)processor).getView();
                    if (!view.isActive()) {
                        view.activate();
                    } else {
                        log.warn((Object)"Sampling Processor is already active");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    public void deactivate(String processorName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        try {
            assert (configuration != null);
            if (configuration.getMessageProcessors().containsKey(processorName)) {
                MessageProcessor processor = (MessageProcessor)configuration.getMessageProcessors().get(processorName);
                if (processor instanceof ScheduledMessageForwardingProcessor) {
                    MessageForwardingProcessorView view = ((ScheduledMessageForwardingProcessor)processor).getView();
                    if (view.isActive()) {
                        view.deactivate();
                    } else {
                        log.warn((Object)"Scheduled Message Forwarding Processor - already deActive");
                    }
                } else if (processor instanceof SamplingProcessor) {
                    SamplingProcessorView view = ((SamplingProcessor)processor).getView();
                    if (view.isActive()) {
                        view.deactivate();
                    } else {
                        log.warn((Object)"Sampling Message Processor - already in the deactivated state");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error While accessing MessageProcessor view ");
            throw new AxisFault(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(MessageContext messageContext, boolean delete, MessageStore messageStore, BlockingMessageSender sender) throws Exception {
        String targetEp;
        if (messageContext == null) throw new Exception("Error! Cant send Message Context : " + messageContext);
        Set proSet = messageContext.getPropertyKeySet();
        if (proSet != null && proSet.contains("blocking.sender.error")) {
            proSet.remove("blocking.sender.error");
        }
        if ((targetEp = (String)messageContext.getProperty("target.endpoint")) == null) {
            String logMsg = "Property target.endpoint not found in the message context , Hence removing the message ";
            log.warn((Object)logMsg);
            if (!delete) throw new Exception(logMsg);
            messageStore.poll();
            throw new Exception(logMsg);
        }
        Endpoint ep = messageContext.getEndpoint(targetEp);
        if (!(ep instanceof AddressEndpoint)) {
            String logMsg = "Address Endpoint Named " + targetEp + " not found.Hence removing " + "the message form store";
            log.warn((Object)logMsg);
            if (!delete) throw new Exception(logMsg);
            messageStore.poll();
            throw new Exception(logMsg);
        }
        AddressEndpoint addEp = (AddressEndpoint)ep;
        String addressUrl = addEp.getDefinition().getAddress();
        try {
            MessageContext outCtx = sender.send(addEp.getDefinition(), messageContext);
            if (!delete) return;
            messageStore.poll();
            return;
        }
        catch (Exception e) {
            log.error((Object)"Error Forwarding Message ", (Throwable)e);
            throw new Exception(e);
        }
    }

    public String getClassName(String name) throws AxisFault {
        MessageProcessor processorImpl = this.getMessageProcessorImpl(name);
        if (processorImpl != null) {
            return processorImpl.getClass().getName();
        }
        this.handleException(log, "Message Processor " + name + " does not exist !!!", null);
        return null;
    }

    private void handleException(Log log, String message, Exception e) throws AxisFault {
        if (e == null) {
            AxisFault exception = new AxisFault(message);
            log.error((Object)message, (Throwable)exception);
            throw exception;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    private MessageProcessor getMessageProcessorImpl(String name) {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        return (MessageProcessor)configuration.getMessageProcessors().get(name);
    }

    private OMElement createElement(String str) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }
}

