/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.clazz;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class ClassMediator
extends AbstractMediator {
    private String mediator;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public String getMediator() {
        return this.mediator;
    }

    public void setMediator(String mediator) {
        this.mediator = mediator;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Map getProperties() {
        return this.properties;
    }

    public OMElement serialize(OMElement parent) {
        OMElement clazz = fac.createOMElement("class", synNS);
        ClassMediator.saveTracingState((OMElement)clazz, (Mediator)this);
        if (this.mediator == null) {
            throw new MediatorException("Invalid class mediator. The class name is required");
        }
        clazz.addAttribute(fac.createOMAttribute("name", nullNS, this.mediator));
        for (String propName : this.properties.keySet()) {
            Object o = this.properties.get(propName);
            OMElement prop = fac.createOMElement(PROP_Q);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            if (o instanceof String) {
                prop.addAttribute(fac.createOMAttribute("value", nullNS, (String)o));
            } else {
                prop.addChild((OMNode)o);
            }
            clazz.addChild((OMNode)prop);
        }
        if (parent != null) {
            parent.addChild((OMNode)clazz);
        }
        return clazz;
    }

    public void build(OMElement elem) {
        OMAttribute name = elem.getAttribute(ATT_NAME);
        if (name == null) {
            String msg = "The name of the actual mediator class is a required attribute";
            throw new MediatorException(msg);
        }
        this.mediator = name.getAttributeValue();
        Iterator it = elem.getChildrenWithName(PROP_Q);
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            String propName = child.getAttribute(ATT_NAME).getAttributeValue();
            if (propName == null) {
                throw new MediatorException("A Class mediator property must specify the name attribute");
            }
            if (child.getAttribute(ATT_VALUE) != null) {
                String value = child.getAttribute(ATT_VALUE).getAttributeValue();
                this.properties.put(propName, value);
                continue;
            }
            OMElement omElt = child.getFirstElement();
            if (omElt != null) {
                this.properties.put(propName, omElt);
                continue;
            }
            throw new MediatorException("A Class mediator property must specify name and value attributes, or a name and a child XML fragment");
        }
        this.processAuditStatus((Mediator)this, elem);
    }

    public String getTagLocalName() {
        return "class";
    }
}

