/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin.ui.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.proxyadmin.stub.ProxyServiceAdminStub;
import org.wso2.carbon.proxyadmin.stub.types.carbon.Entry;
import org.wso2.carbon.proxyadmin.stub.types.carbon.MetaData;
import org.wso2.carbon.proxyadmin.stub.types.carbon.ProxyData;

public class ProxyServiceAdminClient {
    private static final String FAILED = "failed";
    private static final Log log = LogFactory.getLog(ProxyServiceAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.proxyadmin.ui.i18n.Resources";
    private ResourceBundle bundle;
    public ProxyServiceAdminStub stub;

    public ProxyServiceAdminClient(ConfigurationContext configCtx, String backendServerURL, String cookie, Locale locale) throws AxisFault {
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        String serviceURL = backendServerURL + "ProxyServiceAdmin";
        this.stub = new ProxyServiceAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public String disableStatistics(String proxyName60) throws AxisFault {
        try {
            return this.stub.disableStatistics(proxyName60);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.disable.statistics.for.proxy.service"), proxyName60), e);
            return FAILED;
        }
    }

    public String[] getAvailableEndpoints() throws AxisFault {
        try {
            return this.stub.getAvailableEndpoints();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.get.declared.endpoints"), e);
            return null;
        }
    }

    public String redeployProxyService(String proxyName65) throws AxisFault {
        try {
            return this.stub.redeployProxyService(proxyName65);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.redeploy.proxy.service"), proxyName65), e);
            return FAILED;
        }
    }

    public void addProxy(ProxyData pd67) throws AxisFault {
        try {
            this.stub.addProxy(pd67);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.add.proxy.service"), pd67.getName()), e);
        }
    }

    public void modifyProxy(ProxyData pd69) throws AxisFault {
        try {
            this.stub.modifyProxy(pd69);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.modify.proxy.service"), pd69.getName()), e);
        }
    }

    public String disableTracing(String proxyName71) throws AxisFault {
        try {
            return this.stub.disableTracing(proxyName71);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.disable.tracing.for.proxy.service"), proxyName71), e);
            return FAILED;
        }
    }

    public MetaData getMetaData() throws AxisFault {
        try {
            return this.stub.getMetaData();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.get.metadata"), e);
            return null;
        }
    }

    public ProxyData getProxy(String proxyName73) throws AxisFault {
        try {
            return this.stub.getProxy(proxyName73);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.retrieve.data.for.proxy.service"), proxyName73), e);
            return null;
        }
    }

    public String[] getAvailableTransports() throws AxisFault {
        try {
            return this.stub.getAvailableTransports();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.get.available.transports"), e);
            return null;
        }
    }

    public void startProxyService(String proxyName80) throws AxisFault {
        try {
            this.stub.startProxyService(proxyName80);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.start.proxy.service"), proxyName80), e);
        }
    }

    public String enableTracing(String proxyName82) throws AxisFault {
        try {
            return this.stub.enableTracing(proxyName82);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.enable.tracing.for.proxy.service"), proxyName82), e);
            return FAILED;
        }
    }

    public String getSourceView(ProxyData pd84) throws AxisFault {
        try {
            return this.stub.getSourceView(pd84);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.generate.the.source.for.the.given.design"), e);
            return null;
        }
    }

    public ProxyData getDesignView(String proxyXML88) throws AxisFault {
        ProxyData pd = new ProxyData();
        try {
            OMElement description;
            OMElement enableSec;
            String val;
            OMAttribute startOnLoad;
            String traceValue;
            OMAttribute trace;
            String[] arr;
            String pinnedServersValue;
            OMAttribute pinnedServers;
            String[] arr2;
            String transports;
            OMAttribute trans;
            String statisticsValue;
            OMAttribute statistics;
            byte[] bytes = null;
            try {
                bytes = proxyXML88.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Unable to extract bytes in UTF-8 encoding. Extracting bytes in the system default encoding" + e.getMessage()));
                bytes = proxyXML88.getBytes();
            }
            OMElement elem = new StAXOMBuilder((InputStream)new ByteArrayInputStream(bytes)).getDocumentElement();
            Iterator itr = elem.getAllDeclaredNamespaces();
            boolean synapseNSPresent = false;
            while (itr.hasNext()) {
                OMNamespace ns = (OMNamespace)itr.next();
                if (!"http://ws.apache.org/ns/synapse".equals(ns.getNamespaceURI())) continue;
                synapseNSPresent = true;
                break;
            }
            if (!synapseNSPresent) {
                throw new AxisFault(this.bundle.getString("synapse.namespace.not.present"));
            }
            OMAttribute name = elem.getAttribute(new QName("name"));
            if (name != null) {
                pd.setName(name.getAttributeValue());
            }
            if ((statistics = elem.getAttribute(new QName("statistics"))) != null && (statisticsValue = statistics.getAttributeValue()) != null) {
                if ("enable".equals(statisticsValue)) {
                    pd.setEnableStatistics(true);
                } else if ("disable".equals(statisticsValue)) {
                    pd.setEnableStatistics(false);
                }
            }
            if ((trans = elem.getAttribute(new QName("transports"))) != null && (transports = trans.getAttributeValue()) != null && !"".equals(transports) && !"all".equals(transports) && (arr2 = transports.split(",")) != null && arr2.length != 0) {
                pd.setTransports(arr2);
            }
            if ((pinnedServers = elem.getAttribute(new QName("pinnedServers"))) != null && (pinnedServersValue = pinnedServers.getAttributeValue()) != null && !"".equals(pinnedServersValue) && (arr = pinnedServersValue.split(",")) != null && arr.length != 0) {
                pd.setPinnedServers(arr);
            }
            if ((trace = elem.getAttribute(new QName("trace"))) != null && (traceValue = trace.getAttributeValue()) != null) {
                if (traceValue.equals("enable")) {
                    pd.setEnableTracing(true);
                } else if (traceValue.equals("disable")) {
                    pd.setEnableTracing(false);
                }
            }
            if ((startOnLoad = elem.getAttribute(new QName("startOnLoad"))) != null && (val = startOnLoad.getAttributeValue()) != null && !"".equals(val)) {
                pd.setStartOnLoad(Boolean.valueOf(val).booleanValue());
            } else {
                pd.setStartOnLoad(true);
            }
            OMElement target = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "target"));
            if (target != null) {
                OMAttribute inSequence = target.getAttribute(new QName("inSequence"));
                if (inSequence != null) {
                    pd.setInSeqKey(inSequence.getAttributeValue());
                } else {
                    OMElement inSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "inSequence"));
                    if (inSequenceElement != null) {
                        pd.setInSeqXML(inSequenceElement.toString());
                    }
                }
                OMAttribute outSequence = target.getAttribute(new QName("outSequence"));
                if (outSequence != null) {
                    pd.setOutSeqKey(outSequence.getAttributeValue());
                } else {
                    OMElement outSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "outSequence"));
                    if (outSequenceElement != null) {
                        pd.setOutSeqXML(outSequenceElement.toString());
                    }
                }
                OMAttribute faultSequence = target.getAttribute(new QName("faultSequence"));
                if (faultSequence != null) {
                    pd.setFaultSeqKey(faultSequence.getAttributeValue());
                } else {
                    OMElement faultSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "faultSequence"));
                    if (faultSequenceElement != null) {
                        pd.setFaultSeqXML(faultSequenceElement.toString());
                    }
                }
                OMAttribute tgtEndpt = target.getAttribute(new QName("endpoint"));
                if (tgtEndpt != null) {
                    pd.setEndpointKey(tgtEndpt.getAttributeValue());
                } else {
                    OMElement endpointElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
                    if (endpointElement != null) {
                        pd.setEndpointXML(endpointElement.toString());
                    }
                }
            }
            Iterator props = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "parameter"));
            ArrayList<Entry> params = new ArrayList<Entry>();
            Entry entry = null;
            while (props.hasNext()) {
                Object o = props.next();
                if (!(o instanceof OMElement)) continue;
                OMElement prop = (OMElement)o;
                OMAttribute pname = prop.getAttribute(new QName("name"));
                OMElement propertyValue = prop.getFirstElement();
                if (pname == null) continue;
                if (propertyValue != null) {
                    entry = new Entry();
                    entry.setKey(pname.getAttributeValue());
                    entry.setValue(propertyValue.toString());
                    params.add(entry);
                    continue;
                }
                entry = new Entry();
                entry.setKey(pname.getAttributeValue());
                entry.setValue(prop.getText().trim());
                params.add(entry);
            }
            pd.setServiceParams(params.toArray(new Entry[params.size()]));
            OMElement wsdl = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "publishWSDL"));
            if (wsdl != null) {
                OMAttribute wsdlkey = wsdl.getAttribute(new QName("", "key"));
                if (wsdlkey != null) {
                    pd.setWsdlKey(wsdlkey.getAttributeValue());
                } else {
                    OMAttribute wsdlURI = wsdl.getAttribute(new QName("", "uri"));
                    if (wsdlURI != null) {
                        pd.setWsdlURI(wsdlURI.getAttributeValue());
                    } else {
                        String wsdlDef;
                        OMElement wsdl11 = wsdl.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"));
                        if (wsdl11 != null) {
                            wsdlDef = wsdl11.toString().replaceAll("\n|\\r|\\f|\\t", "");
                            wsdlDef = wsdlDef.replaceAll("> +<", "><");
                            pd.setWsdlDef(wsdlDef);
                        } else {
                            OMElement wsdl20 = wsdl.getFirstChildWithName(new QName("http://www.w3.org/ns/wsdl", "description"));
                            if (wsdl20 != null) {
                                wsdlDef = wsdl20.toString().replaceAll("\n|\\r|\\f|\\t", "");
                                wsdlDef = wsdlDef.replaceAll("> +<", "><");
                                pd.setWsdlDef(wsdlDef);
                            }
                        }
                    }
                }
                Iterator it = wsdl.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "resource"));
                ArrayList<Entry> resources = new ArrayList<Entry>();
                Entry resource = null;
                while (it.hasNext()) {
                    OMAttribute key;
                    OMElement resourceElem = (OMElement)it.next();
                    OMAttribute location = resourceElem.getAttribute(new QName("", "location"));
                    if (location == null) {
                        // empty if block
                    }
                    if ((key = resourceElem.getAttribute(new QName("", "key"))) == null) {
                        // empty if block
                    }
                    resource = new Entry();
                    resource.setKey(location.getAttributeValue());
                    resource.setValue(key.getAttributeValue());
                    resources.add(resource);
                }
                pd.setWsdlResources(resources.toArray(new Entry[resources.size()]));
            }
            if ((enableSec = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
                pd.setEnableSecurity(true);
            }
            if ((description = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "description"))) != null) {
                pd.setDescription(description.getText());
            }
        }
        catch (XMLStreamException e) {
            this.handleException(this.bundle.getString("unable.to.build.the.design.view.from.the.given.xml"), e);
        }
        return pd;
    }

    public void stopProxyService(String proxyName92) throws AxisFault {
        try {
            this.stub.stopProxyService(proxyName92);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.stop.proxy.service"), proxyName92), e);
        }
    }

    public String enableStatistics(String proxyName94) throws AxisFault {
        try {
            return this.stub.enableStatistics(proxyName94);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.enable.statistics.for.proxy"), proxyName94), e);
            return FAILED;
        }
    }

    public String[] getAvailableSequences() throws AxisFault {
        try {
            return this.stub.getAvailableSequences();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.get.declared.sequences"), e);
            return null;
        }
    }

    public void deleteProxyService(String proxyName99) throws AxisFault {
        try {
            this.stub.deleteProxyService(proxyName99);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("unable.to.delete.proxy.service"), proxyName99), e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

