/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.processor.ui;

import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.message.processor.stub.MessageProcessorAdminServiceStub;
import org.wso2.carbon.message.processor.ui.utils.MessageProcessorData;

public class MessageProcessorAdminServiceClient {
    private MessageProcessorAdminServiceStub stub;
    private static final String adminServiceName = "MessageProcessorAdminService";
    private static Log log = LogFactory.getLog(MessageProcessorAdminServiceClient.class);
    public static int MESSAGE_PROCESSORS_PER_PAGE = 10;

    public MessageProcessorAdminServiceClient(String cookie, String backendServerUrl, ConfigurationContext configurationContext) throws AxisFault {
        String serviceURL = backendServerUrl + adminServiceName;
        this.stub = new MessageProcessorAdminServiceStub(configurationContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void addMessageProcessor(String xml) throws Exception {
        try {
            if (xml != null) {
                this.stub.addMessageProcessor(xml);
            } else {
                this.handleException("Error Can't add message processor. Error in the configuration " + xml);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void modifyMessageProcessor(String xml) throws Exception {
        try {
            if (xml != null) {
                this.stub.modifyMessageProcessor(xml);
            } else {
                this.handleException("Error Can't change message processor. Error in the configuration " + xml);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteMessageProcessor(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteMessageProcessor(name);
            } else {
                this.handleException("Error Can't delete Message Processor " + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String[] getMessageProcessorNames() throws Exception {
        String[] messageStoreNames = null;
        try {
            messageStoreNames = this.stub.getMessageProcessorNames();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return messageStoreNames;
    }

    public String[] getPaginatedMessageProcessorNames(int pageNumber) throws Exception {
        int numberOfPages = 0;
        String[] processorNames = this.getMessageProcessorNames();
        if (processorNames != null) {
            numberOfPages = (int)Math.ceil((double)processorNames.length / (double)MESSAGE_PROCESSORS_PER_PAGE);
        }
        if (pageNumber == 0) {
            numberOfPages = 1;
        }
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * MESSAGE_PROCESSORS_PER_PAGE;
        int endIndex = (pageNumber + 1) * MESSAGE_PROCESSORS_PER_PAGE;
        if (processorNames == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = startIndex; i < endIndex && i < processorNames.length; ++i) {
            nameList.add(processorNames[i]);
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    public MessageProcessorData getMessageProcessor(String name) throws Exception {
        MessageProcessorData data = null;
        try {
            if (name != null) {
                String xml = this.stub.getMessageProcessor(name);
                assert (xml != null);
                data = new MessageProcessorData(xml);
            } else {
                this.handleException("Error Can't access Message processor" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return data;
    }

    public String getClassName(String name) throws Exception {
        String className = null;
        try {
            if (name != null) {
                className = this.stub.getClassName(name);
            } else {
                this.handleException("Error accessing Message processor" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return className;
    }

    public String[] getMessageIds(String name) throws Exception {
        String[] messageIds = null;
        try {
            if (name != null) {
                messageIds = this.stub.getMessageIds(name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return messageIds;
    }

    public String getEnvelope(String name, String messageId) throws Exception {
        String message = null;
        try {
            if (name != null) {
                message = this.stub.getEnvelope(name, messageId);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return message;
    }

    public void deleteAllMessages(String name) throws Exception {
        Object message = null;
        try {
            if (name != null) {
                this.stub.deleteAllMessages(name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteMessage(String name, String messageId) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteMessage(name, messageId);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteFirstMessage(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteFirstMessages(name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void resendAllMessages(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.resendAll(name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void resendMessage(String name, String messageId) throws Exception {
        try {
            if (name != null) {
                this.stub.resend(name, messageId);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void resendFirstMessage(String name, String messageId) throws Exception {
        try {
            if (name != null) {
                this.stub.resendFirstMessage(name, messageId);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String[] getPaginatedMessages(String name, int pageNumber) throws Exception {
        ArrayList<String> midList = new ArrayList<String>();
        try {
            if (name != null) {
                String[] messageIds = this.stub.getMessageIds(name);
                if (messageIds == null || messageIds.length == 0) {
                    return null;
                }
                int size = messageIds.length;
                if (size <= 0) {
                    return new String[0];
                }
                int numberOfPages = (int)Math.ceil((double)size / (double)MESSAGE_PROCESSORS_PER_PAGE);
                if (numberOfPages == 0) {
                    numberOfPages = 1;
                }
                if (pageNumber > numberOfPages - 1) {
                    pageNumber = numberOfPages - 1;
                }
                int startIndex = pageNumber * MESSAGE_PROCESSORS_PER_PAGE;
                int endIndex = (pageNumber + 1) * MESSAGE_PROCESSORS_PER_PAGE;
                for (int i = startIndex; i < endIndex && i < size; ++i) {
                    String id = messageIds[i];
                    if (id == null) continue;
                    midList.add(id);
                }
                return midList.toArray(new String[midList.size()]);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return new String[0];
    }

    public boolean isActive(String name) throws Exception {
        boolean active = false;
        try {
            if (name != null) {
                active = this.stub.isActive(name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return active;
    }

    public void deactivate(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deactivate(name.trim());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void activate(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.activate(name.trim());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int getSize(String name) throws Exception {
        int size = 0;
        try {
            if (name != null) {
                size = this.stub.getSize(name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return size;
    }

    private void handleException(Exception e) throws Exception {
        String message = "Error Executing MessageProcessorAdminServiceClient" + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw e;
    }

    private void handleException(String message) throws Exception {
        log.error((Object)message);
        throw new Exception(message);
    }
}

