/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.throttle;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.throttle.OnAcceptMediator;
import org.wso2.carbon.mediator.throttle.OnRejectMediator;

public class ThrottleMediator
extends AbstractListMediator {
    private String policyKey = null;
    private OMElement inLinePolicy = null;
    private String onRejectSeqKey = null;
    private String onAcceptSeqKey = null;
    private String id;

    public ThrottleMediator() {
        this.addChild((Mediator)new OnAcceptMediator());
        this.addChild((Mediator)new OnRejectMediator());
    }

    public String getTagLocalName() {
        return "throttle";
    }

    public OMElement serialize(OMElement parent) {
        OMElement throttle = fac.createOMElement("throttle", synNS);
        OMElement policy = fac.createOMElement("policy", synNS);
        if (this.policyKey != null) {
            policy.addAttribute(fac.createOMAttribute("key", nullNS, this.policyKey));
            throttle.addChild((OMNode)policy);
        } else if (this.inLinePolicy != null) {
            policy.addChild((OMNode)this.inLinePolicy);
            throttle.addChild((OMNode)policy);
        }
        ThrottleMediator.saveTracingState((OMElement)throttle, (Mediator)this);
        if (this.id != null) {
            throttle.addAttribute(fac.createOMAttribute("id", nullNS, this.id));
        }
        if (this.onRejectSeqKey != null) {
            throttle.addAttribute(fac.createOMAttribute("onReject", nullNS, this.onRejectSeqKey));
        } else {
            for (Mediator m : this.getList()) {
                if (!(m instanceof OnRejectMediator)) continue;
                m.serialize(throttle);
            }
        }
        if (this.onAcceptSeqKey != null) {
            throttle.addAttribute(fac.createOMAttribute("onAccept", nullNS, this.onAcceptSeqKey));
        } else {
            for (Mediator m : this.getList()) {
                if (!(m instanceof OnAcceptMediator)) continue;
                m.serialize(throttle);
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)throttle);
        }
        return throttle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void build(OMElement elem) {
        this.getList().clear();
        this.policyKey = null;
        this.onAcceptSeqKey = null;
        this.onRejectSeqKey = null;
        this.inLinePolicy = null;
        this.id = null;
        OMElement policy = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "policy"));
        if (policy != null) {
            OMAttribute key = policy.getAttribute(new QName("", "key"));
            if (key != null) {
                String keyValue = key.getAttributeValue();
                if (keyValue == null || "".equals(keyValue)) throw new MediatorException("key attribute should have a value ");
                this.policyKey = keyValue;
            } else {
                OMElement inLine = policy.getFirstElement();
                if (inLine != null) {
                    this.inLinePolicy = inLine;
                }
            }
        }
        this.processAuditStatus((Mediator)this, elem);
        String id = elem.getAttributeValue(new QName("", "id"));
        if (id == null || "".equals(id)) {
            throw new MediatorException("Idy attribute must have defined ");
        }
        this.id = id.trim();
        OMAttribute onReject = elem.getAttribute(new QName("", "onReject"));
        if (onReject != null) {
            String onRejectValue = onReject.getAttributeValue();
            if (onRejectValue != null) {
                this.onRejectSeqKey = onRejectValue.trim();
            }
        } else {
            OMElement onRejectMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onReject"));
            if (onRejectMediatorElement != null) {
                OnRejectMediator onRejectMediator = new OnRejectMediator();
                onRejectMediator.build(onRejectMediatorElement);
                this.addChild((Mediator)onRejectMediator);
            }
        }
        OMAttribute onAccept = elem.getAttribute(new QName("", "onAccept"));
        if (onAccept != null) {
            String onAcceptValue = onAccept.getAttributeValue();
            if (onAcceptValue == null) return;
            this.onAcceptSeqKey = onAcceptValue;
            return;
        } else {
            OMElement onAcceptMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onAccept"));
            if (onAcceptMediatorElement == null) return;
            OnAcceptMediator onAcceptMediator = new OnAcceptMediator();
            onAcceptMediator.build(onAcceptMediatorElement);
            this.addChild((Mediator)onAcceptMediator);
        }
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public OMElement getInLinePolicy() {
        return this.inLinePolicy;
    }

    public void setInLinePolicy(OMElement inLinePolicy) {
        this.inLinePolicy = inLinePolicy;
    }

    public String getOnRejectSeqKey() {
        return this.onRejectSeqKey;
    }

    public void setOnRejectSeqKey(String onRejectSeqKey) {
        this.onRejectSeqKey = onRejectSeqKey;
    }

    public String getOnAcceptSeqKey() {
        return this.onAcceptSeqKey;
    }

    public void setOnAcceptSeqKey(String onAcceptSeqKey) {
        this.onAcceptSeqKey = onAcceptSeqKey;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

