/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics.ui.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.statistics.stub.GraphData;
import org.wso2.carbon.mediation.statistics.stub.InOutStatisticsRecord;
import org.wso2.carbon.mediation.statistics.stub.MediationStatisticsAdminStub;

public class MediationStatisticsClient {
    public static final int SERVER_STATISTICS = 3;
    public static final int SEQUENCE_STATISTICS = 2;
    public static final int PROXYSERVICE_STATISTICS = 1;
    public static final int ENDPOINT_STATISTICS = 0;
    private static final Log log = LogFactory.getLog(MediationStatisticsClient.class);
    public MediationStatisticsAdminStub stub;

    public MediationStatisticsClient(ConfigurationContext configCtx, String backendServerURL, String cookie) throws AxisFault {
        String serviceURL = backendServerURL + "MediationStatisticsAdmin";
        this.stub = new MediationStatisticsAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public double calculateAverageTime(InOutStatisticsRecord record) {
        double t1 = 0.0;
        double t2 = 0.0;
        int c1 = 0;
        int c2 = 0;
        if (record.getInRecord() != null) {
            t1 = record.getInRecord().getAvgTime();
            c1 = record.getInRecord().getTotalCount();
        }
        if (record.getOutRecord() != null) {
            t2 = record.getOutRecord().getAvgTime();
            c2 = record.getOutRecord().getTotalCount();
        }
        if (c1 + c2 == 0) {
            return 0.0;
        }
        return (t1 * (double)c1 + t2 * (double)c2) / (double)(c1 + c2);
    }

    public GraphData getDataForGraph() throws AxisFault {
        try {
            return this.stub.getDataForGraph();
        }
        catch (Exception e) {
            String msg = "Cannot get graph data. Backepnd service may be unvailable";
            this.handleException(msg, e);
            return null;
        }
    }

    public InOutStatisticsRecord getCategoryStatistics(int category) throws AxisFault {
        try {
            return this.stub.getCategoryStatistics(category);
        }
        catch (Exception e) {
            String msg = "Cannot get category statistics. Backepnd service may be unvailable";
            this.handleException(msg, e);
            return null;
        }
    }

    public String[] listSequence() throws AxisFault {
        String[] sequences = null;
        try {
            sequences = this.stub.listSequence();
        }
        catch (Exception e) {
            String msg = "Cannot list sequences. Backepnd service may be unvailable";
            this.handleException(msg, e);
        }
        if (sequences == null || sequences.length == 0 || sequences[0] == null) {
            return null;
        }
        return sequences;
    }

    public String[] listEndPoints() throws AxisFault {
        String[] endpoints = null;
        try {
            endpoints = this.stub.listEndPoint();
        }
        catch (Exception e) {
            String msg = "Cannot list endpoints. Backend service may be unvailable";
            this.handleException(msg, e);
        }
        if (endpoints == null || endpoints.length == 0 || endpoints[0] == null) {
            return null;
        }
        return endpoints;
    }

    public String[] listProxyServices() throws AxisFault {
        String[] services = null;
        try {
            services = this.stub.listProxyServices();
        }
        catch (Exception e) {
            String msg = "Cannot list proxy services. Backend service may be unvailable";
            this.handleException(msg, e);
        }
        if (services == null || services.length == 0 || services[0] == null) {
            return null;
        }
        return services;
    }

    public String[] listServers() throws AxisFault {
        try {
            return this.stub.listServers();
        }
        catch (Exception e) {
            String msg = "Cannot list servers. Backepnd service may be unvailable";
            this.handleException(msg, e);
            return null;
        }
    }

    public InOutStatisticsRecord getSequenceStatistics(String name) throws AxisFault {
        try {
            return this.stub.getSequenceStatistics(name);
        }
        catch (Exception e) {
            String msg = "Cannot get squence data. Backend service may be unvailable";
            this.handleException(msg, e);
            return null;
        }
    }

    public InOutStatisticsRecord getEndPointStatistics(String name) throws AxisFault {
        try {
            return this.stub.getEndPointStatistics(name);
        }
        catch (Exception e) {
            String msg = "Cannot get endpoint data. Backepnd service may be unvailable";
            this.handleException(msg, e);
            return null;
        }
    }

    public InOutStatisticsRecord getProxyServiceStatistics(String name) throws AxisFault {
        try {
            return this.stub.getProxyServiceStatistics(name);
        }
        catch (RemoteException e) {
            String msg = "Cannot get proxy service data. Backend service may be unavailable.";
            this.handleException(msg, e);
            return null;
        }
    }

    public InOutStatisticsRecord getServerStatistics() throws AxisFault {
        try {
            return this.stub.getServerStatistics();
        }
        catch (Exception e) {
            String msg = "Cannot get server data. Backend service may be unvailable";
            this.handleException(msg, e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        if (e instanceof AxisFault) {
            msg = e.getMessage();
        }
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

