/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.iterate;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class IterateMediator
extends AbstractListMediator {
    private static final QName ATT_CONTPAR = new QName("continueParent");
    private static final QName ATT_PREPLD = new QName("preservePayload");
    private static final QName ATT_ATTACHPATH = new QName("attachPath");
    private static final QName ATT_ID = new QName("id");
    private static final QName ATT_SEQUENTIAL = new QName("sequential");
    private boolean continueParent = false;
    private boolean preservePayload = false;
    private SynapseXPath expression = null;
    private SynapseXPath attachPath = null;
    private String id;
    private boolean sequential = false;

    public boolean isContinueParent() {
        return this.continueParent;
    }

    public boolean isPreservePayload() {
        return this.preservePayload;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public SynapseXPath getAttachPath() {
        return this.attachPath;
    }

    public void setContinueParent(boolean continueParent) {
        this.continueParent = continueParent;
    }

    public void setPreservePayload(boolean preservePayload) {
        this.preservePayload = preservePayload;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public void setAttachPath(SynapseXPath attachPath) {
        this.attachPath = attachPath;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public String getTagLocalName() {
        return "iterate";
    }

    public OMElement serialize(OMElement parent) {
        OMElement itrElem = fac.createOMElement("iterate", synNS);
        IterateMediator.saveTracingState((OMElement)itrElem, (Mediator)this);
        if (this.continueParent) {
            itrElem.addAttribute("continueParent", Boolean.toString(true), nullNS);
        }
        if (this.preservePayload) {
            itrElem.addAttribute("preservePayload", Boolean.toString(true), nullNS);
        }
        if (this.attachPath != null && !".".equals(this.attachPath.toString())) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.attachPath, (OMElement)itrElem, (String)"attachPath");
        }
        if (this.expression == null) {
            throw new MediatorException("Missing expression of the IterateMediator which is required.");
        }
        SynapseXPathSerializer.serializeXPath((SynapseXPath)this.expression, (OMElement)itrElem, (String)"expression");
        if (this.id != null) {
            itrElem.addAttribute("id", this.id, nullNS);
        }
        if (this.sequential) {
            itrElem.addAttribute("sequential", Boolean.toString(true), nullNS);
        }
        this.serializeChildren(itrElem, this.getList());
        if (parent != null) {
            parent.addChild((OMNode)itrElem);
        }
        return itrElem;
    }

    public void build(OMElement elem) {
        OMElement targetElement;
        OMAttribute expression;
        OMAttribute preservePayload;
        OMAttribute continueParent;
        OMAttribute sequentialAttr;
        if (this.getList() != null) {
            this.getList().clear();
        }
        this.processAuditStatus((Mediator)this, elem);
        OMAttribute idAttr = elem.getAttribute(ATT_ID);
        if (idAttr != null) {
            this.id = idAttr.getAttributeValue();
        }
        if ((sequentialAttr = elem.getAttribute(ATT_SEQUENTIAL)) != null) {
            this.sequential = Boolean.valueOf(sequentialAttr.getAttributeValue());
        }
        if ((continueParent = elem.getAttribute(ATT_CONTPAR)) != null) {
            this.continueParent = Boolean.valueOf(continueParent.getAttributeValue());
        }
        if ((preservePayload = elem.getAttribute(ATT_PREPLD)) != null) {
            this.preservePayload = Boolean.valueOf(preservePayload.getAttributeValue());
        }
        if ((expression = elem.getAttribute(ATT_EXPRN)) != null) {
            try {
                this.expression = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_EXPRN);
            }
            catch (JaxenException e) {
                throw new MediatorException("Unable to build the IterateMediator. Invalid XPATH " + expression.getAttributeValue());
            }
        } else {
            throw new MediatorException("XPATH expression is required for an IterateMediator under the \"expression\" attribute");
        }
        OMAttribute attachPath = elem.getAttribute(ATT_ATTACHPATH);
        String attachPathValue = "";
        if (attachPath != null && !this.preservePayload) {
            throw new MediatorException("Wrong configuration for the iterate mediator :: if the iterator should not preserve payload, then attachPath can not be present");
        }
        if (attachPath != null) {
            attachPathValue = attachPath.getAttributeValue();
        }
        if (!attachPathValue.equals("")) {
            try {
                SynapseXPath xp = new SynapseXPath(attachPathValue);
                OMElementUtils.addNameSpaces((XPath)xp, (OMElement)elem, null);
                this.attachPath = xp;
            }
            catch (JaxenException e) {
                throw new MediatorException("Unable to build the IterateMediator. Invalid XPATH " + attachPathValue);
            }
        }
        if ((targetElement = elem.getFirstChildWithName(TARGET_Q)) == null) {
            throw new MediatorException("Target for an iterate mediator is required :: missing target");
        }
        this.addChildren(elem, (ListMediator)this);
    }
}

