/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.filter;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.filter.ElseMediator;
import org.wso2.carbon.mediator.filter.ThenMediator;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class FilterMediator
extends AbstractListMediator {
    private SynapseXPath source = null;
    private Pattern regex = null;
    private SynapseXPath xpath = null;
    private String thenKey = null;
    private String elseKey = null;

    public FilterMediator() {
        this.addChild((Mediator)new ThenMediator());
        this.addChild((Mediator)new ElseMediator());
    }

    public SynapseXPath getSource() {
        return this.source;
    }

    public void setSource(SynapseXPath source) {
        this.source = source;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public SynapseXPath getXpath() {
        return this.xpath;
    }

    public void setXpath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public String getThenKey() {
        return this.thenKey;
    }

    public void setThenKey(String thenKey) {
        this.thenKey = thenKey;
    }

    public String getElseKey() {
        return this.elseKey;
    }

    public void setElseKey(String elseKey) {
        this.elseKey = elseKey;
    }

    public String getTagLocalName() {
        return "filter";
    }

    public OMElement serialize(OMElement parent) {
        OMElement filter = fac.createOMElement("filter", synNS);
        if (this.getSource() != null && this.getRegex() != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getSource(), (OMElement)filter, (String)"source");
            filter.addAttribute(fac.createOMAttribute("regex", nullNS, this.getRegex().pattern()));
        } else if (this.getXpath() != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getXpath(), (OMElement)filter, (String)"xpath");
        }
        FilterMediator.saveTracingState((OMElement)filter, (Mediator)this);
        this.serializeChildren(filter, this.getList());
        if (parent != null) {
            parent.addChild((OMNode)filter);
        }
        return filter;
    }

    public void build(OMElement elem) {
        this.getList().clear();
        OMAttribute attXpath = elem.getAttribute(ATT_XPATH);
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        OMAttribute attRegex = elem.getAttribute(ATT_REGEX);
        if (attXpath != null) {
            if (attXpath.getAttributeValue() == null || attXpath.getAttributeValue().trim().length() != 0) {
                try {
                    this.setXpath(SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_XPATH));
                }
                catch (JaxenException e) {}
            }
        } else if (!(attSource == null || attRegex == null || attSource.getAttributeValue() != null && attSource.getAttributeValue().trim().length() == 0 || attRegex.getAttributeValue() != null && attRegex.getAttributeValue().trim().length() == 0)) {
            try {
                this.setSource(SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_SOURCE));
            }
            catch (JaxenException e) {
                // empty catch block
            }
            try {
                this.setRegex(Pattern.compile(attRegex.getAttributeValue()));
            }
            catch (PatternSyntaxException pse) {
                // empty catch block
            }
        }
        this.processAuditStatus((Mediator)this, elem);
        this.addChildren(elem, (ListMediator)this);
        boolean thenPresent = false;
        boolean elsePresent = false;
        for (Mediator m : this.getList()) {
            if (m instanceof ThenMediator) {
                thenPresent = true;
                continue;
            }
            if (!(m instanceof ElseMediator)) continue;
            elsePresent = true;
        }
        if (!thenPresent) {
            if (elsePresent) {
                throw new MediatorException("Else without Then, Invalid syntax.");
            }
            ThenMediator thenMediator = new ThenMediator();
            for (Mediator m : this.getList()) {
                thenMediator.addChild(m);
            }
            this.getList().clear();
            this.addChild((Mediator)thenMediator);
            this.addChild((Mediator)new ElseMediator());
        }
    }
}

