/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.payloadfactory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class PayloadFactoryMediator
extends AbstractMediator {
    private static Log log = LogFactory.getLog(PayloadFactoryMediator.class);
    private static final String PAYLOAD_FACTORY = "payloadFactory";
    private static final String FORMAT = "format";
    private static final String ARGS = "args";
    private static final String ARG = "arg";
    private static final String VALUE = "value";
    private static final String EXPRESSION = "expression";
    private static final QName FORMAT_Q = new QName("http://ws.apache.org/ns/synapse", "format");
    private static final QName ARGS_Q = new QName("http://ws.apache.org/ns/synapse", "args");
    private String format;
    private List<Argument> argumentList = new ArrayList<Argument>();

    public OMElement serialize(OMElement parent) {
        OMElement payloadFactoryElem = fac.createOMElement(PAYLOAD_FACTORY, synNS);
        PayloadFactoryMediator.saveTracingState((OMElement)payloadFactoryElem, (Mediator)this);
        if (this.format != null) {
            try {
                OMElement formatElem = fac.createOMElement(FORMAT, synNS);
                formatElem.addChild((OMNode)AXIOMUtil.stringToOM((String)this.format));
                payloadFactoryElem.addChild((OMNode)formatElem);
            }
            catch (XMLStreamException e) {
                this.handleException("Error while serializing payloadFactory mediator", e);
            }
        } else {
            this.handleException("Invalid payloadFactory mediator, format is required");
        }
        if (this.argumentList != null && this.argumentList.size() > 0) {
            OMElement argumentsElem = fac.createOMElement(ARGS, synNS);
            for (Argument arg : this.argumentList) {
                OMElement argElem = fac.createOMElement(ARG, synNS);
                if (arg.getValue() != null) {
                    argElem.addAttribute(fac.createOMAttribute(VALUE, nullNS, arg.getValue()));
                } else if (arg.getExpression() != null) {
                    SynapseXPathSerializer.serializeXPath((SynapseXPath)arg.getExpression(), (OMElement)argElem, (String)EXPRESSION);
                }
                argumentsElem.addChild((OMNode)argElem);
            }
            payloadFactoryElem.addChild((OMNode)argumentsElem);
        }
        if (parent != null) {
            parent.addChild((OMNode)payloadFactoryElem);
        }
        return payloadFactoryElem;
    }

    public void build(OMElement elem) {
        OMElement formatElem = elem.getFirstChildWithName(FORMAT_Q);
        if (formatElem != null) {
            this.format = formatElem.getFirstElement().toString();
        } else {
            this.handleException("format element of payloadFactoryMediator is required");
        }
        OMElement argumentsElem = elem.getFirstChildWithName(ARGS_Q);
        if (argumentsElem != null) {
            Iterator itr = argumentsElem.getChildElements();
            while (itr.hasNext()) {
                OMElement argElem = (OMElement)itr.next();
                Argument arg = new Argument();
                String attrValue = argElem.getAttributeValue(ATT_VALUE);
                if (attrValue != null) {
                    arg.setValue(attrValue);
                } else {
                    attrValue = argElem.getAttributeValue(ATT_EXPRN);
                    if (attrValue != null) {
                        if (attrValue.trim().length() == 0) {
                            this.handleException("Attribute value for expression cannot be empty");
                        } else {
                            try {
                                arg.setExpression(SynapseXPathFactory.getSynapseXPath((OMElement)argElem, (QName)ATT_EXPRN));
                            }
                            catch (JaxenException e) {
                                this.handleException("Invalid XPath expression for attribute expression : " + attrValue, (Exception)((Object)e));
                            }
                        }
                    } else {
                        this.handleException("Unsupported arg type or expression attribute required");
                    }
                }
                this.argumentList.add(arg);
            }
        }
        this.processAuditStatus((Mediator)this, elem);
    }

    public String getFormat() {
        return this.format;
    }

    public void addArgument(Argument arg) {
        this.argumentList.add(arg);
    }

    public List<Argument> getArgumentList() {
        return this.argumentList;
    }

    public String getTagLocalName() {
        return PAYLOAD_FACTORY;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new MediatorException(msg);
    }

    private void handleException(String msg, Exception ex) {
        log.error((Object)msg, (Throwable)ex);
        throw new MediatorException(msg + " Caused by " + ex.getMessage());
    }

    public static class Argument {
        private String value;
        private SynapseXPath expression;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public SynapseXPath getExpression() {
            return this.expression;
        }

        public void setExpression(SynapseXPath expression) {
            this.expression = expression;
        }
    }
}

