/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.fault;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class FaultMediator
extends AbstractMediator {
    public static final String WSA_ACTION = "Action";
    public static final int SOAP11 = 1;
    public static final int SOAP12 = 2;
    public static final int POX = 3;
    private int soapVersion;
    private boolean markAsResponse = true;
    private boolean serializeResponse = false;
    private QName faultCodeValue = null;
    private SynapseXPath faultCodeExpr = null;
    private String faultReasonValue = null;
    private SynapseXPath faultReasonExpr = null;
    private URI faultNode = null;
    private URI faultRole = null;
    private String faultDetail = null;
    private SynapseXPath faultDetailExpr = null;
    private List<OMElement> faultDetailElements = new ArrayList<OMElement>();
    private static final String SOAP11_STRING = "soap11";
    private static final String SOAP12_STRING = "soap12";
    private static final String POX_STRING = "pox";
    private static final QName ATT_VERSION_Q = new QName("", "version");
    private static final QName ATT_RESPONSE_Q = new QName("", "response");
    private static final QName CODE_Q = new QName("http://ws.apache.org/ns/synapse", "code");
    private static final QName REASON_Q = new QName("http://ws.apache.org/ns/synapse", "reason");
    private static final QName NODE_Q = new QName("http://ws.apache.org/ns/synapse", "node");
    private static final QName ROLE_Q = new QName("http://ws.apache.org/ns/synapse", "role");
    private static final QName DETAIL_Q = new QName("http://ws.apache.org/ns/synapse", "detail");

    public String getTagLocalName() {
        return "makefault";
    }

    public int getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(int soapVersion) {
        this.soapVersion = soapVersion;
    }

    public boolean isMarkAsResponse() {
        return this.markAsResponse;
    }

    public void setMarkAsResponse(boolean markAsResponse) {
        this.markAsResponse = markAsResponse;
    }

    public boolean isSerializeResponse() {
        return this.serializeResponse;
    }

    public void setSerializeResponse(boolean serializeResponse) {
        this.serializeResponse = serializeResponse;
    }

    public QName getFaultCodeValue() {
        return this.faultCodeValue;
    }

    public void setFaultCodeValue(QName faultCodeValue) {
        if (this.soapVersion == 1) {
            this.faultCodeValue = faultCodeValue;
        } else if ("http://www.w3.org/2003/05/soap-envelope".equals(faultCodeValue.getNamespaceURI()) && ("DataEncodingUnknown".equals(faultCodeValue.getLocalPart()) || "MustUnderstand".equals(faultCodeValue.getLocalPart()) || "Receiver".equals(faultCodeValue.getLocalPart()) || "Sender".equals(faultCodeValue.getLocalPart()) || "VersionMismatch".equals(faultCodeValue.getLocalPart()))) {
            this.faultCodeValue = faultCodeValue;
        } else {
            throw new MediatorException("Invalid Fault code value for a SOAP 1.2 fault : " + faultCodeValue);
        }
    }

    public SynapseXPath getFaultCodeExpr() {
        return this.faultCodeExpr;
    }

    public void setFaultCodeExpr(SynapseXPath faultCodeExpr) {
        this.faultCodeExpr = faultCodeExpr;
    }

    public String getFaultReasonValue() {
        return this.faultReasonValue;
    }

    public void setFaultReasonValue(String faultReasonValue) {
        this.faultReasonValue = faultReasonValue;
    }

    public SynapseXPath getFaultReasonExpr() {
        return this.faultReasonExpr;
    }

    public void setFaultReasonExpr(SynapseXPath faultReasonExpr) {
        this.faultReasonExpr = faultReasonExpr;
    }

    public URI getFaultNode() {
        return this.faultNode;
    }

    public void setFaultNode(URI faultNode) {
        if (this.soapVersion == 1) {
            throw new MediatorException("A fault node does not apply to a SOAP 1.1 fault");
        }
        this.faultNode = faultNode;
    }

    public URI getFaultRole() {
        return this.faultRole;
    }

    public void setFaultRole(URI faultRole) {
        this.faultRole = faultRole;
    }

    public String getFaultDetail() {
        return this.faultDetail;
    }

    public void setFaultDetail(String faultDetail) {
        this.faultDetail = faultDetail;
    }

    public SynapseXPath getFaultDetailExpr() {
        return this.faultDetailExpr;
    }

    public void setFaultDetailExpr(SynapseXPath faultDetailExpr) {
        this.faultDetailExpr = faultDetailExpr;
    }

    public List<OMElement> getFaultDetailElements() {
        return this.faultDetailElements;
    }

    public void addFaultDetailElement(OMElement element) {
        this.faultDetailElements.add(element);
    }

    public void addAllFaultDetailElements(List<OMElement> list) {
        this.faultDetailElements.addAll(list);
    }

    public OMElement removeFaultDetailElement(int pos) {
        return this.faultDetailElements.remove(pos);
    }

    public OMElement serialize(OMElement parent) {
        OMElement detail;
        OMElement code;
        OMElement fault = fac.createOMElement("makefault", synNS);
        FaultMediator.saveTracingState((OMElement)fault, (Mediator)this);
        if (this.soapVersion == 1) {
            fault.addAttribute(fac.createOMAttribute("version", nullNS, SOAP11_STRING));
        } else if (this.soapVersion == 2) {
            fault.addAttribute(fac.createOMAttribute("version", nullNS, SOAP12_STRING));
        } else if (this.soapVersion == 3) {
            fault.addAttribute(fac.createOMAttribute("version", nullNS, POX_STRING));
        }
        if (this.serializeResponse) {
            if (this.markAsResponse) {
                fault.addAttribute(fac.createOMAttribute("response", nullNS, "true"));
            } else {
                fault.addAttribute(fac.createOMAttribute("response", nullNS, "false"));
            }
        }
        OMElement oMElement = code = this.soapVersion != 3 ? fac.createOMElement("code", synNS, (OMContainer)fault) : null;
        if (this.faultCodeValue != null && code != null) {
            OMNamespace ns = code.declareNamespace(this.faultCodeValue.getNamespaceURI(), this.faultCodeValue.getPrefix());
            code.addAttribute(fac.createOMAttribute("value", nullNS, ns.getPrefix() + ":" + this.faultCodeValue.getLocalPart()));
        } else if (this.faultCodeExpr != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.faultCodeExpr, (OMElement)code, (String)"expression");
        } else if (this.soapVersion != 3) {
            throw new MediatorException("Fault code is required for a fault mediator unless it is a pox fault");
        }
        OMElement reason = fac.createOMElement("reason", synNS, (OMContainer)fault);
        if (this.faultReasonValue != null) {
            reason.addAttribute(fac.createOMAttribute("value", nullNS, this.faultReasonValue));
        } else if (this.faultReasonExpr != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.faultReasonExpr, (OMElement)reason, (String)"expression");
        } else if (this.soapVersion != 3) {
            throw new MediatorException("Fault reason is required for a fault mediator unless it is a pox fault");
        }
        if (this.faultNode != null && this.soapVersion != 1 && this.soapVersion != 3) {
            OMElement node = fac.createOMElement("node", synNS, (OMContainer)fault);
            node.setText(this.faultNode.toString());
        }
        if (this.faultRole != null && this.soapVersion != 3) {
            OMElement role = fac.createOMElement("role", synNS, (OMContainer)fault);
            role.setText(this.faultRole.toString());
        }
        if (this.faultDetailExpr != null) {
            detail = fac.createOMElement("detail", synNS, (OMContainer)fault);
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.faultDetailExpr, (OMElement)detail, (String)"expression");
        } else if (this.faultDetail != null) {
            detail = fac.createOMElement("detail", synNS, (OMContainer)fault);
            detail.setText(this.faultDetail);
        } else if (this.faultDetailElements.size() > 0) {
            detail = fac.createOMElement("detail", synNS, (OMContainer)fault);
            for (OMElement e : this.faultDetailElements) {
                detail.addChild((OMNode)e);
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)fault);
        }
        return fault;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void build(OMElement elem) {
        OMElement detail;
        OMElement role;
        OMElement reason;
        OMElement code;
        OMAttribute version = elem.getAttribute(ATT_VERSION_Q);
        if (version != null) {
            if (SOAP11_STRING.equals(version.getAttributeValue())) {
                this.soapVersion = 1;
            } else if (SOAP12_STRING.equals(version.getAttributeValue())) {
                this.soapVersion = 2;
            } else {
                if (!POX_STRING.equals(version.getAttributeValue())) throw new MediatorException("Invalid SOAP version");
                this.soapVersion = 3;
            }
        } else {
            this.extractImplicitSoapVersionFrom(elem);
        }
        OMAttribute response = elem.getAttribute(ATT_RESPONSE_Q);
        if (response != null) {
            if ("true".equals(response.getAttributeValue())) {
                this.markAsResponse = true;
            } else {
                if (!"false".equals(response.getAttributeValue())) throw new MediatorException("Invalid value '" + response.getAttributeValue() + "' passed as response. Expected 'true' or 'false'");
                this.markAsResponse = false;
            }
            this.serializeResponse = true;
        }
        if ((code = elem.getFirstChildWithName(CODE_Q)) != null) {
            OMAttribute value = code.getAttribute(ATT_VALUE);
            OMAttribute expression = code.getAttribute(ATT_EXPRN);
            if (value != null) {
                String strValue = value.getAttributeValue();
                String prefix = null;
                String name = null;
                if (strValue.indexOf(":") == -1) {
                    throw new MediatorException("A QName is expected for fault code as prefix:name");
                }
                prefix = strValue.substring(0, strValue.indexOf(":"));
                name = strValue.substring(strValue.indexOf(":") + 1);
                String namespaceURI = OMElementUtils.getNameSpaceWithPrefix((String)prefix, (OMElement)code);
                if (namespaceURI == null) {
                    throw new MediatorException("Invalid namespace prefix '" + prefix + "' in code attribute");
                }
                this.faultCodeValue = new QName(namespaceURI, name, prefix);
            } else {
                if (expression == null) throw new MediatorException("A 'value' or 'expression' attribute must specify the fault code");
                try {
                    this.faultCodeExpr = SynapseXPathFactory.getSynapseXPath((OMElement)code, (QName)ATT_EXPRN);
                }
                catch (JaxenException je) {
                    throw new MediatorException("Invalid fault code expression : " + je.getMessage());
                }
            }
        } else if (this.soapVersion != 3) {
            throw new MediatorException("The fault code is a required attribute for the makefault mediator unless it is a pox fault");
        }
        if ((reason = elem.getFirstChildWithName(REASON_Q)) != null) {
            OMAttribute value = reason.getAttribute(ATT_VALUE);
            OMAttribute expression = reason.getAttribute(ATT_EXPRN);
            if (value != null) {
                this.faultReasonValue = value.getAttributeValue();
            } else {
                if (expression == null) throw new MediatorException("A 'value' or 'expression' attribute must specify the fault code");
                try {
                    this.faultReasonExpr = SynapseXPathFactory.getSynapseXPath((OMElement)reason, (QName)ATT_EXPRN);
                }
                catch (JaxenException je) {
                    throw new MediatorException("Invalid fault reason expression : " + je.getMessage());
                }
            }
        } else if (this.soapVersion != 3) {
            throw new MediatorException("The fault reason is a required attribute for the makefault mediator unless it is a pox fault");
        }
        this.processAuditStatus((Mediator)this, elem);
        OMElement node = elem.getFirstChildWithName(NODE_Q);
        if (node != null && node.getText() != null) {
            try {
                this.faultNode = new URI(node.getText());
            }
            catch (URISyntaxException e) {
                throw new MediatorException("Invalid URI specified for fault node : " + node.getText());
            }
        }
        if ((role = elem.getFirstChildWithName(ROLE_Q)) != null && role.getText() != null) {
            try {
                this.faultRole = new URI(role.getText());
            }
            catch (URISyntaxException e) {
                throw new MediatorException("Invalid URI specified for fault role : " + role.getText());
            }
        }
        if ((detail = elem.getFirstChildWithName(DETAIL_Q)) == null) return;
        OMAttribute detailExpr = detail.getAttribute(ATT_EXPRN);
        if (detailExpr != null && detailExpr.getAttributeValue() != null) {
            try {
                this.faultDetailExpr = SynapseXPathFactory.getSynapseXPath((OMElement)detail, (QName)ATT_EXPRN);
                return;
            }
            catch (JaxenException e) {
                throw new MediatorException("Unable to build the XPath for fault detail from the expression : " + detailExpr.getAttributeValue());
            }
        } else {
            if (detail.getFirstOMChild() == null) return;
            OMNode detailNode = detail.getFirstOMChild();
            if (detailNode instanceof OMText) {
                this.faultDetail = detail.getText();
                return;
            } else {
                if (!(detailNode instanceof OMElement)) return;
                Iterator it = detail.getChildElements();
                while (it.hasNext()) {
                    this.faultDetailElements.add((OMElement)it.next());
                }
            }
        }
    }

    public void extractImplicitSoapVersionFrom(OMElement elem) {
        boolean searchChildren = true;
        Iterator allNamespaces = elem.getAllDeclaredNamespaces();
        while (allNamespaces.hasNext()) {
            OMNamespace ns = (OMNamespace)allNamespaces.next();
            if (ns.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                searchChildren = false;
                this.soapVersion = 2;
                break;
            }
            if (!ns.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) continue;
            searchChildren = false;
            this.soapVersion = 1;
            break;
        }
        if (searchChildren) {
            Iterator children = elem.getChildElements();
            while (children.hasNext()) {
                OMElement child = (OMElement)children.next();
                this.extractImplicitSoapVersionFrom(child);
            }
        }
    }
}

