/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.send;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.Value;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class SendMediator
extends AbstractMediator {
    private static final QName ENDPOINT_Q = new QName("http://ws.apache.org/ns/synapse", "endpoint");
    private static final QName BUILD_MESSAGE = new QName("buildmessage");
    private Endpoint endpoint = null;
    private Value receivingSeqValue;
    private boolean buildMessage = false;

    public boolean isBuildMessage() {
        return this.buildMessage;
    }

    public void setBuildMessage(boolean buildMessage) {
        this.buildMessage = buildMessage;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getTagLocalName() {
        return "send";
    }

    public Value getReceivingSeqValue() {
        return this.receivingSeqValue;
    }

    public void setReceivingSeqValue(Value receivingSeqValue) {
        this.receivingSeqValue = receivingSeqValue;
    }

    public OMElement serialize(OMElement parent) {
        OMElement send = fac.createOMElement("send", synNS);
        SendMediator.saveTracingState((OMElement)send, (Mediator)this);
        Endpoint activeEndpoint = this.getEndpoint();
        if (activeEndpoint != null) {
            send.addChild((OMNode)EndpointSerializer.getElementFromEndpoint((Endpoint)activeEndpoint));
        }
        if (parent != null) {
            parent.addChild((OMNode)send);
        }
        if (this.receivingSeqValue != null) {
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(this.receivingSeqValue, "receive", send);
        }
        if (this.buildMessage) {
            send.addAttribute(fac.createOMAttribute("buildmessage", nullNS, "true"));
        }
        return send;
    }

    public void build(OMElement elem) {
        String buildMessage;
        Endpoint endpoint;
        this.endpoint = null;
        this.processAuditStatus((Mediator)this, elem);
        OMElement epElement = elem.getFirstChildWithName(ENDPOINT_Q);
        if (epElement != null && (endpoint = EndpointFactory.getEndpointFromElement((OMElement)epElement, (boolean)true, (Properties)new Properties())) != null) {
            this.setEndpoint(endpoint);
        }
        if (elem.getAttributeValue(new QName(null, "receive")) != null) {
            ValueFactory keyFactory = new ValueFactory();
            this.receivingSeqValue = keyFactory.createValue("receive", elem);
        }
        if ((buildMessage = elem.getAttributeValue(BUILD_MESSAGE)) != null && "true".equalsIgnoreCase(buildMessage)) {
            this.setBuildMessage(true);
        }
    }
}

