/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.persistence.jms.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.util.UUIDGenerator;
import org.wso2.carbon.message.store.persistence.jms.message.JMSPersistentAxis2Message;
import org.wso2.carbon.message.store.persistence.jms.message.JMSPersistentMessage;
import org.wso2.carbon.message.store.persistence.jms.message.JMSPersistentSynapseMessage;

public class JMSPersistentMessageHelper {
    private SynapseEnvironment synapseEnvironment;
    private Log log = LogFactory.getLog(JMSPersistentMessage.class);

    public JMSPersistentMessageHelper(SynapseEnvironment se) {
        this.synapseEnvironment = se;
    }

    public org.apache.synapse.MessageContext createMessageContext(JMSPersistentMessage message) {
        SynapseConfiguration configuration = this.synapseEnvironment.getSynapseConfiguration();
        MessageContext msgCtx = ((Axis2SynapseEnvironment)this.synapseEnvironment).getAxis2ConfigurationContext().createMessageContext();
        AxisConfiguration axisConfiguration = msgCtx.getConfigurationContext().getAxisConfiguration();
        JMSPersistentAxis2Message jmsAxis2MessageContext = message.getJmsPersistentAxis2Message();
        SOAPEnvelope envelope = this.getSoapEnvelope(jmsAxis2MessageContext.getSoapEnvelope());
        try {
            msgCtx.setEnvelope(envelope);
            msgCtx.getOptions().setAction(jmsAxis2MessageContext.getAction());
            if (jmsAxis2MessageContext.getRelatesToMessageId() != null) {
                msgCtx.addRelatesTo(new RelatesTo(jmsAxis2MessageContext.getRelatesToMessageId()));
            }
            msgCtx.setMessageID(jmsAxis2MessageContext.getMessageID());
            msgCtx.getOptions().setAction(jmsAxis2MessageContext.getAction());
            AxisService axisService = axisConfiguration.getServiceForActivation(jmsAxis2MessageContext.getService());
            AxisOperation axisOperation = axisService.getOperation(jmsAxis2MessageContext.getOperationName());
            msgCtx.setFLOW(jmsAxis2MessageContext.getFLOW());
            ArrayList executionChain = new ArrayList();
            if (jmsAxis2MessageContext.getFLOW() == 2) {
                executionChain.addAll(axisOperation.getPhasesOutFlow());
                executionChain.addAll(axisConfiguration.getOutFlowPhases());
            } else if (jmsAxis2MessageContext.getFLOW() == 4) {
                executionChain.addAll(axisOperation.getPhasesOutFaultFlow());
                executionChain.addAll(axisConfiguration.getOutFlowPhases());
            }
            msgCtx.setExecutionChain(executionChain);
            ConfigurationContext configurationContext = msgCtx.getConfigurationContext();
            msgCtx.setAxisService(axisService);
            ServiceGroupContext serviceGroupContext = configurationContext.createServiceGroupContext(axisService.getAxisServiceGroup());
            ServiceContext serviceContext = serviceGroupContext.getServiceContext(axisService);
            OperationContext operationContext = serviceContext.createOperationContext(jmsAxis2MessageContext.getOperationName());
            msgCtx.setServiceContext(serviceContext);
            msgCtx.setOperationContext(operationContext);
            msgCtx.setAxisService(axisService);
            msgCtx.setAxisOperation(axisOperation);
            if (jmsAxis2MessageContext.getReplyToAddress() != null) {
                msgCtx.setReplyTo(new EndpointReference(jmsAxis2MessageContext.getReplyToAddress().trim()));
            }
            if (jmsAxis2MessageContext.getFaultToAddress() != null) {
                msgCtx.setFaultTo(new EndpointReference(jmsAxis2MessageContext.getFaultToAddress().trim()));
            }
            if (jmsAxis2MessageContext.getFromAddress() != null) {
                msgCtx.setFrom(new EndpointReference(jmsAxis2MessageContext.getFromAddress().trim()));
            }
            if (jmsAxis2MessageContext.getToAddress() != null) {
                msgCtx.getOptions().setTo(new EndpointReference(jmsAxis2MessageContext.getToAddress().trim()));
            }
            msgCtx.setProperties(jmsAxis2MessageContext.getProperties());
            msgCtx.setTransportIn(axisConfiguration.getTransportIn(jmsAxis2MessageContext.getTransportInName()));
            msgCtx.setTransportOut(axisConfiguration.getTransportOut(jmsAxis2MessageContext.getTransportOutName()));
            JMSPersistentSynapseMessage jmsSynpaseMessageContext = message.getJmsPersistentSynapseMessage();
            Axis2MessageContext synCtx = new Axis2MessageContext(msgCtx, configuration, this.synapseEnvironment);
            synCtx.setTracingState(jmsSynpaseMessageContext.getTracingState());
            for (String key : jmsSynpaseMessageContext.getProperties().keySet()) {
                String value = jmsSynpaseMessageContext.getProperties().get(key);
                synCtx.setProperty(key, (Object)value);
            }
            synCtx.setFaultResponse(jmsSynpaseMessageContext.isFaultResponse());
            synCtx.setResponse(jmsSynpaseMessageContext.isResponse());
            return synCtx;
        }
        catch (Exception e) {
            this.log.error((Object)("Error while deserializing the JMS Message " + e));
            return null;
        }
    }

    public JMSPersistentMessage createPersistentMessage(org.apache.synapse.MessageContext synCtx) {
        JMSPersistentMessage jmsMsg = new JMSPersistentMessage();
        JMSPersistentAxis2Message jmsAxis2MessageContext = new JMSPersistentAxis2Message();
        JMSPersistentSynapseMessage jmsSynpaseMessageContext = new JMSPersistentSynapseMessage();
        Axis2MessageContext axis2MessageContext = null;
        if (synCtx instanceof Axis2MessageContext) {
            axis2MessageContext = (Axis2MessageContext)synCtx;
            MessageContext msgCtx = axis2MessageContext.getAxis2MessageContext();
            jmsAxis2MessageContext.setMessageID(UUIDGenerator.getUUID());
            jmsAxis2MessageContext.setOperationAction(msgCtx.getAxisOperation().getSoapAction());
            jmsAxis2MessageContext.setOperationName(msgCtx.getAxisOperation().getName());
            jmsAxis2MessageContext.setAction(msgCtx.getOptions().getAction());
            jmsAxis2MessageContext.setService(msgCtx.getAxisService().getName());
            if (msgCtx.getRelatesTo() != null) {
                jmsAxis2MessageContext.setRelatesToMessageId(msgCtx.getRelatesTo().getValue());
            }
            if (msgCtx.getReplyTo() != null) {
                jmsAxis2MessageContext.setReplyToAddress(msgCtx.getReplyTo().getAddress());
            }
            if (msgCtx.getFaultTo() != null) {
                jmsAxis2MessageContext.setFaultToAddress(msgCtx.getFaultTo().getAddress());
            }
            if (msgCtx.getTo() != null) {
                jmsAxis2MessageContext.setToAddress(msgCtx.getTo().getAddress());
            }
            jmsAxis2MessageContext.setDoingPOX(msgCtx.isDoingREST());
            jmsAxis2MessageContext.setDoingMTOM(msgCtx.isDoingMTOM());
            jmsAxis2MessageContext.setDoingSWA(msgCtx.isDoingSwA());
            String soapEnvelope = msgCtx.getEnvelope().toString();
            jmsAxis2MessageContext.setSoapEnvelope(soapEnvelope);
            jmsAxis2MessageContext.setFLOW(msgCtx.getFLOW());
            jmsAxis2MessageContext.setTransportInName(msgCtx.getTransportIn().getName());
            jmsAxis2MessageContext.setTransportOutName(msgCtx.getTransportOut().getName());
            for (String key : msgCtx.getProperties().keySet()) {
                Object v = msgCtx.getProperty(key);
                String value = null;
                if (v != null) {
                    value = v.toString();
                }
                jmsAxis2MessageContext.addProperty(key, value);
            }
            jmsMsg.setJmsPersistentAxis2Message(jmsAxis2MessageContext);
            jmsSynpaseMessageContext.setFaultResponse(synCtx.isFaultResponse());
            jmsSynpaseMessageContext.setTracingState(synCtx.getTracingState());
            jmsSynpaseMessageContext.setResponse(synCtx.isResponse());
            for (String key : synCtx.getPropertyKeySet()) {
                Object v = synCtx.getProperty(key);
                String value = null;
                if (v != null) {
                    value = v.toString();
                }
                jmsSynpaseMessageContext.addPropertie(key, value);
            }
        } else {
            throw new SynapseException("Only Axis2 Messages are supported with JMSMessage store");
        }
        jmsMsg.setJmsPersistentSynapseMessage(jmsSynpaseMessageContext);
        return jmsMsg;
    }

    private SOAPEnvelope getSoapEnvelope(String soapEnvelpe) {
        try {
            Thread.currentThread().setContextClassLoader(SynapseEnvironment.class.getClassLoader());
            XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.getUTF8Bytes(soapEnvelpe)));
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlReader);
            SOAPEnvelope soapEnvelope = (SOAPEnvelope)builder.getDocumentElement();
            soapEnvelope.build();
            String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
            if (soapEnvelope.getHeader() == null) {
                SOAPFactory soapFactory = null;
                soapFactory = soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
                soapFactory.createSOAPHeader(soapEnvelope);
            }
            return soapEnvelope;
        }
        catch (XMLStreamException e) {
            this.log.error((Object)("Error while deserializing the SOAP " + e));
            return null;
        }
    }

    private byte[] getUTF8Bytes(String soapEnvelpe) {
        byte[] bytes = null;
        try {
            bytes = soapEnvelpe.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)("Unable to extract bytes in UTF-8 encoding. Extracting bytes in the system default encoding" + e.getMessage()));
            bytes = soapEnvelpe.getBytes();
        }
        return bytes;
    }
}

