/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.persistence.jms;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.store.AbstractMessageStore;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.message.store.persistence.jms.message.JMSPersistentMessage;
import org.wso2.carbon.message.store.persistence.jms.util.JMSPersistentMessageHelper;
import org.wso2.carbon.message.store.persistence.jms.util.JMSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSMessageStore
extends AbstractMessageStore {
    private Properties properties = new Properties();
    private Context jndiContext;
    private ConnectionFactory connectionFactory;
    private String username;
    private String password;
    private JMSPersistentMessageHelper jmsPersistentMessageHelper;
    private volatile AtomicInteger size = new AtomicInteger(0);
    private int cacheLevel = 0;
    private volatile Connection cachedReadConnection = null;
    private volatile Connection cachedWriteConnection = null;
    private String jmsMessageStoreDestination;
    private static final Log log = LogFactory.getLog(JMSMessageStore.class);
    private boolean jmsSpec11 = true;
    private Semaphore removeLock = new Semaphore(1);
    private Semaphore cleanUpOfferLock = new Semaphore(1);
    private AtomicBoolean cleaning = new AtomicBoolean(false);

    public void init(SynapseEnvironment se) {
        super.init(se);
        this.init();
        this.jmsPersistentMessageHelper = new JMSPersistentMessageHelper(se);
        this.syncSize();
    }

    public boolean offer(MessageContext messageContext) {
        if (messageContext != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing the Message with Id :" + messageContext.getMessageID() + " from the Message Store"));
            }
        } else {
            return false;
        }
        JMSPersistentMessage jmsMessage = this.jmsPersistentMessageHelper.createPersistentMessage(messageContext);
        Connection con = null;
        Session session = null;
        MessageProducer producer = null;
        boolean error = false;
        if (this.cleaning.get()) {
            try {
                this.cleanUpOfferLock.acquire();
            }
            catch (InterruptedException e) {
                log.error((Object)"Message Cleanup lock released unexpectedly,Message count value might show a wrong value ,Restart the system to re sync the message count", (Throwable)e);
            }
        }
        try {
            con = this.getWriteConnection();
            session = JMSUtil.createSession(con, this.jmsSpec11);
            Destination destination = this.getDestination(session);
            producer = JMSUtil.createProducer(session, destination, this.jmsSpec11);
            ObjectMessage objectMessage = session.createObjectMessage((Serializable)jmsMessage);
            producer.send((Message)objectMessage);
            this.size.incrementAndGet();
            this.cleanUpOfferLock.release();
            this.cleanupJMSResources(con, session, producer, error, ConnectionType.WRITE_CONNECTION);
        }
        catch (JMSException e) {
            try {
                log.error((Object)("JMS exception while saving a message to the store: " + this.name), (Throwable)e);
                error = true;
                throw new SynapseException("JMS Message Store Exception " + (Object)((Object)e));
            }
            catch (Throwable throwable) {
                this.cleanUpOfferLock.release();
                this.cleanupJMSResources(con, session, producer, error, ConnectionType.WRITE_CONNECTION);
                throw throwable;
            }
        }
        return true;
    }

    public MessageContext poll() {
        log.debug((Object)("Polling Message from Message store " + this.name));
        try {
            this.removeLock.acquire();
        }
        catch (InterruptedException e) {
            log.error((Object)"Message Removal lock released unexpectedly,Message count value might show a wrong value ,Restart the system to re sync the message count", (Throwable)e);
        }
        MessageContext smsg = null;
        Connection con = null;
        Session session = null;
        MessageConsumer consumer = null;
        boolean error = false;
        ClassLoader originalCl = this.getContextClassLoader();
        this.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            con = this.getWriteConnection();
            session = JMSUtil.createSession(con, this.jmsSpec11);
            Destination destination = this.getDestination(session);
            consumer = JMSUtil.createConsumer(session, destination, this.jmsSpec11);
            Message msg = consumer.receive(1000L);
            if (msg instanceof ObjectMessage) {
                JMSPersistentMessage jmsMeg = (JMSPersistentMessage)((ObjectMessage)msg).getObject();
                smsg = this.jmsPersistentMessageHelper.createMessageContext(jmsMeg);
            }
            this.removeLock.release();
            this.cleanupJMSResources(con, session, consumer, error, ConnectionType.WRITE_CONNECTION);
        }
        catch (JMSException e) {
            try {
                log.error((Object)("JMS error while removing messages from the store: " + this.name), (Throwable)e);
                error = true;
                throw new SynapseException("JMS Message Store Exception " + (Object)((Object)e));
            }
            catch (Throwable throwable) {
                this.removeLock.release();
                this.cleanupJMSResources(con, session, consumer, error, ConnectionType.WRITE_CONNECTION);
                throw throwable;
            }
        }
        this.size.decrementAndGet();
        this.setContextClassLoader(originalCl);
        return smsg;
    }

    public MessageContext peek() {
        Connection con = null;
        Session session = null;
        QueueBrowser browser = null;
        boolean error = false;
        ClassLoader originalClassLoader = this.getContextClassLoader();
        this.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        MessageContext messageContext = null;
        try {
            con = this.getReadConnection();
            session = JMSUtil.createSession(con, this.jmsSpec11);
            Destination destination = this.getDestination(session);
            browser = session.createBrowser((Queue)destination);
            Enumeration enumeration = browser.getEnumeration();
            if (enumeration.hasMoreElements()) {
                Object msg = enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                }
                JMSPersistentMessage jmsMeg = (JMSPersistentMessage)((ObjectMessage)msg).getObject();
                messageContext = this.jmsPersistentMessageHelper.createMessageContext(jmsMeg);
            }
            this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
        }
        catch (JMSException e) {
            try {
                log.error((Object)("JMS error while retrieving messages from the store: " + this.name), (Throwable)e);
                error = true;
                throw new SynapseException("JMS Message Store Exception " + (Object)((Object)e));
            }
            catch (Throwable throwable) {
                this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
                throw throwable;
            }
        }
        this.setContextClassLoader(originalClassLoader);
        return messageContext;
    }

    public MessageContext remove() throws NoSuchElementException {
        if (this.size.get() == 0) {
            throw new NoSuchElementException("Message Store " + this.name + " Empty");
        }
        return this.poll();
    }

    public void clear() {
        Connection con = null;
        Session session = null;
        MessageConsumer consumer = null;
        boolean error = false;
        int count = 0;
        try {
            this.removeLock.acquire();
            this.cleaning.set(true);
            this.cleanUpOfferLock.acquire();
        }
        catch (InterruptedException e) {
            log.error((Object)"Message Removal lock released unexpectedly,Message count value might show a wrong value ,Restart the system to re sync the message count", (Throwable)e);
        }
        ClassLoader originalClassLoader = this.getContextClassLoader();
        this.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Message message;
            con = this.getWriteConnection();
            session = JMSUtil.createSession(con, this.jmsSpec11);
            Destination destination = this.getDestination(session);
            consumer = JMSUtil.createConsumer(session, destination, this.jmsSpec11);
            count = this.size();
            for (int i = 0; i < count && (message = consumer.receive(1000L)) != null; ++i) {
            }
        }
        catch (JMSException e) {
            log.error((Object)"JMS error while deleting messages", (Throwable)e);
            error = true;
            throw new SynapseException("JMS Message Store Exception " + (Object)((Object)e));
        }
        finally {
            this.removeLock.release();
            this.cleaning.set(false);
            this.cleanUpOfferLock.release();
            this.size.set(this.size.get() - count);
            this.cleanupJMSResources(con, session, consumer, error, ConnectionType.WRITE_CONNECTION);
        }
        this.setContextClassLoader(originalClassLoader);
    }

    public MessageContext remove(String messageId) {
        throw new UnsupportedOperationException("Removing a Random Message is not supported in JMS Message store");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageContext get(int i) {
        if (i < 0 || i > this.size() - 1) {
            return null;
        }
        int pointer = 0;
        Connection con = null;
        Session session = null;
        QueueBrowser browser = null;
        boolean error = false;
        ClassLoader originalCl = this.getContextClassLoader();
        this.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        MessageContext messageContext = null;
        try {
            con = this.getReadConnection();
            session = JMSUtil.createSession(con, this.jmsSpec11);
            Destination destination = this.getDestination(session);
            browser = session.createBrowser((Queue)destination);
            Enumeration enumeration = browser.getEnumeration();
            while (enumeration.hasMoreElements()) {
                Object msg = enumeration.nextElement();
                if (pointer == i) {
                    if (msg != null) {
                        JMSPersistentMessage jmsMeg = (JMSPersistentMessage)((ObjectMessage)msg).getObject();
                        messageContext = this.jmsPersistentMessageHelper.createMessageContext(jmsMeg);
                        while (true) {
                            if (!enumeration.hasMoreElements()) {
                                MessageContext messageContext2 = messageContext;
                                this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
                                return messageContext2;
                            }
                            enumeration.nextElement();
                        }
                    }
                    MessageContext messageContext3 = null;
                    this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
                    return messageContext3;
                }
                ++pointer;
            }
        }
        catch (JMSException e) {
            try {
                log.error((Object)("JMS error while retrieving messages from the store: " + this.name), (Throwable)e);
                error = true;
                throw new SynapseException("JMS Message Store Exception " + (Object)((Object)e));
            }
            catch (Throwable throwable) {
                this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
                throw throwable;
            }
        }
        this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
        this.setContextClassLoader(originalCl);
        return messageContext;
    }

    public List<MessageContext> getAll() {
        ArrayList<MessageContext> list = new ArrayList<MessageContext>();
        Connection con = null;
        Session session = null;
        QueueBrowser browser = null;
        boolean error = false;
        ClassLoader originalCL = this.getContextClassLoader();
        this.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            con = this.getReadConnection();
            session = JMSUtil.createSession(con, this.jmsSpec11);
            Destination destination = this.getDestination(session);
            browser = session.createBrowser((Queue)destination);
            Enumeration enumeration = browser.getEnumeration();
            while (enumeration.hasMoreElements()) {
                Object msg = enumeration.nextElement();
                if (!(msg instanceof ObjectMessage)) continue;
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                }
                JMSPersistentMessage jmsMeg = (JMSPersistentMessage)((ObjectMessage)msg).getObject();
                list.add(this.jmsPersistentMessageHelper.createMessageContext(jmsMeg));
            }
            this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
        }
        catch (JMSException e) {
            try {
                log.error((Object)("JMS error while retrieving messages from the store: " + this.name), (Throwable)e);
                error = true;
                throw new SynapseException("JMS Message Store Exception " + (Object)((Object)e));
            }
            catch (Throwable throwable) {
                this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
                throw throwable;
            }
        }
        this.setContextClassLoader(originalCL);
        return list;
    }

    public MessageContext get(String s) {
        if (s == null) {
            return null;
        }
        Connection con = null;
        Session session = null;
        QueueBrowser browser = null;
        boolean error = false;
        ClassLoader originalCl = this.getContextClassLoader();
        this.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        MessageContext messageContext = null;
        try {
            con = this.getReadConnection();
            session = JMSUtil.createSession(con, this.jmsSpec11);
            Destination destination = this.getDestination(session);
            browser = session.createBrowser((Queue)destination);
            Enumeration enumeration = browser.getEnumeration();
            while (enumeration.hasMoreElements()) {
                Object msg = enumeration.nextElement();
                JMSPersistentMessage jmsMeg = (JMSPersistentMessage)((ObjectMessage)msg).getObject();
                if (!s.equals(jmsMeg.getJmsPersistentAxis2Message().getMessageID())) continue;
                messageContext = this.jmsPersistentMessageHelper.createMessageContext(jmsMeg);
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                }
                break block4;
            }
            this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
        }
        catch (JMSException e) {
            try {
                log.error((Object)("JMS error while retrieving messages from the store: " + this.name), (Throwable)e);
                error = true;
                throw new SynapseException("JMS Message Store Exception " + (Object)((Object)e));
            }
            catch (Throwable throwable) {
                this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
                throw throwable;
            }
        }
        this.setContextClassLoader(originalCl);
        return messageContext;
    }

    private Connection getReadConnection() throws JMSException {
        if (this.cacheLevel > 0) {
            return this.getCachedReadConnection();
        }
        return this.createConnection();
    }

    private Connection getWriteConnection() throws JMSException {
        if (this.cacheLevel > 0) {
            return this.getCachedWriteConnection();
        }
        return this.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination getDestination(Session session) throws JMSException {
        Destination destination = null;
        if (this.jmsMessageStoreDestination == null) {
            this.jmsMessageStoreDestination = this.name + "_Queue";
        }
        try {
            destination = JMSMessageStore.lookup(this.jndiContext, Destination.class, this.jmsMessageStoreDestination);
            return destination;
        }
        catch (NamingException e) {
            log.debug((Object)("Error creating Destination  " + this.jmsMessageStoreDestination + " : " + e + " Destination is not defined in the JNDI context"));
        }
        finally {
            if (destination == null) {
                destination = session.createQueue(this.jmsMessageStoreDestination);
            }
            return destination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getCachedReadConnection() throws JMSException {
        if (this.cachedReadConnection == null) {
            JMSMessageStore jMSMessageStore = this;
            synchronized (jMSMessageStore) {
                if (this.cachedReadConnection == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating a cached JMS connection for the store: " + this.name));
                    }
                    this.cachedReadConnection = this.createConnection();
                }
            }
        }
        return this.cachedReadConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getCachedWriteConnection() throws JMSException {
        if (this.cachedWriteConnection == null) {
            JMSMessageStore jMSMessageStore = this;
            synchronized (jMSMessageStore) {
                if (this.cachedWriteConnection == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating a cached JMS connection for the store: " + this.name));
                    }
                    this.cachedWriteConnection = this.createConnection();
                }
            }
        }
        return this.cachedWriteConnection;
    }

    private Connection createConnection() throws JMSException {
        Connection con = JMSUtil.createConnection(this.connectionFactory, this.username, this.password, this.jmsSpec11);
        con.start();
        return con;
    }

    private void init() {
        log.debug((Object)"Initializing the JMS Message Store");
        try {
            this.jndiContext = CarbonContext.getCurrentContext().getJNDIContext((Hashtable)this.properties);
            String connectionFac = (String)this.parameters.get("store.jms.connection.factory");
            if (connectionFac == null) {
                connectionFac = "QueueConnectionFactory";
            }
            this.connectionFactory = JMSMessageStore.lookup(this.jndiContext, ConnectionFactory.class, connectionFac);
            if (this.connectionFactory == null) {
                throw new SynapseException("Connection factory not found :QueueConnectionFactory");
            }
        }
        catch (NamingException e) {
            log.error((Object)"Naming Exception", (Throwable)e);
        }
    }

    private static <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException ex) {
            log.error((Object)("Error while performing the JNDI lookup for the name: " + name), (Throwable)ex);
            return null;
        }
    }

    public void setParameters(Map<String, Object> parameters) {
        super.setParameters(parameters);
        if (parameters != null && !parameters.isEmpty()) {
            String jmsSpecVersion;
            String jmsDest;
            Set<Map.Entry<String, Object>> mapSet = parameters.entrySet();
            for (Map.Entry<String, Object> e : mapSet) {
                if (!(e.getValue() instanceof String)) continue;
                this.properties.put(e.getKey(), e.getValue());
            }
            this.username = (String)parameters.get("store.jms.username");
            this.password = (String)parameters.get("store.jms.password");
            String conCaching = (String)parameters.get("store.jms.cache.connection");
            if ("true".equals(conCaching)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Enabling the connection Caching");
                }
                this.cacheLevel = 1;
            }
            if ((jmsDest = (String)parameters.get("store.jms.destination")) != null) {
                this.jmsMessageStoreDestination = jmsDest;
            }
            if ((jmsSpecVersion = (String)parameters.get("store.jms.JMSSpecVersion")) != null && !"1.1".equals(jmsSpecVersion)) {
                this.jmsSpec11 = false;
            }
        } else {
            throw new SynapseException("Required Parameters missing. Can't initialize JMS Message Store");
        }
    }

    private void cleanupJMSResources(Connection connection, Session session, Object jmsObject, boolean error, ConnectionType connectionType) {
        try {
            if (jmsObject != null) {
                if (jmsObject instanceof MessageProducer) {
                    ((MessageProducer)jmsObject).close();
                } else if (jmsObject instanceof MessageConsumer) {
                    ((MessageConsumer)jmsObject).close();
                } else if (jmsObject instanceof QueueBrowser) {
                    ((QueueBrowser)jmsObject).close();
                }
            }
        }
        catch (JMSException e) {
            log.error((Object)("Error while cleaning up JMS objects in the message store: " + this.name), (Throwable)e);
        }
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (JMSException e) {
            log.error((Object)("Error while cleaning up JMS session in the message store: " + this.name), (Throwable)e);
        }
        try {
            if (connection != null && this.cacheLevel == 0) {
                connection.close();
            } else if (error) {
                switch (connectionType) {
                    case READ_CONNECTION: {
                        this.cleanupCachedReadConnection();
                        break;
                    }
                    case WRITE_CONNECTION: {
                        this.cleanupCachedWriteConnection();
                    }
                }
            }
        }
        catch (JMSException e) {
            log.error((Object)("Error while cleaning up JMS connections in the message store: " + this.name), (Throwable)e);
        }
    }

    private synchronized void cleanupCachedReadConnection() {
        if (this.cachedReadConnection != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing the cached JMS connection in: " + this.name));
            }
            try {
                this.cachedReadConnection.close();
            }
            catch (JMSException e) {
                log.warn((Object)"Error closing the JMS connection", (Throwable)e);
            }
            this.cachedReadConnection = null;
        }
    }

    private synchronized void cleanupCachedWriteConnection() {
        if (this.cachedReadConnection != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing the cached JMS connection in: " + this.name));
            }
            try {
                this.cachedReadConnection.close();
            }
            catch (JMSException e) {
                log.warn((Object)"Error closing the JMS connection", (Throwable)e);
            }
            this.cachedReadConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncSize() {
        log.debug((Object)"Synchronizing Message Store size with the Queue Size");
        int count = 0;
        Connection con = null;
        Session session = null;
        QueueBrowser browser = null;
        boolean error = false;
        ClassLoader originalCL = this.getContextClassLoader();
        this.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            con = this.getReadConnection();
            session = con.createSession(false, 1);
            Destination destination = this.getDestination(session);
            browser = session.createBrowser((Queue)destination);
            Enumeration enumeration = browser.getEnumeration();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++count;
            }
            this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
        }
        catch (JMSException e) {
            try {
                log.error((Object)("JMS error while updating size of the store: " + this.name), (Throwable)e);
                error = true;
                this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
            }
            catch (Throwable throwable) {
                this.cleanupJMSResources(con, session, browser, error, ConnectionType.READ_CONNECTION);
                throw throwable;
            }
        }
        this.size.set(count);
        log.debug((Object)("Updated JMS Message Store Size :" + this.size));
        this.setContextClassLoader(originalCL);
    }

    private void setContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    public int size() {
        if (this.size.get() < 0) {
            this.size.set(0);
        }
        return this.size.get();
    }

    public void destroy() {
        super.destroy();
        try {
            this.cleanupCachedReadConnection();
            this.cleanupCachedWriteConnection();
            if (this.jndiContext != null) {
                this.jndiContext.close();
            }
        }
        catch (NamingException e) {
            log.error((Object)"Error closing the JNDI Context", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectionType {
        READ_CONNECTION,
        WRITE_CONNECTION;

    }
}

