/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.dblookup;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.datasource.ui.stub.DataSourceAdminStub;
import org.wso2.carbon.datasource.ui.stub.DataSourceManagementException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class DBLookupMediatorClient {
    private DataSourceAdminStub stub;
    private static final String DATASOURCE_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/datasource";
    private static final QName ROOT_QNAME = new QName("http://www.wso2.org/products/wso2commons/datasource", "datasourceExtension", "datasource");

    public DBLookupMediatorClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "DataSourceAdmin";
        this.stub = new DataSourceAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static DBLookupMediatorClient getInstance(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new DBLookupMediatorClient(cookie, backendServerURL, configContext);
    }

    public List<String> getAllDataSourceInformations() throws RemoteException, DataSourceManagementException {
        OMElement element = this.stub.getAllDataSourceInformation();
        ArrayList<String> sourceList = new ArrayList<String>();
        if (element == null) {
            return sourceList;
        }
        OMElement datasourceRoot = element.getFirstChildWithName(ROOT_QNAME);
        if (datasourceRoot == null) {
            return sourceList;
        }
        Iterator iterator = datasourceRoot.getChildElements();
        while (iterator.hasNext()) {
            String name;
            OMElement datasourceElement = (OMElement)iterator.next();
            if (datasourceElement == null || (name = datasourceElement.getAttributeValue(new QName("", "name", ""))) == null || "".equals(name)) continue;
            sourceList.add(name);
        }
        return sourceList;
    }
}

