/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.service.util.MediatorProperty;

public class ValidateMediator
extends AbstractListMediator {
    private static final QName ON_FAIL_Q = new QName("http://ws.apache.org/ns/synapse", "on-fail");
    private static final QName SCHEMA_Q = new QName("http://ws.apache.org/ns/synapse", "schema");
    private List<Value> schemaKeys = new ArrayList<Value>();
    private SynapseXPath source = null;
    private final List<MediatorProperty> explicityFeatures = new ArrayList<MediatorProperty>();
    Map<String, String> resources = new HashMap<String, String>();

    public String getTagLocalName() {
        return "validate";
    }

    public OMElement serialize(OMElement parent) {
        OMElement validate = fac.createOMElement("validate", synNS);
        ValidateMediator.saveTracingState((OMElement)validate, (Mediator)this);
        if (this.source != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.source, (OMElement)validate, (String)"source");
        }
        for (Value key : this.schemaKeys) {
            OMElement schema = fac.createOMElement("schema", synNS, (OMContainer)validate);
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(key, "key", schema);
        }
        if (!this.explicityFeatures.isEmpty()) {
            for (MediatorProperty mp : this.explicityFeatures) {
                OMElement feature = fac.createOMElement("feature", synNS, (OMContainer)validate);
                if (mp.getName() == null) {
                    throw new MediatorException("The Feature name is missing");
                }
                feature.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
                if (mp.getValue() != null) {
                    feature.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                    continue;
                }
                throw new MediatorException("The Feature value is missing");
            }
        }
        if (this.resources.size() > 0) {
            Set<String> resourceKeys = this.resources.keySet();
            Iterator<String> i = resourceKeys.iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                String value = this.resources.get(key);
                OMElement resource = fac.createOMElement("resource", synNS);
                resource.addAttribute("location", key, nullNS);
                resource.addAttribute("key", value, nullNS);
                validate.addChild((OMNode)resource);
            }
        }
        OMElement onFail = fac.createOMElement("on-fail", synNS, (OMContainer)validate);
        if (this.getList().isEmpty()) {
            throw new MediatorException("No 'Fault' mediator found within the on-fail section of the 'Validate' mediator.");
        }
        this.serializeChildren(onFail, this.getList());
        if (parent != null) {
            parent.addChild((OMNode)validate);
        }
        return validate;
    }

    public void build(OMElement elem) {
        ArrayList<Value> schemaKeys = new ArrayList<Value>();
        Iterator schemas = elem.getChildrenWithName(SCHEMA_Q);
        QName ATT_RESOURCE_QNAME = new QName("resource");
        Iterator itr = elem.getChildrenWithName(ATT_RESOURCE_QNAME);
        HashMap<String, String> validateResourecMap = new HashMap<String, String>();
        while (itr.hasNext()) {
            OMElement resourceElement = (OMElement)itr.next();
            QName ATT_RESOURCE_LOCATION_QNAME = new QName("location");
            QName ATT_RESOURCE_KEY_QNAME = new QName("key");
            OMAttribute locationAttr = resourceElement.getAttribute(ATT_RESOURCE_LOCATION_QNAME);
            OMAttribute keyAttr = resourceElement.getAttribute(ATT_RESOURCE_KEY_QNAME);
            validateResourecMap.put(locationAttr.getAttributeValue(), keyAttr.getAttributeValue());
        }
        this.resources = validateResourecMap;
        while (schemas.hasNext()) {
            Object o = schemas.next();
            if (o instanceof OMElement) {
                OMElement omElem = (OMElement)o;
                OMAttribute keyAtt = omElem.getAttribute(ATT_KEY);
                if (keyAtt != null) {
                    ValueFactory keyFactory = new ValueFactory();
                    Value key = keyFactory.createValue("key", omElem);
                    schemaKeys.add(key);
                    continue;
                }
                throw new MediatorException("A 'schema' definition must contain a local property 'key'");
            }
            throw new MediatorException("Invalid 'schema' declaration for validate mediator");
        }
        if (schemaKeys.size() == 0) {
            throw new MediatorException("No schemas specified for the validate mediator");
        }
        this.schemaKeys = schemaKeys;
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        if (attSource != null) {
            try {
                this.source = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_SOURCE);
            }
            catch (JaxenException e) {
                throw new MediatorException("Invalid XPath expression specified for attribute 'source'");
            }
        }
        OMElement onFail = null;
        Iterator iterator = elem.getChildrenWithName(ON_FAIL_Q);
        if (iterator.hasNext()) {
            onFail = (OMElement)iterator.next();
        }
        if (onFail == null || !onFail.getChildElements().hasNext()) {
            throw new MediatorException("A non-empty <on-fail> child element is required for the <validate> mediator");
        }
        this.addChildren(onFail, (ListMediator)this);
        this.processAuditStatus((Mediator)this, elem);
        for (Map.Entry entry : this.collectNameValuePairs(elem, FEATURE_Q).entrySet()) {
            boolean isFeatureEnabled;
            String value = (String)entry.getValue();
            if ("true".equals(value)) {
                isFeatureEnabled = true;
            } else if ("false".equals(value)) {
                isFeatureEnabled = false;
            } else {
                throw new MediatorException("The feature must have value true or false");
            }
            this.addFeature((String)entry.getKey(), isFeatureEnabled);
        }
    }

    public Object getFeature(String key) {
        for (MediatorProperty prop : this.explicityFeatures) {
            if (!key.equals(prop.getName())) continue;
            return prop.getValue();
        }
        return null;
    }

    public void addFeature(String featureName, boolean isFeatureEnable) {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(featureName);
        if (isFeatureEnable) {
            mp.setValue("true");
        } else {
            mp.setValue("false");
        }
        this.explicityFeatures.add(mp);
    }

    public void setSchemaKeys(List<Value> schemaKeys) {
        this.schemaKeys = schemaKeys;
    }

    public void setSource(SynapseXPath source) {
        this.source = source;
    }

    public SynapseXPath getSource() {
        return this.source;
    }

    public List<Value> getSchemaKeys() {
        return this.schemaKeys;
    }

    public List<MediatorProperty> getFeatures() {
        return this.explicityFeatures;
    }

    public void setResources(Map<String, String> resources) {
        this.resources = resources;
    }

    public Map<String, String> getResources() {
        return this.resources;
    }
}

