/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.spring;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class SpringMediator
extends AbstractMediator {
    private String beanName = null;
    private String configKey = null;
    private static final OMNamespace sprNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "spring");

    public String getBeanName() {
        return this.beanName;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public String getTagLocalName() {
        return "spring";
    }

    public OMElement serialize(OMElement parent) {
        OMElement spring = fac.createOMElement("spring", sprNS);
        if (this.beanName == null) {
            throw new MediatorException("Invalid mediator. Bean name required.");
        }
        spring.addAttribute(fac.createOMAttribute("bean", nullNS, this.beanName));
        SpringMediator.saveTracingState((OMElement)spring, (Mediator)this);
        if (this.configKey != null) {
            spring.addAttribute(fac.createOMAttribute("key", nullNS, this.configKey));
        }
        if (parent != null) {
            parent.addChild((OMNode)spring);
        }
        return spring;
    }

    public void build(OMElement elem) {
        OMAttribute bean = elem.getAttribute(new QName("", "bean"));
        OMAttribute key = elem.getAttribute(new QName("", "key"));
        if (bean == null) {
            throw new MediatorException("The 'bean' attribute is required for a Spring mediator definition");
        }
        if (key == null) {
            throw new MediatorException("A 'key' attribute is required for a Spring mediator definition");
        }
        this.processAuditStatus((Mediator)this, elem);
        this.beanName = bean.getAttributeValue();
        this.configKey = key.getAttributeValue();
    }
}

