/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.configadmin.ui;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.configadmin.stub.ConfigServiceAdminStub;
import org.wso2.carbon.mediation.configadmin.stub.types.carbon.ConfigurationInformation;
import org.wso2.carbon.mediation.configadmin.stub.types.carbon.ValidationError;
import org.wso2.carbon.mediation.configadmin.ui.ConfigManagementClientUtils;
import org.wso2.carbon.mediation.configadmin.ui.ResponseInformation;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ConfigManagementClient {
    private static final Log log = LogFactory.getLog(ConfigManagementClient.class);
    private ConfigServiceAdminStub stub;

    private ConfigManagementClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "ConfigServiceAdmin";
        this.stub = new ConfigServiceAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setTimeOutInMilliSeconds(900000L);
        option.setProperty("SO_TIMEOUT", (Object)900000);
        option.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static ConfigManagementClient getInstance(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new ConfigManagementClient(cookie, backendServerURL, configContext);
    }

    public ResponseInformation getConfiguration(HttpSession session) {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            String config = this.stub.getConfiguration();
            responseInformation.setResult(config);
            ConfigManagementClientUtils.setCachedConfiguration(config, session);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation updateConfiguration(String configElement, HttpSession session) {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.updateConfiguration(ConfigManagementClient.createOMElement(configElement));
            ConfigManagementClientUtils.setCachedConfiguration(configElement, session);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation validateConfiguration(String configElement) {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            ValidationError[] errors = this.stub.validateConfiguration(ConfigManagementClient.createOMElement(configElement));
            if (errors == null || errors.length == 0 || errors[0] == null) {
                responseInformation.setResult(null);
            } else {
                responseInformation.setResult(errors);
            }
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation saveConfigurationToDisk() {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.saveConfigurationToDisk();
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation getConfigurations() {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            ConfigurationInformation[] list = this.stub.getConfigurationList();
            ArrayList configList = new ArrayList();
            if (list != null && (list.length > 1 || list.length == 1 && list[0] != null)) {
                Collections.addAll(configList, list);
            }
            responseInformation.setResult(configList);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation deleteConfiguration(String name) {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.deleteConfiguration(name);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation loadConfiguration(String name) {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.activate(name);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation newConfiguration(String name, String description) {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.create(name, description);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    public ResponseInformation addConfiguration(String name) {
        ResponseInformation responseInformation = new ResponseInformation();
        try {
            this.stub.addExistingConfiguration(name);
        }
        catch (Exception e) {
            responseInformation.setFault(true);
            responseInformation.setMessage(e.getMessage());
        }
        return responseInformation;
    }

    private static OMElement createOMElement(String xml) throws ServletException {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            return builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            ConfigManagementClient.handleException("Invalid XML " + xml);
            return null;
        }
    }

    private static void handleException(String msg) throws ServletException {
        log.error((Object)msg);
        throw new ServletException(msg);
    }
}

