/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.urlrewrite;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactoryFinder;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializer;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializerFinder;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.urlrewrite.URLRewriteActions;

public class URLRulesMediator
extends AbstractMediator {
    private String condition;
    private Evaluator evaluator;
    private final List<URLRewriteActions> actions = new ArrayList<URLRewriteActions>();

    public String getTagLocalName() {
        return "rewriterule";
    }

    public String getCondition() {
        EvaluatorSerializer evaluatorSerializer = EvaluatorSerializerFinder.getInstance().getSerializer(this.evaluator.getName());
        if (evaluatorSerializer != null) {
            OMElement conditionElem = fac.createOMElement("condition", synNS);
            try {
                evaluatorSerializer.serialize(conditionElem, this.evaluator);
            }
            catch (EvaluatorException e) {
                throw new MediatorException("Invalid condition" + (Object)((Object)e));
            }
            this.condition = conditionElem.getFirstOMChild().toString();
        }
        return this.condition;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setEvaluator() {
        this.evaluator = null;
    }

    public void setEvaluator(OMElement evaluatorElem) throws EvaluatorException {
        this.evaluator = EvaluatorFactoryFinder.getInstance().getEvaluator(evaluatorElem.getFirstElement());
    }

    public List<URLRewriteActions> getActions() {
        return this.actions;
    }

    public void addActions(URLRewriteActions urlRewriteActions) {
        this.actions.add(urlRewriteActions);
    }

    public void addAllActions(List<URLRewriteActions> list) {
        this.actions.addAll(list);
    }

    public OMElement serialize(OMElement parent) {
        EvaluatorSerializer evaluatorSerializer;
        OMElement urlRule = fac.createOMElement("rewriterule", synNS);
        URLRulesMediator.saveTracingState((OMElement)urlRule, (Mediator)this);
        if (this.evaluator != null && (evaluatorSerializer = EvaluatorSerializerFinder.getInstance().getSerializer(this.evaluator.getName())) != null) {
            OMElement conditionElement = fac.createOMElement("condition", synNS);
            try {
                evaluatorSerializer.serialize(conditionElement, this.evaluator);
            }
            catch (EvaluatorException ee) {
                // empty catch block
            }
            urlRule.addChild((OMNode)conditionElement);
        }
        this.serializeAction(urlRule);
        if (parent != null) {
            parent.addChild((OMNode)urlRule);
        }
        return urlRule;
    }

    private void serializeAction(OMElement parent) {
        for (URLRewriteActions rewriteAction : this.actions) {
            String type = rewriteAction.getAction();
            String value = rewriteAction.getValue();
            SynapseXPath xpath = rewriteAction.getXpath();
            String regex = rewriteAction.getRegex();
            String fragment = rewriteAction.getFragment();
            OMElement actionElement = fac.createOMElement("action", synNS);
            if ("append".equals(type) || "prepend".equals(type) || "set".equals(type) || "replace".equals(type)) {
                if (value == null && xpath == null || value != null && value.isEmpty()) {
                    throw new MediatorException("At URL rules definition if the action sets as (Set or Append or Prepend),then repalced actions required value or xpath expression");
                }
                if (xpath != null) {
                    SynapseXPathSerializer.serializeXPath((SynapseXPath)xpath, (OMElement)actionElement, (String)"xpath");
                }
                if (value != null) {
                    actionElement.addAttribute(fac.createOMAttribute("value", nullNS, value));
                }
            }
            if ("replace".equals(type)) {
                if (regex != null) {
                    actionElement.addAttribute(fac.createOMAttribute("regex", nullNS, regex));
                } else {
                    throw new MediatorException("Replace action needs 'regex'attribute to be specified");
                }
            }
            if (type != null) {
                actionElement.addAttribute(fac.createOMAttribute("type", nullNS, type));
            }
            if (fragment != "full") {
                actionElement.addAttribute(fac.createOMAttribute("fragment", nullNS, rewriteAction.getFragment()));
            }
            parent.addChild((OMNode)actionElement);
        }
    }

    public void build(OMElement elem) {
        QName CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "condition");
        OMElement condEle = elem.getFirstChildWithName(CONDITION_Q);
        if (this.getActions() != null) {
            this.getActions().clear();
        }
        this.addAllActions(URLRewriteActions.getAllActions(elem));
        if (condEle != null) {
            try {
                this.evaluator = EvaluatorFactoryFinder.getInstance().getEvaluator(condEle.getFirstElement());
            }
            catch (EvaluatorException ee) {
                String msg = "Issue in the condition :";
                throw new MediatorException(msg + (Object)((Object)ee));
            }
        }
        this.processAuditStatus((Mediator)this, elem);
    }
}

