/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpelNodeImpl
implements SpelNode {
    private static SpelNodeImpl[] NO_CHILDREN = new SpelNodeImpl[0];
    protected int pos;
    protected SpelNodeImpl[] children = NO_CHILDREN;
    private SpelNodeImpl parent;

    public SpelNodeImpl(int pos, SpelNodeImpl ... operands) {
        this.pos = pos;
        Assert.isTrue(pos != 0);
        if (operands != null && operands.length > 0) {
            this.children = operands;
            SpelNodeImpl[] spelNodeImplArray = operands;
            int n = operands.length;
            int n2 = 0;
            while (n2 < n) {
                SpelNodeImpl childnode = spelNodeImplArray[n2];
                childnode.parent = this;
                ++n2;
            }
        }
    }

    protected SpelNodeImpl getPreviousChild() {
        SpelNodeImpl result = null;
        if (this.parent != null) {
            SpelNodeImpl[] spelNodeImplArray = this.parent.children;
            int n = this.parent.children.length;
            int n2 = 0;
            while (n2 < n) {
                SpelNodeImpl child = spelNodeImplArray[n2];
                if (this == child) break;
                result = child;
                ++n2;
            }
        }
        return result;
    }

    protected boolean nextChildIs(Class ... clazzes) {
        if (this.parent != null) {
            SpelNodeImpl[] peers = this.parent.children;
            int i = 0;
            int max = peers.length;
            while (i < max) {
                if (peers[i] == this) {
                    if (i + 1 >= max) {
                        return false;
                    }
                    Class<?> clazz = peers[i + 1].getClass();
                    Class[] classArray = clazzes;
                    int n = clazzes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class desiredClazz = classArray[n2];
                        if (clazz.equals(desiredClazz)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public final Object getValue(ExpressionState expressionState) throws EvaluationException {
        if (expressionState != null) {
            return this.getValueInternal(expressionState).getValue();
        }
        return this.getValue(new ExpressionState(new StandardEvaluationContext()));
    }

    @Override
    public final TypedValue getTypedValue(ExpressionState expressionState) throws EvaluationException {
        if (expressionState != null) {
            return this.getValueInternal(expressionState);
        }
        return this.getTypedValue(new ExpressionState(new StandardEvaluationContext()));
    }

    @Override
    public boolean isWritable(ExpressionState expressionState) throws EvaluationException {
        return false;
    }

    @Override
    public void setValue(ExpressionState expressionState, Object newValue) throws EvaluationException {
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.SETVALUE_NOT_SUPPORTED, this.getClass());
    }

    @Override
    public SpelNode getChild(int index) {
        return this.children[index];
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    public Class<?> getObjectClass(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof Class ? (Class<?>)obj : obj.getClass();
    }

    protected final <T> T getValue(ExpressionState state, Class<T> desiredReturnType) throws EvaluationException {
        Object result = this.getValueInternal(state).getValue();
        if (result != null && desiredReturnType != null) {
            Class<?> resultType = result.getClass();
            if (desiredReturnType.isAssignableFrom(resultType)) {
                return (T)result;
            }
            return ExpressionUtils.convert(state.getEvaluationContext(), result, desiredReturnType);
        }
        return (T)result;
    }

    public abstract TypedValue getValueInternal(ExpressionState var1) throws EvaluationException;

    @Override
    public abstract String toStringAST();

    @Override
    public int getStartPosition() {
        return this.pos >> 16;
    }

    @Override
    public int getEndPosition() {
        return this.pos & 0xFFFF;
    }
}

