/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.store;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class MessageStoreMediator
extends AbstractMediator {
    private static final QName STORE_Q = new QName("http://ws.apache.org/ns/synapse", "store");
    private static final String ATT_MESSAGE_STORE = "messageStore";
    private static final String ATT_SEQUENCE = "sequence";
    private static final QName ATT_MESSAGE_STORE_Q = new QName("messageStore");
    private static final QName ATT_SEQUENCE_Q = new QName("sequence");
    private String messageStoreName;
    private String sequence;
    private String name;

    public String getTagLocalName() {
        return "store";
    }

    public String getMessageStoreName() {
        return this.messageStoreName;
    }

    public void setMessageStoreName(String messageStoreName) {
        this.messageStoreName = messageStoreName;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        if ("".equalsIgnoreCase(sequence)) {
            sequence = null;
        } else {
            this.sequence = sequence;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OMElement serialize(OMElement parent) {
        OMElement storeElem = fac.createOMElement(STORE_Q);
        if (this.name != null) {
            OMAttribute nameAtt = fac.createOMAttribute("name", nullNS, this.name);
            storeElem.addAttribute(nameAtt);
        }
        if (this.messageStoreName != null) {
            OMAttribute msName = fac.createOMAttribute(ATT_MESSAGE_STORE, nullNS, this.messageStoreName);
            storeElem.addAttribute(msName);
        } else {
            this.handleException("Can't serialize MessageStore Mediator message store is null ");
        }
        if (this.sequence != null) {
            OMAttribute sequenceAtt = fac.createOMAttribute(ATT_SEQUENCE, nullNS, this.sequence);
            storeElem.addAttribute(sequenceAtt);
        }
        if (parent != null) {
            parent.addChild((OMNode)storeElem);
        }
        return storeElem;
    }

    public void build(OMElement elem) {
        this.processAuditStatus((Mediator)this, elem);
        OMAttribute msName = elem.getAttribute(ATT_MESSAGE_STORE_Q);
        if (msName == null) {
            String msg = "Name of the Message Store name is a required attribute";
            throw new MediatorException(msg);
        }
        this.messageStoreName = msName.getAttributeValue();
        OMAttribute sqName = elem.getAttribute(ATT_SEQUENCE_Q);
        if (sqName != null) {
            this.sequence = sqName.getAttributeValue();
        }
    }

    private void handleException(String msg) {
        LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)msg);
        throw new SynapseException(msg);
    }
}

