/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.event.ui;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.event.stub.service.EventSourceAdminServiceStub;
import org.wso2.carbon.mediator.event.stub.service.xsd.dto.EventSourceDTO;

public class EventingSourceAdminClient {
    private static final Log log = LogFactory.getLog(EventingSourceAdminClient.class);
    private EventSourceAdminServiceStub stub;

    public EventingSourceAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "EventSourceAdminService";
        this.stub = new EventSourceAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public EventSourceDTO[] getEventSources() throws AxisFault {
        try {
            return this.stub.getEventSources();
        }
        catch (RemoteException e) {
            this.handleException("Error while retreiving the eventsources", e);
            return null;
        }
    }

    public EventSourceDTO getEventSource(String eventSourceName) throws AxisFault {
        try {
            return this.stub.getEventSource(eventSourceName);
        }
        catch (RemoteException e) {
            this.handleException("Error while retreiving the eventsource " + eventSourceName, e);
            return null;
        }
    }

    public void addEventSource(EventSourceDTO eventsource) throws AxisFault {
        try {
            this.stub.addEventSource(eventsource);
        }
        catch (RemoteException e) {
            this.handleException("Error while adding the eventsource " + eventsource.getName(), e);
        }
    }

    public void saveEventSource(EventSourceDTO eventsource) throws AxisFault {
        try {
            this.stub.saveEventSource(eventsource);
        }
        catch (RemoteException e) {
            this.handleException("Error while adding the eventsource " + eventsource.getName(), e);
        }
    }

    public void removeEventSource(String name) throws AxisFault {
        try {
            this.stub.removeEventSource(name);
        }
        catch (RemoteException e) {
            this.handleException("Error while removing the eventsource " + name, e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

