/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.ui.endpoints.wsdl;

import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointFactory;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.wso2.carbon.endpoint.ui.endpoints.Endpoint;
import org.wso2.carbon.endpoint.ui.util.EndpointConfigurationHelper;

public class WsdlEndpoint
extends Endpoint {
    private String epName;
    private String service;
    private String uri;
    private String port;
    private String suspendDurationOnFailure;
    private String maxSusDuration;
    private String susProgFactor;
    private String errorCodes;
    private String timedOutErrorCodes;
    private String retryDisabledErrorCodes;
    private String retryTimeout;
    private String retryDelay;
    private String timeoutAct;
    private String timeoutActionDuration;
    private boolean wsadd;
    private boolean sepList;
    private boolean wssec;
    private boolean wsrm;
    private String secPolKey;
    private String rmPolKey;
    private String description = "";
    private String properties;

    @Override
    public String getTagLocalName() {
        return "wsdl";
    }

    public String getEpName() {
        return this.epName;
    }

    public void setEpName(String as1) {
        this.epName = as1;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSuspendDurationOnFailure() {
        return this.suspendDurationOnFailure;
    }

    public void setSuspendDurationOnFailure(String suspendDurationOnFailure) {
        this.suspendDurationOnFailure = suspendDurationOnFailure;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getTimeoutAct() {
        return this.timeoutAct;
    }

    public void setTimeoutAct(String timeoutAct) {
        this.timeoutAct = timeoutAct.equals("101") ? "discard" : (timeoutAct.equals("102") ? "fault" : (timeoutAct.equals("100") ? null : timeoutAct));
    }

    public String getTimeoutActionDuration() {
        return this.timeoutActionDuration;
    }

    public void setTimeoutActionDuration(String timeoutActionDuration) {
        this.timeoutActionDuration = timeoutActionDuration;
    }

    public boolean isWsadd() {
        return this.wsadd;
    }

    public void setWsadd(boolean wsadd) {
        this.wsadd = wsadd;
    }

    public boolean isSepList() {
        return this.sepList;
    }

    public void setSepList(boolean sepList) {
        this.sepList = sepList;
    }

    public boolean isWssec() {
        return this.wssec;
    }

    public void setWssec(boolean wssec) {
        this.wssec = wssec;
    }

    public boolean isWsrm() {
        return this.wsrm;
    }

    public void setWsrm(boolean wsrm) {
        this.wsrm = wsrm;
    }

    public String getSecPolKey() {
        return this.secPolKey;
    }

    public void setSecPolKey(String secPolKey) {
        this.secPolKey = secPolKey;
    }

    public String getRmPolKey() {
        return this.rmPolKey;
    }

    public void setRmPolKey(String rmPolKey) {
        this.rmPolKey = rmPolKey;
    }

    public String getMaxSusDuration() {
        return this.maxSusDuration;
    }

    public void setMaxSusDuration(String maxSusDuration) {
        this.maxSusDuration = maxSusDuration;
    }

    public String getSusProgFactor() {
        return this.susProgFactor;
    }

    public void setSusProgFactor(String susProgFactor) {
        this.susProgFactor = susProgFactor;
    }

    public String getErrorCodes() {
        return this.errorCodes;
    }

    public void setErrorCodes(String errorCodes) {
        this.errorCodes = errorCodes;
    }

    public String getTimedOutErrorCodes() {
        return this.timedOutErrorCodes;
    }

    public void setTimedOutErrorCodes(String timdedOutErrorCodes) {
        this.timedOutErrorCodes = timdedOutErrorCodes;
    }

    public String getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(String retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public String getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(String retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void setRetryDisabledErrorCodes(String retryDisabledErrorCodes) {
        this.retryDisabledErrorCodes = retryDisabledErrorCodes;
    }

    public String getRetryDisabledErrorCodes() {
        return this.retryDisabledErrorCodes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Override
    public OMElement serialize(OMElement parent) {
        OMElement endpoint = fac.createOMElement("endpoint", synNS);
        if (this.epName != null && !"".equals(this.epName)) {
            endpoint.addAttribute(fac.createOMAttribute("name", nullNS, this.epName));
        }
        OMElement wsdl = fac.createOMElement("wsdl", synNS);
        if (this.getUri() != null) {
            wsdl.addAttribute(fac.createOMAttribute("uri", nullNS, this.uri));
        }
        if (this.service != null) {
            wsdl.addAttribute(fac.createOMAttribute("service", nullNS, this.service));
        }
        if (this.port != null) {
            wsdl.addAttribute(fac.createOMAttribute("port", nullNS, this.port));
        }
        if (this.errorCodes != null && !"".equals(this.errorCodes) || this.suspendDurationOnFailure != null && !"".equals(this.suspendDurationOnFailure) || this.maxSusDuration != null && !"".equals(this.maxSusDuration) || this.susProgFactor != null && !"".equals(this.susProgFactor)) {
            OMElement suspendOnFailure = fac.createOMElement("suspendOnFailure", synNS);
            if (this.errorCodes != null && !"".equals(this.errorCodes)) {
                OMElement errorCodesElement = fac.createOMElement("errorCodes", synNS);
                errorCodesElement.setText(this.errorCodes.trim());
                suspendOnFailure.addChild((OMNode)errorCodesElement);
            }
            if (this.suspendDurationOnFailure != null && !"".equals(this.suspendDurationOnFailure)) {
                OMElement initialDuration = fac.createOMElement("initialDuration", synNS);
                initialDuration.setText(this.suspendDurationOnFailure.trim().startsWith("$") ? this.suspendDurationOnFailure.trim() : Long.valueOf(this.getSuspendDurationOnFailure().trim()).toString());
                suspendOnFailure.addChild((OMNode)initialDuration);
            }
            if (this.susProgFactor != null && !"".equals(this.susProgFactor)) {
                OMElement progressionFactor = fac.createOMElement("progressionFactor", synNS);
                progressionFactor.setText(this.susProgFactor.trim().startsWith("$") ? this.susProgFactor : Float.valueOf(this.susProgFactor).toString());
                suspendOnFailure.addChild((OMNode)progressionFactor);
            }
            if (this.maxSusDuration != null && !"".equals(this.maxSusDuration)) {
                OMElement maxumumDuration = fac.createOMElement("maximumDuration", synNS);
                maxumumDuration.setText(this.maxSusDuration.trim().startsWith("$") ? this.maxSusDuration.trim() : Long.valueOf(this.maxSusDuration.trim()).toString());
                suspendOnFailure.addChild((OMNode)maxumumDuration);
            }
            wsdl.addChild((OMNode)suspendOnFailure);
        }
        if (this.timedOutErrorCodes != null && !"".equals(this.timedOutErrorCodes) || this.retryDelay != null && !"".equals(this.retryDelay) || this.retryTimeout != null && !"".equals(this.retryTimeout)) {
            OMElement markForSuspension = fac.createOMElement("markForSuspension", synNS);
            if (this.timedOutErrorCodes != null && !"".equals(this.timedOutErrorCodes)) {
                OMElement timedOutErrorCodesElement = fac.createOMElement("errorCodes", synNS);
                timedOutErrorCodesElement.setText(this.timedOutErrorCodes.trim());
                markForSuspension.addChild((OMNode)timedOutErrorCodesElement);
            }
            if (this.retryTimeout != null && !"".equals(this.retryTimeout)) {
                OMElement retryTimeoutElement = fac.createOMElement("retriesBeforeSuspension", synNS);
                retryTimeoutElement.setText(this.retryTimeout);
                markForSuspension.addChild((OMNode)retryTimeoutElement);
            }
            if (this.retryDelay != null && !"".equals(this.retryDelay)) {
                OMElement retryDelayElement = fac.createOMElement("retryDelay", synNS);
                retryDelayElement.setText(this.retryDelay);
                markForSuspension.addChild((OMNode)retryDelayElement);
            }
            wsdl.addChild((OMNode)markForSuspension);
        }
        if (this.retryDisabledErrorCodes != null && !"".equals(this.retryDisabledErrorCodes)) {
            OMElement retryConfig = fac.createOMElement("retryConfig", synNS);
            OMElement disabledErrorCodes = fac.createOMElement("disabledErrorCodes", synNS);
            disabledErrorCodes.setText(this.retryDisabledErrorCodes);
            retryConfig.addChild((OMNode)disabledErrorCodes);
            wsdl.addChild((OMNode)retryConfig);
        }
        if ((this.timeoutAct != null && !"".equals(this.timeoutAct) || this.timeoutActionDuration != null && !"".equals(this.timeoutActionDuration)) && !"neverTimeout".equals(this.timeoutAct)) {
            OMElement timeout = fac.createOMElement("timeout", synNS);
            if (this.timeoutActionDuration != null && !"".equals(this.timeoutActionDuration)) {
                OMElement duration = fac.createOMElement("duration", synNS);
                duration.setText(this.timeoutActionDuration.trim());
                timeout.addChild((OMNode)duration);
            }
            if (this.timeoutAct != null && !"".equals(this.timeoutAct)) {
                OMElement responseAction = fac.createOMElement("responseAction", synNS);
                responseAction.setText(this.timeoutAct);
                timeout.addChild((OMNode)responseAction);
            }
            wsdl.addChild((OMNode)timeout);
        }
        if (this.wsadd) {
            OMElement enableAddressing = fac.createOMElement("enableAddressing", synNS);
            if (this.sepList) {
                enableAddressing.addAttribute(fac.createOMAttribute("separateListener", nullNS, "true"));
            }
            wsdl.addChild((OMNode)enableAddressing);
        }
        if (this.wssec) {
            OMElement enableSecurity = fac.createOMElement("enableSec", synNS);
            if (this.secPolKey != null && !"".equals(this.secPolKey)) {
                enableSecurity.addAttribute(fac.createOMAttribute("policy", nullNS, this.secPolKey));
            }
            wsdl.addChild((OMNode)enableSecurity);
        }
        if (this.wsrm) {
            OMElement enableRM = fac.createOMElement("enableRM", synNS);
            if (this.rmPolKey != null && !"".equals(this.rmPolKey)) {
                enableRM.addAttribute(fac.createOMAttribute("policy", nullNS, this.rmPolKey));
            }
            wsdl.addChild((OMNode)enableRM);
        }
        endpoint.addChild((OMNode)wsdl);
        if (this.properties != null && this.properties.length() != 0) {
            String[] props;
            for (String s : props = this.properties.split("::")) {
                String[] elements = s.split(",");
                OMElement property = fac.createOMElement("property", synNS);
                property.addAttribute(fac.createOMAttribute("name", nullNS, elements[0]));
                property.addAttribute(fac.createOMAttribute("value", nullNS, elements[1]));
                property.addAttribute(fac.createOMAttribute("scope", nullNS, elements[2]));
                endpoint.addChild((OMNode)property);
            }
        }
        if (this.description != null && !this.description.equals("")) {
            OMElement descriptionElement = fac.createOMElement("description", synNS);
            descriptionElement.setText(this.description);
            endpoint.addChild((OMNode)descriptionElement);
        }
        if (parent != null) {
            parent.addChild((OMNode)endpoint);
        }
        return endpoint;
    }

    @Override
    public void build(OMElement elem, boolean isAnonymous) {
        if (isAnonymous) {
            elem.addAttribute("name", "anonymous", elem.getOMFactory().createOMNamespace("", ""));
        }
        Properties properties = new Properties();
        WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)WSDLEndpointFactory.getEndpointFromElement((OMElement)elem, (boolean)isAnonymous, (Properties)properties);
        this.buildData(wsdlEndpoint);
    }

    @Override
    public void build(Template template, DefinitionFactory factory) {
        OMElement endpointEl = template.getElement();
        if (endpointEl != null) {
            Properties properties = new Properties();
            properties.setProperty("skip.wsdl.parsing", "true");
            org.apache.synapse.endpoints.Endpoint endpoint = EndpointFactory.getEndpointFromElement((OMElement)endpointEl, (DefinitionFactory)factory, (boolean)false, (Properties)properties);
            if (endpoint != null && endpoint instanceof WSDLEndpoint) {
                WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)endpoint;
                this.buildData(wsdlEndpoint);
            }
        }
    }

    private void buildData(WSDLEndpoint wsdlEndpoint) {
        this.setEpName(wsdlEndpoint.getName().equals("anonymous") ? "" : wsdlEndpoint.getName());
        this.setUri(wsdlEndpoint.getWsdlURI());
        this.setService(wsdlEndpoint.getServiceName());
        this.setPort(wsdlEndpoint.getPortName());
        this.setDescription(wsdlEndpoint.getDescription());
        if (wsdlEndpoint.getDefinition().getInitialSuspendDuration() != -1L) {
            this.setSuspendDurationOnFailure(String.valueOf(wsdlEndpoint.getDefinition().getInitialSuspendDuration()));
        }
        this.setTimeoutAct(String.valueOf(wsdlEndpoint.getDefinition().getTimeoutAction()));
        if (wsdlEndpoint.getDefinition().getTimeoutDuration() > 0L) {
            this.setTimeoutActionDuration(String.valueOf(wsdlEndpoint.getDefinition().getTimeoutDuration()));
        }
        this.setWsadd(wsdlEndpoint.getDefinition().isAddressingOn());
        this.setSepList(wsdlEndpoint.getDefinition().isUseSeparateListener());
        this.setWssec(wsdlEndpoint.getDefinition().isSecurityOn());
        this.setWsrm(wsdlEndpoint.getDefinition().isReliableMessagingOn());
        this.setRmPolKey(wsdlEndpoint.getDefinition().getWsRMPolicyKey());
        this.setSecPolKey(wsdlEndpoint.getDefinition().getWsSecPolicyKey());
        if (wsdlEndpoint.getDefinition().getSuspendMaximumDuration() < Long.MAX_VALUE) {
            this.setMaxSusDuration(String.valueOf(wsdlEndpoint.getDefinition().getSuspendMaximumDuration()));
        }
        this.setSusProgFactor(String.valueOf(wsdlEndpoint.getDefinition().getSuspendProgressionFactor()));
        this.setErrorCodes(EndpointConfigurationHelper.errorCodeListBuilder(wsdlEndpoint.getDefinition().getSuspendErrorCodes()).trim());
        this.setRetryDisabledErrorCodes(EndpointConfigurationHelper.errorCodeListBuilder(wsdlEndpoint.getDefinition().getRetryDisabledErrorCodes()).trim());
        this.setTimedOutErrorCodes(EndpointConfigurationHelper.errorCodeListBuilder(wsdlEndpoint.getDefinition().getTimeoutErrorCodes()));
        this.setRetryTimeout(String.valueOf(wsdlEndpoint.getDefinition().getRetryDurationOnTimeout()));
        this.setRetryDelay(String.valueOf(wsdlEndpoint.getDefinition().getRetriesOnTimeoutBeforeSuspend()));
        this.setProperties(EndpointConfigurationHelper.buildPropertyString((AbstractEndpoint)wsdlEndpoint));
    }
}

