/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.ui.endpoints.loadbalance;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointFactory;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.Template;
import org.wso2.carbon.endpoint.ui.endpoints.ListEndpoint;
import org.wso2.carbon.endpoint.ui.util.EndpointConfigurationHelper;

public class LoadBalanceEndpoint
extends ListEndpoint {
    private String sessionType = null;
    private String properties = null;
    private long sessionTimeout = 0L;
    private String name;
    private String algorithmClassName = "org.apache.synapse.endpoints.algorithms.RoundRobin";

    @Override
    public String getTagLocalName() {
        return "loadbalance";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getAlgorithmClassName() {
        return this.algorithmClassName;
    }

    public void setAlgorithmClassName(String algorithmClassName) {
        this.algorithmClassName = algorithmClassName;
    }

    @Override
    public OMElement serialize(OMElement parent) {
        OMElement endpoint = fac.createOMElement("endpoint", synNS);
        if (this.name != null && !"".equals(this.name)) {
            endpoint.addAttribute(fac.createOMAttribute("name", nullNS, this.getName()));
        }
        OMElement loadbalance = fac.createOMElement("loadbalance", synNS);
        loadbalance.addAttribute(fac.createOMAttribute("algorithm", nullNS, this.algorithmClassName));
        if (this.sessionType != null) {
            OMElement session = fac.createOMElement("session", synNS);
            session.addAttribute(fac.createOMAttribute("type", nullNS, this.sessionType));
            OMElement sessionTimeout = fac.createOMElement("sessionTimeout", synNS);
            sessionTimeout.setText(String.valueOf(this.getSessionTimeout()));
            session.addChild((OMNode)sessionTimeout);
            endpoint.addChild((OMNode)session);
        }
        if (this.properties != null && this.properties.length() != 0) {
            String[] props;
            for (String s : props = this.properties.split("::")) {
                String[] elements = s.split(",");
                OMElement property = fac.createOMElement("property", synNS);
                property.addAttribute(fac.createOMAttribute("name", nullNS, elements[0]));
                property.addAttribute(fac.createOMAttribute("value", nullNS, elements[1]));
                property.addAttribute(fac.createOMAttribute("scope", nullNS, elements[2]));
                endpoint.addChild((OMNode)property);
            }
        }
        endpoint.addChild((OMNode)loadbalance);
        this.serializeChildren(loadbalance, this.getList());
        if (parent != null) {
            parent.addChild((OMNode)endpoint);
        }
        return endpoint;
    }

    @Override
    public void build(OMElement elem, boolean isAnonymous) {
        Endpoint loadbalanceEndpoint;
        if (isAnonymous) {
            elem.addAttribute("name", "anonymous", elem.getOMFactory().createOMNamespace("", ""));
        }
        if ((loadbalanceEndpoint = SALoadbalanceEndpointFactory.getEndpointFromElement((OMElement)elem, (boolean)isAnonymous, (Properties)new Properties())) != null && loadbalanceEndpoint instanceof SALoadbalanceEndpoint) {
            SALoadbalanceEndpoint saLoadBalanceDataElement = (SALoadbalanceEndpoint)loadbalanceEndpoint;
            if (saLoadBalanceDataElement.getName() != null) {
                String string = this.name = saLoadBalanceDataElement.getName().equals("anonymous") ? "" : saLoadBalanceDataElement.getName();
            }
            if (saLoadBalanceDataElement.getAlgorithm() != null) {
                this.algorithmClassName = saLoadBalanceDataElement.getAlgorithm().getClass().getName();
            }
            this.sessionTimeout = saLoadBalanceDataElement.getSessionTimeout();
            OMElement sessionElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"));
            String session = sessionElement.getAttributeValue(new QName(null, "type"));
            if (session != null && !"".equals(session)) {
                this.sessionType = session;
            }
        } else {
            loadbalanceEndpoint = EndpointFactory.getEndpointFromElement((OMElement)elem, (boolean)isAnonymous, (Properties)new Properties());
            if (loadbalanceEndpoint != null) {
                LoadbalanceEndpoint loadBalanceEndpoint = (LoadbalanceEndpoint)loadbalanceEndpoint;
                if (loadBalanceEndpoint.getName() != null) {
                    String string = this.name = loadBalanceEndpoint.getName().equals("anonymous") ? "" : loadBalanceEndpoint.getName();
                }
                if (loadBalanceEndpoint.getAlgorithm() != null) {
                    this.algorithmClassName = loadBalanceEndpoint.getAlgorithm().getClass().getName();
                }
            }
        }
        this.properties = EndpointConfigurationHelper.buildPropertyString((AbstractEndpoint)loadbalanceEndpoint);
        OMElement endpointElement = null;
        if (elem.getFirstElement().getLocalName() == this.getTagLocalName()) {
            endpointElement = elem.getFirstElement();
        } else {
            Iterator it = elem.getChildElements();
            while (it.hasNext()) {
                OMElement child = (OMElement)it.next();
                if (child.getLocalName() != this.getTagLocalName()) continue;
                endpointElement = child;
                break;
            }
        }
        this.addChildren(endpointElement, this);
    }

    @Override
    public void build(Template template, DefinitionFactory factory) {
    }
}

