/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.ui.endpoints.address;

import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Template;
import org.wso2.carbon.endpoint.ui.endpoints.Endpoint;
import org.wso2.carbon.endpoint.ui.util.EndpointConfigurationHelper;

public class AddressEndpoint
extends Endpoint {
    private String endpointName;
    private String address;
    private String suspendDurationOnFailure;
    private String maxSusDuration;
    private String susProgFactor;
    private String errorCodes;
    private String format;
    private boolean swa = false;
    private boolean mtom = false;
    private boolean soap11 = false;
    private boolean soap12 = false;
    private boolean get = false;
    private boolean rest = false;
    private boolean pox = false;
    private String timedOutErrorCodes;
    private String retryDisabledErrorCodes;
    private String retryTimeout;
    private String retryDelay;
    private String timeoutAction;
    private String timeoutActionDuration;
    private boolean wsadd;
    private boolean sepList;
    private boolean wssec;
    private boolean wsrm;
    private String secPolKey;
    private String rmPolKey;
    private String description = "";
    private String properties;

    @Override
    public String getTagLocalName() {
        return "address";
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String name) {
        this.endpointName = name;
    }

    public String getSuspendDurationOnFailure() {
        return this.suspendDurationOnFailure;
    }

    public void setSuspendDurationOnFailure(String suspendDurationOnFailure) {
        this.suspendDurationOnFailure = suspendDurationOnFailure;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isSwa() {
        return this.swa;
    }

    public void setSwa(boolean swa) {
        this.swa = swa;
    }

    public boolean isMtom() {
        return this.mtom;
    }

    public void setMtom(boolean mtom) {
        this.mtom = mtom;
    }

    public boolean isSoap11() {
        return this.soap11;
    }

    public void setSoap11(boolean soap11) {
        this.soap11 = soap11;
    }

    public boolean isSoap12() {
        return this.soap12;
    }

    public void setSoap12(boolean soap12) {
        this.soap12 = soap12;
    }

    public boolean isRest() {
        return this.rest;
    }

    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public boolean isGet() {
        return this.get;
    }

    public void setGet(boolean get) {
        this.get = get;
    }

    public boolean isPox() {
        return this.pox;
    }

    public void setPox(boolean pox) {
        this.pox = pox;
    }

    public String getTimeoutAction() {
        return this.timeoutAction;
    }

    public void setTimeoutAction(String timeoutAction) {
        this.timeoutAction = timeoutAction.equals("101") ? "discard" : (timeoutAction.equals("102") ? "fault" : (timeoutAction.equals("100") ? null : timeoutAction));
    }

    public String getTimeoutActionDur() {
        return this.timeoutActionDuration;
    }

    public void setTimeoutActionDur(String timeoutActionDur) {
        this.timeoutActionDuration = timeoutActionDur;
    }

    public boolean isWsadd() {
        return this.wsadd;
    }

    public void setWsadd(boolean wsadd) {
        this.wsadd = wsadd;
    }

    public boolean isSepList() {
        return this.sepList;
    }

    public void setSepList(boolean sepList) {
        this.sepList = sepList;
    }

    public boolean isWssec() {
        return this.wssec;
    }

    public void setWssec(boolean wssec) {
        this.wssec = wssec;
    }

    public boolean isWsrm() {
        return this.wsrm;
    }

    public void setWsrm(boolean wsrm) {
        this.wsrm = wsrm;
    }

    public String getSecPolKey() {
        return this.secPolKey;
    }

    public void setSecPolKey(String secPolKey) {
        this.secPolKey = secPolKey;
    }

    public String getRmPolKey() {
        return this.rmPolKey;
    }

    public void setRmPolKey(String rmPolKey) {
        this.rmPolKey = rmPolKey;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address.replaceAll("&amp;", "&");
    }

    public String getMaxSusDuration() {
        return this.maxSusDuration;
    }

    public void setMaxSusDuration(String maxSusDuration) {
        this.maxSusDuration = maxSusDuration;
    }

    public String getSusProgFactor() {
        return this.susProgFactor;
    }

    public void setSusProgFactor(String susProgFactor) {
        this.susProgFactor = susProgFactor;
    }

    public String getErrorCodes() {
        return this.errorCodes;
    }

    public void setErrorCodes(String errorCodes) {
        this.errorCodes = errorCodes;
    }

    public void setRetryDisabledErrorCodes(String retryDisabledErrorCodes) {
        this.retryDisabledErrorCodes = retryDisabledErrorCodes;
    }

    public String getRetryDisabledErrorCodes() {
        return this.retryDisabledErrorCodes;
    }

    public String getTimedOutErrorCodes() {
        return this.timedOutErrorCodes;
    }

    public void setTimedOutErrorCodes(String timedOutErrorCodes) {
        this.timedOutErrorCodes = timedOutErrorCodes;
    }

    public String getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(String retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public String getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(String retryDelay) {
        this.retryDelay = retryDelay;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Override
    public OMElement serialize(OMElement parent) {
        OMElement endpoint = fac.createOMElement("endpoint", synNS);
        if (this.endpointName != null && !"".equals(this.endpointName)) {
            endpoint.addAttribute(fac.createOMAttribute("name", nullNS, this.endpointName));
        }
        OMElement addressElement = fac.createOMElement("address", synNS);
        if (this.address != null && !"".equals(this.address)) {
            addressElement.addAttribute(fac.createOMAttribute("uri", nullNS, this.address));
        }
        if (this.isSoap11()) {
            addressElement.addAttribute(fac.createOMAttribute("format", nullNS, "soap11"));
        } else if (this.isSoap12()) {
            addressElement.addAttribute(fac.createOMAttribute("format", nullNS, "soap12"));
        } else if (this.isPox()) {
            addressElement.addAttribute(fac.createOMAttribute("format", nullNS, "pox"));
        } else if (this.isRest()) {
            addressElement.addAttribute(fac.createOMAttribute("format", nullNS, "rest"));
        } else if (this.isGet()) {
            addressElement.addAttribute(fac.createOMAttribute("format", nullNS, "get"));
        }
        if (this.isSwa()) {
            addressElement.addAttribute(fac.createOMAttribute("optimize", nullNS, "swa"));
        } else if (this.isMtom()) {
            addressElement.addAttribute(fac.createOMAttribute("optimize", nullNS, "mtom"));
        }
        if (this.errorCodes != null && !"".equals(this.errorCodes) || this.suspendDurationOnFailure != null && !"".equals(this.suspendDurationOnFailure) || this.maxSusDuration != null && !"".equals(this.maxSusDuration) || this.susProgFactor != null && !"".equals(this.susProgFactor)) {
            OMElement suspendOnFailure = fac.createOMElement("suspendOnFailure", synNS);
            if (this.errorCodes != null && !"".equals(this.errorCodes)) {
                OMElement errorCodesElement = fac.createOMElement("errorCodes", synNS);
                errorCodesElement.setText(this.errorCodes.trim());
                suspendOnFailure.addChild((OMNode)errorCodesElement);
            }
            if (this.suspendDurationOnFailure != null && !"".equals(this.suspendDurationOnFailure)) {
                OMElement initialDuration = fac.createOMElement("initialDuration", synNS);
                initialDuration.setText(this.suspendDurationOnFailure.trim().startsWith("$") ? this.suspendDurationOnFailure.trim() : Long.valueOf(this.getSuspendDurationOnFailure().trim()).toString());
                suspendOnFailure.addChild((OMNode)initialDuration);
            }
            if (this.susProgFactor != null && !"".equals(this.susProgFactor)) {
                OMElement progressionFactor = fac.createOMElement("progressionFactor", synNS);
                progressionFactor.setText(this.susProgFactor.trim().startsWith("$") ? this.susProgFactor : Float.valueOf(this.susProgFactor).toString());
                suspendOnFailure.addChild((OMNode)progressionFactor);
            }
            if (this.maxSusDuration != null && !"".equals(this.maxSusDuration)) {
                OMElement maxumumDuration = fac.createOMElement("maximumDuration", synNS);
                maxumumDuration.setText(this.maxSusDuration.trim().startsWith("$") ? this.maxSusDuration.trim() : Long.valueOf(this.maxSusDuration.trim()).toString());
                suspendOnFailure.addChild((OMNode)maxumumDuration);
            }
            addressElement.addChild((OMNode)suspendOnFailure);
        }
        if (this.timedOutErrorCodes != null && !"".equals(this.timedOutErrorCodes) || this.retryDelay != null && !"".equals(this.retryDelay) || this.retryTimeout != null && !"".equals(this.retryTimeout)) {
            OMElement markForSuspension = fac.createOMElement("markForSuspension", synNS);
            if (this.timedOutErrorCodes != null && !"".equals(this.timedOutErrorCodes)) {
                OMElement timedOutErrorCodesElement = fac.createOMElement("errorCodes", synNS);
                timedOutErrorCodesElement.setText(this.timedOutErrorCodes.trim());
                markForSuspension.addChild((OMNode)timedOutErrorCodesElement);
            }
            if (this.retryTimeout != null && !"".equals(this.retryTimeout)) {
                OMElement retryTimeoutElement = fac.createOMElement("retriesBeforeSuspension", synNS);
                retryTimeoutElement.setText(this.retryTimeout);
                markForSuspension.addChild((OMNode)retryTimeoutElement);
            }
            if (this.retryDelay != null && !"".equals(this.retryDelay)) {
                OMElement retryDelayElement = fac.createOMElement("retryDelay", synNS);
                retryDelayElement.setText(this.retryDelay);
                markForSuspension.addChild((OMNode)retryDelayElement);
            }
            addressElement.addChild((OMNode)markForSuspension);
        }
        if (this.retryDisabledErrorCodes != null && !"".equals(this.retryDisabledErrorCodes)) {
            OMElement retryConfig = fac.createOMElement("retryConfig", synNS);
            OMElement disabledErrorCodes = fac.createOMElement("disabledErrorCodes", synNS);
            disabledErrorCodes.setText(this.retryDisabledErrorCodes);
            retryConfig.addChild((OMNode)disabledErrorCodes);
            addressElement.addChild((OMNode)retryConfig);
        }
        if ((this.timeoutAction != null && !"".equals(this.timeoutAction) || this.timeoutActionDuration != null && !"".equals(this.timeoutActionDuration)) && !"neverTimeout".equals(this.timeoutAction)) {
            OMElement timeout = fac.createOMElement("timeout", synNS);
            if (this.timeoutActionDuration != null && !"".equals(this.timeoutActionDuration)) {
                OMElement duration = fac.createOMElement("duration", synNS);
                duration.setText(this.timeoutActionDuration.trim());
                timeout.addChild((OMNode)duration);
            }
            if (this.timeoutAction != null && !"".equals(this.timeoutAction)) {
                OMElement responseAction = fac.createOMElement("responseAction", synNS);
                responseAction.setText(this.timeoutAction);
                timeout.addChild((OMNode)responseAction);
            }
            addressElement.addChild((OMNode)timeout);
        }
        if (this.wsadd) {
            OMElement enableAddressing = fac.createOMElement("enableAddressing", synNS);
            if (this.sepList) {
                enableAddressing.addAttribute(fac.createOMAttribute("separateListener", nullNS, "true"));
            }
            addressElement.addChild((OMNode)enableAddressing);
        }
        if (this.wssec) {
            OMElement enableSecurity = fac.createOMElement("enableSec", synNS);
            if (this.secPolKey != null && !"".equals(this.secPolKey)) {
                enableSecurity.addAttribute(fac.createOMAttribute("policy", nullNS, this.secPolKey));
            }
            addressElement.addChild((OMNode)enableSecurity);
        }
        if (this.wsrm) {
            OMElement enableRM = fac.createOMElement("enableRM", synNS);
            if (this.rmPolKey != null && !"".equals(this.rmPolKey)) {
                enableRM.addAttribute(fac.createOMAttribute("policy", nullNS, this.rmPolKey));
            }
            addressElement.addChild((OMNode)enableRM);
        }
        endpoint.addChild((OMNode)addressElement);
        if (this.properties != null && this.properties.length() != 0) {
            String[] props;
            for (String s : props = this.properties.split("::")) {
                String[] elements = s.split(",");
                OMElement property = fac.createOMElement("property", synNS);
                property.addAttribute(fac.createOMAttribute("name", nullNS, elements[0]));
                property.addAttribute(fac.createOMAttribute("value", nullNS, elements[1]));
                property.addAttribute(fac.createOMAttribute("scope", nullNS, elements[2]));
                endpoint.addChild((OMNode)property);
            }
        }
        if (this.description != null && !this.description.equals("")) {
            OMElement descriptionElement = fac.createOMElement("description", synNS);
            descriptionElement.setText(this.description);
            endpoint.addChild((OMNode)descriptionElement);
        }
        if (parent != null) {
            parent.addChild((OMNode)endpoint);
        }
        return endpoint;
    }

    @Override
    public void build(OMElement elem, boolean isAnonymous) {
        if (isAnonymous) {
            elem.addAttribute("name", "anonymous", elem.getOMFactory().createOMNamespace("", ""));
        }
        org.apache.synapse.endpoints.AddressEndpoint addressEndpoint = (org.apache.synapse.endpoints.AddressEndpoint)EndpointFactory.getEndpointFromElement((OMElement)elem, (boolean)isAnonymous, (Properties)new Properties());
        this.buildData(addressEndpoint);
    }

    @Override
    public void build(Template template, DefinitionFactory factory) {
        org.apache.synapse.endpoints.Endpoint endpoint;
        OMElement endpointEl = template.getElement();
        if (endpointEl != null && (endpoint = EndpointFactory.getEndpointFromElement((OMElement)endpointEl, (DefinitionFactory)factory, (boolean)false, (Properties)new Properties())) != null && endpoint instanceof org.apache.synapse.endpoints.AddressEndpoint) {
            org.apache.synapse.endpoints.AddressEndpoint addressEndpoint = (org.apache.synapse.endpoints.AddressEndpoint)endpoint;
            this.buildData(addressEndpoint);
        }
    }

    private void buildData(org.apache.synapse.endpoints.AddressEndpoint addressEndpoint) {
        if (addressEndpoint.getName() != null) {
            this.setEndpointName(addressEndpoint.getName().equals("anonymous") ? "" : addressEndpoint.getName());
        }
        this.setAddress(addressEndpoint.getDefinition().getAddress());
        this.setDescription(addressEndpoint.getDescription());
        this.setSoap11(addressEndpoint.getDefinition().isForceSOAP11());
        this.setSoap12(addressEndpoint.getDefinition().isForceSOAP12());
        this.setRest(addressEndpoint.getDefinition().isForceREST());
        this.setGet(addressEndpoint.getDefinition().isForceGET());
        this.setPox(addressEndpoint.getDefinition().isForcePOX());
        this.setSwa(addressEndpoint.getDefinition().isUseSwa());
        this.setMtom(addressEndpoint.getDefinition().isUseMTOM());
        if (addressEndpoint.getDefinition().getInitialSuspendDuration() != -1L) {
            this.setSuspendDurationOnFailure(String.valueOf(addressEndpoint.getDefinition().getInitialSuspendDuration()));
        }
        this.setTimeoutAction(String.valueOf(addressEndpoint.getDefinition().getTimeoutAction()));
        if (addressEndpoint.getDefinition().getTimeoutDuration() > 0L) {
            this.setTimeoutActionDur(String.valueOf(addressEndpoint.getDefinition().getTimeoutDuration()));
        }
        this.setWsadd(addressEndpoint.getDefinition().isAddressingOn());
        this.setSepList(addressEndpoint.getDefinition().isUseSeparateListener());
        this.setWssec(addressEndpoint.getDefinition().isSecurityOn());
        this.setWsrm(addressEndpoint.getDefinition().isReliableMessagingOn());
        this.setRmPolKey(addressEndpoint.getDefinition().getWsRMPolicyKey());
        this.setSecPolKey(addressEndpoint.getDefinition().getWsSecPolicyKey());
        if (addressEndpoint.getDefinition().getSuspendMaximumDuration() < Long.MAX_VALUE) {
            this.setMaxSusDuration(String.valueOf(addressEndpoint.getDefinition().getSuspendMaximumDuration()));
        }
        this.setSusProgFactor(String.valueOf(addressEndpoint.getDefinition().getSuspendProgressionFactor()));
        this.setErrorCodes(EndpointConfigurationHelper.errorCodeListBuilder(addressEndpoint.getDefinition().getSuspendErrorCodes()).trim());
        this.setRetryDisabledErrorCodes(EndpointConfigurationHelper.errorCodeListBuilder(addressEndpoint.getDefinition().getRetryDisabledErrorCodes()).trim());
        this.setTimedOutErrorCodes(EndpointConfigurationHelper.errorCodeListBuilder(addressEndpoint.getDefinition().getTimeoutErrorCodes()));
        this.setRetryTimeout(String.valueOf(addressEndpoint.getDefinition().getRetryDurationOnTimeout()));
        this.setRetryDelay(String.valueOf(addressEndpoint.getDefinition().getRetriesOnTimeoutBeforeSuspend()));
        this.setProperties(EndpointConfigurationHelper.buildPropertyString((AbstractEndpoint)addressEndpoint));
    }
}

