/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.ui.endpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.endpoint.ui.endpoints.EndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.address.AddressEndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.defaultendpoint.DefaultEndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.failover.FailoverEndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.loadbalance.LoadBalanceEndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.recipientlist.RecipientlistEndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.template.TemplateEndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.wsdl.WsdlEndpointService;

public class EndpointStore {
    private static EndpointStore instance = null;
    private Map<String, EndpointService> store = new TreeMap<String, EndpointService>();

    private EndpointStore() {
    }

    public static synchronized EndpointStore getInstance() {
        if (instance == null) {
            instance = new EndpointStore();
            instance.init();
        }
        return instance;
    }

    public void registerEndpoint(String endpointTagLocalName, EndpointService endpointService) {
        this.store.put(endpointTagLocalName, endpointService);
    }

    public EndpointService getEndpointService(OMElement element) {
        if (element.getFirstElement() != null && this.store.get(element.getFirstElement().getLocalName()) != null) {
            return this.store.get(element.getFirstElement().getLocalName());
        }
        Iterator it = element.getChildElements();
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            if (this.store.get(child.getLocalName()) == null) continue;
            return this.store.get(child.getLocalName());
        }
        if (element.getAttribute(new QName("template")) != null) {
            return this.store.get("template");
        }
        return null;
    }

    public EndpointService getEndpointService(String tagLocalName) {
        return this.store.get(tagLocalName);
    }

    public Collection<EndpointService> getRegisteredEndpoints() {
        return this.store.values();
    }

    private void init() {
        this.registerEndpoint("address", new AddressEndpointService());
        this.registerEndpoint("loadbalance", new LoadBalanceEndpointService());
        this.registerEndpoint("wsdl", new WsdlEndpointService());
        this.registerEndpoint("default", new DefaultEndpointService());
        this.registerEndpoint("failover", new FailoverEndpointService());
        this.registerEndpoint("recipientlist", new RecipientlistEndpointService());
        this.registerEndpoint("template", new TemplateEndpointService());
    }

    public ArrayList<String[]> getMenuItems() {
        ArrayList<String[]> menuItems = new ArrayList<String[]>();
        for (EndpointService epService : this.store.values()) {
            if (!epService.canAddAsChild()) continue;
            menuItems.add(new String[]{epService.getDisplayName(), epService.getType()});
        }
        return menuItems;
    }
}

