/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.ui.util;

import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.mediators.MediatorProperty;
import org.wso2.carbon.endpoint.ui.util.TemplateParameterContainer;

public class EndpointConfigurationHelper {
    public static final String ROUNDROBIN_ALGO_CLASS_NAME = "org.apache.synapse.endpoints.algorithms.RoundRobin";

    public static String getValidXMLString(String originalString) {
        String validXMLString = originalString.replace("&amp;", "&");
        validXMLString = validXMLString.replace("&lt;", "<");
        validXMLString = validXMLString.replace("&gt;", ">");
        validXMLString = validXMLString.replace("&quot;", "\"");
        validXMLString = validXMLString.replace("&", "&amp;");
        validXMLString = validXMLString.replace("<", "&lt;");
        validXMLString = validXMLString.replace(">", "&gt;");
        validXMLString = validXMLString.replace("\"", "&quot;");
        return validXMLString;
    }

    public static String errorCodeListBuilder(List<Integer> errCodes) {
        String errorCodes = " ";
        for (Integer errCode : errCodes) {
            errorCodes = errorCodes + errCode;
            errorCodes = errorCodes + ",";
        }
        return errorCodes.substring(0, errorCodes.length() - 1);
    }

    public static String getMappingFrom(TemplateParameterContainer container, TemplateParameterContainer.EndpointDefKey key) {
        String mapping = container.getTemplateMapping(key);
        if (mapping != null) {
            return mapping;
        }
        if (key == TemplateParameterContainer.EndpointDefKey.suspendProgressionFactor) {
            return "1.0";
        }
        if (key == TemplateParameterContainer.EndpointDefKey.retryDurationOnTimeout) {
            return "0";
        }
        if (key == TemplateParameterContainer.EndpointDefKey.retriesOnTimeoutBeforeSuspend) {
            return "0";
        }
        return "";
    }

    public static String buildPropertyString(AbstractEndpoint ep) {
        Iterator itr = ep.getProperties().iterator();
        String ret = "";
        while (itr.hasNext()) {
            MediatorProperty prop = (MediatorProperty)itr.next();
            if (ret.equals("")) {
                ret = prop.getName() + "," + prop.getValue() + "," + prop.getScope();
                continue;
            }
            ret = ret + "::" + prop.getName() + "," + prop.getValue() + "," + prop.getScope();
        }
        return ret;
    }

    public static String testAddressURL(String url) {
        String returnValue;
        if (url != null && !url.equals("")) {
            try {
                URL conn = new URL(url);
                conn.openConnection().connect();
                EndpointConfigurationHelper.testWSDLURI(url + "?wsdl");
                returnValue = "success";
            }
            catch (UnknownHostException e) {
                returnValue = "unknown";
            }
            catch (MalformedURLException e) {
                returnValue = "malformed";
            }
            catch (ConnectException e) {
                returnValue = "Cannot establish connection to the provided address.";
            }
            catch (UnknownServiceException e) {
                returnValue = "unknown_service";
            }
            catch (SSLHandshakeException e) {
                returnValue = "ssl_error";
            }
            catch (Exception e) {
                returnValue = "Cannot establish connection to the provided address";
            }
        } else {
            returnValue = "Invalid address specified.";
        }
        if (url != null && !url.toUpperCase().startsWith("HTTP") && !url.toUpperCase().startsWith("HTTPS") && url.contains(":") && url.indexOf(58) < 6) {
            returnValue = "unsupported";
        }
        return returnValue;
    }

    public static String testWSDLURI(String wsdlUri) {
        String returnValue = "";
        if (wsdlUri != null && !wsdlUri.equals("")) {
            try {
                URI uri = new URI(wsdlUri);
                uri.toURL().getContent();
                returnValue = "success";
            }
            catch (URISyntaxException e) {
                returnValue = "malformed";
            }
            catch (MalformedURLException e) {
                returnValue = "malformed";
            }
            catch (UnknownHostException e) {
                returnValue = "unknown";
            }
            catch (ConnectException e) {
                returnValue = "Cannot establish connection to the provided address";
            }
            catch (SSLHandshakeException e) {
                returnValue = "ssl_error";
            }
            catch (Exception e) {
                returnValue = "Cannot establish connection to the provided address";
            }
        }
        return returnValue;
    }
}

