/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.ui.util;

import java.rmi.RemoteException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.wso2.carbon.endpoint.ui.endpoints.Endpoint;
import org.wso2.carbon.endpoint.ui.endpoints.EndpointService;
import org.wso2.carbon.endpoint.ui.endpoints.EndpointStore;
import org.wso2.carbon.endpoint.ui.endpoints.ListEndpoint;

public class ListEndpointDesignerHelper {
    public static Endpoint getEditingEndpoint(HttpServletRequest request, HttpSession session) {
        String childEndpointPosition = request.getParameter("childEndpointID");
        ListEndpoint endpoint = ListEndpointDesignerHelper.getEditingListEndpoint(session);
        if (childEndpointPosition != null && !"null".equals(childEndpointPosition)) {
            Endpoint editingChildEndpoint = ListEndpointDesignerHelper.getEndpointAt(endpoint, childEndpointPosition.substring(14));
            session.setAttribute("editingchildEndpoint", (Object)editingChildEndpoint);
            session.setAttribute("editingchildEndpointPosition", (Object)childEndpointPosition);
            return editingChildEndpoint;
        }
        return (Endpoint)session.getAttribute("editingchildEndpoint");
    }

    public static Endpoint getEndpointAt(ListEndpoint listEndpoint, String position) {
        if (position != null && listEndpoint != null) {
            int i = position.indexOf(".");
            if (i == -1) {
                if ("00".equals(position)) {
                    return listEndpoint;
                }
                int pos = Integer.parseInt(position);
                if (pos < listEndpoint.getList().size()) {
                    return listEndpoint.getList().get(pos);
                }
                return listEndpoint;
            }
            int index = Integer.parseInt(position.substring(0, i));
            return ListEndpointDesignerHelper.getEndpointAt((ListEndpoint)listEndpoint.getList().get(index), position.substring(i + 1));
        }
        return null;
    }

    public static ListEndpoint getEditingListEndpoint(HttpSession session) {
        return (ListEndpoint)session.getAttribute("editingListEndpoint");
    }

    public static String getEndpointHTML(Endpoint endpoint, boolean last, String position, ServletConfig config, Locale locale) {
        EndpointService endpointService = EndpointStore.getInstance().getEndpointService(endpoint.getTagLocalName());
        String endpointName = endpointService != null ? endpointService.getDisplayName() : endpoint.getTagLocalName();
        String endpointIconURL = "./images/node-normal.gif";
        String html = "<div class=\"minus-icon\" onclick=\"treeColapse(this)\"></div>";
        if (!(endpoint instanceof ListEndpoint) || ((ListEndpoint)endpoint).getList().isEmpty()) {
            html = "<div class=\"dot-icon\"></div>";
        }
        html = html + "<div class=\"childEndpoints\" style=\"background-image: url(" + endpointIconURL + ") !important\" id=\"childEndpoint-" + position + "\">" + "<a class=\"endpointLink\" id=\"childEndpoint-" + position + "\">" + endpointName + "</a><div class=\"endpointToolbar\" style=\"display:none\" >";
        if (endpoint instanceof ListEndpoint) {
            html = html + "<div><a class=\"addChildStyle\">Add Child</a></div><div class=\"endpointSep\">&nbsp;</div>";
            html = html + "<div><a class=\"deleteStyle\">delete</a></div>";
            html = html + "</div></div>";
            ListEndpoint listEndpoint = (ListEndpoint)endpoint;
            if (!listEndpoint.getList().isEmpty()) {
                html = last ? "<li>" + html : "<li class=\"vertical-line\">" + html;
                html = html + "<div class=\"branch-node\"></div>";
                html = html + "<ul class=\"child-list\">";
                int count = listEndpoint.getList().size();
                int endpointPosition = 0;
                for (Endpoint childEndpoint : listEndpoint.getList()) {
                    html = html + ListEndpointDesignerHelper.getEndpointHTML(childEndpoint, --count == 0, position + "." + endpointPosition, config, locale);
                    ++endpointPosition;
                }
                html = html + "</ul>";
            } else {
                html = !last ? "<li>" + html + "<div class=\"vertical-line-alone\"/>" : "<li>" + html;
            }
        } else {
            html = html + "<div><a class=\"deleteStyle\">delete</a></div>";
            html = html + "</div></div>";
            html = !last ? "<li>" + html + "<div class=\"vertical-line-alone\"/>" : "<li>" + html;
        }
        return html + "</li>";
    }

    public static Endpoint getNewEndpoint(String endpointName) throws RemoteException {
        EndpointStore store = EndpointStore.getInstance();
        EndpointService endpointService = store.getEndpointService(endpointName);
        if (endpointService != null) {
            return endpointService.getEndpoint();
        }
        throw new RuntimeException("Couldn't find the endpoint information in the endpoint store for the endpoint with logical name " + endpointName);
    }

    public static Endpoint removeEndpointAt(ListEndpoint listEndpoint, String position) {
        if (position != null && listEndpoint != null) {
            int i = position.indexOf(".");
            if (i == -1) {
                if ("00".equals(position)) {
                    return null;
                }
                return listEndpoint.getList().remove(Integer.parseInt(position));
            }
            int index = Integer.parseInt(position.substring(0, i));
            return ListEndpointDesignerHelper.removeEndpointAt((ListEndpoint)listEndpoint.getList().get(index), position.substring(i + 1));
        }
        return null;
    }

    public static boolean deleteEndpointAt(String position, HttpSession session) {
        ListEndpoint listEndpoint = ListEndpointDesignerHelper.getEditingListEndpoint(session);
        return ListEndpointDesignerHelper.removeEndpointAt(listEndpoint, position.substring(14)) != null;
    }

    public static void clearSessionCache(HttpSession session) {
        session.removeAttribute("endpoint.position");
    }
}

