/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.service;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.endpoint.EndpointAdminException;
import org.wso2.carbon.endpoint.service.EndpointMetaData;
import org.wso2.carbon.endpoint.util.ConfigHolder;
import org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class EndpointAdmin
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(EndpointAdmin.class);
    public static final String WSO2_ENDPOINT_MEDIA_TYPE = "application/vnd.wso2.endpoint";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchOn(String endpointName) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(endpointName);
            endpointName = endpointName.trim();
            Endpoint ep = this.getSynapseConfiguration().getEndpoint(endpointName);
            ep.getContext().switchOn();
            this.persistEndpoint(ep);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint " + ep.getName() + " switched on"));
            }
        }
        catch (SynapseException ex) {
            this.handleFault("Error switch on endpoint : " + endpointName, (Exception)((Object)ex));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchOff(String endpointName) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(endpointName);
            endpointName = endpointName.trim();
            Endpoint ep = this.getSynapseConfiguration().getEndpoint(endpointName);
            ep.getContext().switchOff();
            this.persistEndpoint(ep);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint " + ep.getName() + " switched off"));
            }
        }
        catch (SynapseException ex) {
            this.handleFault("Error switch off endpoint : " + endpointName, (Exception)((Object)ex));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEndpoint(String epString) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            OMElement endpointElement;
            lock.lock();
            try {
                endpointElement = AXIOMUtil.stringToOM((String)epString);
            }
            catch (XMLStreamException e) {
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (endpointElement.getQName().getLocalPart().equals(XMLConfigConstants.ENDPOINT_ELT.getLocalPart())) {
                String endpointName = endpointElement.getAttributeValue(new QName("name"));
                this.assertNameNotEmpty(endpointName);
                endpointName = endpointName.trim();
                log.debug((Object)("Adding endpoint : " + endpointName + " to the configuration"));
                if (this.getSynapseConfiguration().getLocalRegistry().get(endpointName) != null) {
                    this.handleFault("The name " + endpointName + " is already used within the configuration", null);
                } else {
                    SynapseConfiguration config = this.getSynapseConfiguration();
                    if (config.getEndpoint(endpointName) != null) {
                        this.handleFault("A endpoint with name " + endpointName + " is already there.", null);
                    }
                    SynapseXMLConfigurationFactory.defineEndpoint((SynapseConfiguration)config, (OMElement)endpointElement, (Properties)config.getProperties());
                    Endpoint endpoint = config.getEndpoint(endpointName);
                    if (endpoint != null) {
                        if (endpoint instanceof AbstractEndpoint) {
                            endpoint.setFileName(ServiceBusUtils.generateFileName((String)endpoint.getName()));
                        }
                        endpoint.init(this.getSynapseEnvironment());
                        this.persistEndpoint(endpoint);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added endpoint : " + endpointName + " to the configuration"));
                }
                boolean bl = true;
                return bl;
            }
            this.handleFault("Unable to create endpoint. Invalid XML definition", null);
        }
        catch (SynapseException syne) {
            this.handleFault("Unable to add Endpoint ", (Exception)((Object)syne));
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEndpoint(String endpointName) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(endpointName);
            endpointName = endpointName.trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting endpoint : " + endpointName + " from the configuration"));
            }
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Endpoint endpoint = (Endpoint)synapseConfiguration.getDefinedEndpoints().get(endpointName);
            synapseConfiguration.removeEndpoint(endpointName);
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            String fileName = null;
            if (endpoint instanceof AbstractEndpoint) {
                fileName = endpoint.getFileName();
            }
            pm.deleteItem(endpointName, fileName, 2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint : " + endpointName + " removed from the configuration"));
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndpointConfiguration(String endpointName) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            this.assertNameNotEmpty(endpointName);
            endpointName = endpointName.trim();
            if (synapseConfiguration.getEndpoint(endpointName) != null) {
                OMElement ele = EndpointSerializer.getElementFromEndpoint((Endpoint)synapseConfiguration.getEndpoint(endpointName));
                String string = ele.toString();
                return string;
            }
            this.handleFault("The endpoint named " + endpointName + " does not exist", null);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEndpoints() throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map namedEndpointMap = synapseConfiguration.getDefinedEndpoints();
            Collection namedEndpointCollection = namedEndpointMap.values();
            ArrayList<String> epList = new ArrayList<String>();
            for (Endpoint ep : namedEndpointCollection) {
                OMElement ele = EndpointSerializer.getElementFromEndpoint((Endpoint)ep);
                epList.add(ele.toString());
            }
            String[] stringArray = epList.toArray(new String[epList.size()]);
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointMetaData[] getEndpointsData() {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map namedEndpointMap = synapseConfiguration.getDefinedEndpoints();
            Collection namedEndpointCollection = namedEndpointMap.values();
            ArrayList<Endpoint> epList = new ArrayList<Endpoint>();
            for (Endpoint ep : namedEndpointCollection) {
                epList.add(ep);
            }
            Collections.sort(epList, new Comparator<Endpoint>(){

                @Override
                public int compare(Endpoint o1, Endpoint o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            ArrayList<EndpointMetaData> metaDatas = new ArrayList<EndpointMetaData>();
            for (Endpoint ep : epList) {
                EndpointMetaData data = new EndpointMetaData();
                data.setName(ep.getName());
                data.setDescription(ep.getDescription());
                EndpointDefinition def = ((AbstractEndpoint)ep).getDefinition();
                if (null != def) {
                    if (def.isStatisticsEnable()) {
                        data.setEnableStatistics(true);
                    } else {
                        data.setEnableStatistics(false);
                    }
                }
                if (ep.getContext().isState(1)) {
                    data.setSwitchOn(true);
                } else {
                    data.setSwitchOn(false);
                }
                data.setEndpointString(EndpointSerializer.getElementFromEndpoint((Endpoint)ep).toString());
                metaDatas.add(data);
            }
            EndpointMetaData[] endpointMetaDataArray = metaDatas.toArray(new EndpointMetaData[metaDatas.size()]);
            return endpointMetaDataArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableStatistics(String endpointName) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(endpointName);
            endpointName = endpointName.trim();
            Endpoint ep = this.getSynapseConfiguration().getEndpoint(endpointName);
            ((AbstractEndpoint)ep).getDefinition().enableStatistics();
            this.persistEndpoint(ep);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Statistics enabled on endpoint : " + endpointName));
            }
        }
        catch (SynapseException syne) {
            this.handleFault("Error enabling statistics for the endpoint : " + endpointName, (Exception)((Object)syne));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableStatistics(String endpointName) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(endpointName);
            endpointName = endpointName.trim();
            Endpoint ep = this.getSynapseConfiguration().getEndpoint(endpointName);
            ((AbstractEndpoint)ep).getDefinition().disableStatistics();
            this.persistEndpoint(ep);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Statistics disabled on endpoint : " + endpointName));
            }
        }
        catch (SynapseException syne) {
            this.handleFault("Error disabling statistics for the endpoint : " + endpointName, (Exception)((Object)syne));
        }
        finally {
            lock.unlock();
        }
    }

    private void persistEndpoint(Endpoint ep) throws EndpointAdminException {
        MediationPersistenceManager pm = this.getMediationPersistenceManager();
        pm.saveItem(ep.getName(), 2);
    }

    private void assertNameNotEmpty(String endpointName) throws EndpointAdminException {
        if (endpointName == null || "".equals(endpointName.trim())) {
            this.handleFault("Invalid name : Name is empty.", null);
        }
    }

    private void handleFault(String message, Exception e) throws EndpointAdminException {
        if (e != null) {
            log.error((Object)message, (Throwable)e);
            throw new EndpointAdminException(e.getMessage(), e);
        }
        log.error((Object)message);
        throw new EndpointAdminException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEndpoint(String epString) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            OMElement endpointElement;
            lock.lock();
            try {
                endpointElement = AXIOMUtil.stringToOM((String)epString);
            }
            catch (XMLStreamException e) {
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (endpointElement.getQName().getLocalPart().equals(XMLConfigConstants.ENDPOINT_ELT.getLocalPart())) {
                Endpoint endpoint;
                Endpoint previousEndpoint;
                String endpointName = endpointElement.getAttributeValue(new QName("name"));
                this.assertNameNotEmpty(endpointName);
                endpointName = endpointName.trim();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating the definition of the endpoint : " + endpointName));
                }
                if ((previousEndpoint = this.getSynapseConfiguration().getEndpoint(endpointName.trim())) == null) {
                    this.addEndpoint(epString);
                }
                boolean statisticsState = false;
                EndpointDefinition def = null;
                if (null != previousEndpoint) {
                    def = ((AbstractEndpoint)previousEndpoint).getDefinition();
                }
                if (null != def && def.isStatisticsEnable()) {
                    statisticsState = true;
                }
                String fileName = null;
                if (null != previousEndpoint && previousEndpoint instanceof AbstractEndpoint) {
                    fileName = previousEndpoint.getFileName();
                }
                if ((endpoint = EndpointFactory.getEndpointFromElement((OMElement)endpointElement, (boolean)false, (Properties)this.getSynapseConfiguration().getProperties())) == null) {
                    this.handleFault("Newly created endpoint is null ", null);
                }
                if (null != def && statisticsState) {
                    ((AbstractEndpoint)endpoint).getDefinition().enableStatistics();
                }
                if (fileName != null && endpoint instanceof AbstractEndpoint) {
                    endpoint.setFileName(fileName);
                }
                endpoint.init(this.getSynapseEnvironment());
                endpointName = endpointName.trim();
                this.getSynapseConfiguration().removeEndpoint(endpointName);
                this.getSynapseConfiguration().addEndpoint(endpointName, endpoint);
                this.persistEndpoint(endpoint);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updated the definition of the endpoint : " + endpointName));
                }
                boolean bl = true;
                return bl;
            }
            this.handleFault("Unable to update endpoint. Invalid XML definition", null);
        }
        catch (SynapseException syne) {
            this.handleFault("Unable to edit Endpoint ", (Exception)((Object)syne));
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveDynamicEndpoint(String key, String epName) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            OMElement endpointElement = AXIOMUtil.stringToOM((String)epName);
            if (endpointElement.getQName().getLocalPart().equals(XMLConfigConstants.ENDPOINT_ELT.getLocalPart())) {
                Registry registry;
                String endpointName = "dynamicEndpoint";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating endpoint : " + endpointName + " in the Synapse registry"));
                }
                if ((registry = this.getSynapseConfiguration().getRegistry()) != null) {
                    if (registry.getRegistryEntry(key).getType() == null) {
                        this.handleFault("No resource exists by the key '" + key + "'", null);
                    }
                    registry.updateResource(key, (Object)endpointElement);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Updated endpoint : " + endpointName + " in the Synapse registry"));
                    }
                    boolean bl = true;
                    return bl;
                }
            } else {
                this.handleFault("Unable to create endpoint. Invalid XML definition", null);
            }
        }
        catch (XMLStreamException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    public boolean addDynamicEndpoint(String key, String epConfiguration) throws EndpointAdminException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.reset();
        String originalKey = key;
        try {
            org.wso2.carbon.registry.core.Registry registry;
            if (key.startsWith("conf:")) {
                registry = this.getConfigSystemRegistry();
                key = key.replace("conf:", "");
            } else {
                registry = this.getGovernanceRegistry();
                key = key.replace("gov:", "");
            }
            if (!registry.resourceExists(key)) {
                try {
                    OMElement endpointElement = AXIOMUtil.stringToOM((String)epConfiguration);
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    String name = originalKey.replace(":", "/");
                    endpointElement.addAttribute(fac.createOMAttribute("name", fac.createOMNamespace("", ""), name));
                    XMLPrettyPrinter.prettify((OMElement)endpointElement, (OutputStream)stream);
                }
                catch (Exception e) {
                    this.handleFault("Unable to pretty print configuration", e);
                }
            } else {
                log.warn((Object)"Resource is already exists");
                return false;
            }
            epConfiguration = new String(stream.toByteArray()).trim();
            Resource resource = registry.newResource();
            resource.setMediaType(WSO2_ENDPOINT_MEDIA_TYPE);
            resource.setContent((Object)epConfiguration);
            registry.put(key, resource);
        }
        catch (RegistryException e) {
            this.handleFault("WSO2 Registry Exception", (Exception)((Object)e));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDynamicEndpoint(String key) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synConfig = this.getSynapseConfiguration();
            Registry registry = synConfig.getRegistry();
            if (registry != null) {
                if (registry.getRegistryEntry(key).getType() == null) {
                    this.handleFault("No resource is available by the key '" + key + "'", null);
                }
            } else {
                this.handleFault("Unable to access the registry instance for the ESB", null);
            }
            Object e = null;
            if (registry != null) {
                e = (OMElement)registry.getResource(new Entry(key), synConfig.getProperties());
            }
            if (e != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found dynamic endpoint " + key));
                }
                String string = e.toString();
                return string;
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDynamicEndpoints() throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            String[] configInfo = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            String[] govInfo = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            Object[] info = new String[configInfo.length + govInfo.length];
            int ptr = 0;
            for (String aConfigInfo : configInfo) {
                info[ptr] = "conf:" + aConfigInfo;
                ++ptr;
            }
            for (String aGovInfo : govInfo) {
                info[ptr] = "gov:" + aGovInfo;
                ++ptr;
            }
            Arrays.sort(info);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + info.length + " dynamic endpoints"));
            }
            Object[] objectArray = info;
            return objectArray;
        }
        catch (RegistryException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDynamicEndpoint(String key) throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            Registry registry = this.getSynapseConfiguration().getRegistry();
            if (registry != null) {
                if (registry.getRegistryEntry(key).getType() == null) {
                    this.handleFault("The key '" + key + "' cannot be found within the configuration", null);
                }
                registry.delete(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleted endpoint with key: " + key + " from the Synapse registry"));
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    private String[] getMimeTypeResult(org.wso2.carbon.registry.core.Registry targetRegistry) throws EndpointAdminException, RegistryException {
        String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE = ?";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", sql);
        parameters.put("1", WSO2_ENDPOINT_MEDIA_TYPE);
        org.wso2.carbon.registry.core.Collection result = targetRegistry.executeQuery(null, parameters);
        return (String[])result.getContent();
    }

    public ConfigurationObject[] getDependents(String endpointName) {
        ConfigurationObject[] dependents;
        DependencyManagementService dependencyMgr = ConfigHolder.getInstance().getDependencyManager();
        if (dependencyMgr != null && (dependents = dependencyMgr.getDependents(0, endpointName)) != null && dependents.length > 0) {
            ArrayList<ConfigurationObject> deps = new ArrayList<ConfigurationObject>();
            for (ConfigurationObject o : dependents) {
                if (o.getType() == 6) continue;
                deps.add(o);
            }
            if (deps.size() > 0) {
                return deps.toArray(new ConfigurationObject[deps.size()]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEndPointsNames() throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map namedEndpointMap = synapseConfiguration.getDefinedEndpoints();
            Collection namedEndpointCollection = namedEndpointMap.values();
            String[] stringArray = this.listToNames(namedEndpointCollection.toArray(new Endpoint[namedEndpointCollection.size()]));
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    private String[] listToNames(Endpoint[] eps) {
        if (eps == null) {
            return null;
        }
        String[] datas = new String[eps.length];
        for (int i = 0; i < eps.length; ++i) {
            Endpoint ep = eps[i];
            datas[i] = ep.getName();
        }
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEndpointCount() throws EndpointAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int n = this.getSynapseConfiguration().getDefinedEndpoints().size();
            return n;
        }
        catch (Exception e) {
            this.handleFault("Error while retrieving Endpoint count", e);
        }
        finally {
            lock.unlock();
        }
        return 0;
    }

    public int getDynamicEndpointCount() throws EndpointAdminException {
        try {
            String[] govList = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            String[] confList = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            return confList.length + govList.length;
        }
        catch (Exception e) {
            this.handleFault("Error while retrieving dynamic endpoint count", e);
            return 0;
        }
    }
}

