/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ejbservices.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.ServicePersistenceManager;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.ejbservices.component.xml.EJBAppServerConfig;
import org.wso2.carbon.ejbservices.service.util.EJBAppServerData;
import org.wso2.carbon.ejbservices.service.util.EJBProviderData;
import org.wso2.carbon.ejbservices.service.util.UploadedFileItem;
import org.wso2.carbon.ejbservices.service.util.WrappedAllConfigurations;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileManipulator;

public class EJBServicesAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(EJBServicesAdmin.class);
    private static Registry registry;
    private static EJBAppServerConfig[] appServerConfigs;

    public static void setRegistry(Registry registryParam) {
        registry = registryParam;
    }

    public static void setEJBAppServerConfig(EJBAppServerConfig[] serverConfigs) {
        appServerConfigs = serverConfigs == null ? new EJBAppServerConfig[0] : Arrays.copyOf(serverConfigs, serverConfigs.length);
    }

    public void addApplicationServer(String providerURL, String jndiContextClass, String userName, String password, String appServerType) throws Exception {
        try {
            String appServerID;
            String configPath = "/repository/components/org.wso2.carbon.ejbservices/app.servers/";
            if (registry.resourceExists(configPath)) {
                Collection configResourceCollection = (Collection)registry.get(configPath);
                String[] configResourcePaths = configResourceCollection.getChildren();
                for (int i = 0; i < configResourceCollection.getChildCount(); ++i) {
                    String configResourcePath = configResourcePaths[i];
                    Resource configResource = registry.get(configResourcePath);
                    if (!providerURL.equals(configResource.getProperty("providerURL"))) continue;
                    throw new Exception("Application Server already exists");
                }
                appServerID = String.valueOf(configResourceCollection.getChildCount() + 1);
            } else {
                appServerID = "1";
            }
            Resource appServerResource = registry.newResource();
            appServerResource.addProperty("providerURL", providerURL);
            appServerResource.addProperty("jndiContextClass", jndiContextClass);
            appServerResource.addProperty("userName", userName);
            appServerResource.addProperty("password", password);
            appServerResource.addProperty("appServerType", appServerType);
            registry.put("/repository/components/org.wso2.carbon.ejbservices/app.servers/" + appServerID, appServerResource);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to add the application server", (Throwable)e);
            throw e;
        }
    }

    public void addEJBConfiguration(String serviceName, String providerURL, String jndiContextClass, String userName, String password, String beanJNDIName, String remoteInterface, String appServerType) throws Exception {
        try {
            String ejbConfigurationID;
            String configPath = "/repository/components/org.wso2.carbon.ejbservices/configurations/";
            if (registry.resourceExists(configPath)) {
                Collection configResourceCollection = (Collection)registry.get(configPath);
                String[] configResourcePaths = configResourceCollection.getChildren();
                for (int i = 0; i < configResourceCollection.getChildCount(); ++i) {
                    String configResourcePath = configResourcePaths[i];
                    Resource configResource = registry.get(configResourcePath);
                    if (!serviceName.equals(configResource.getProperty("serviceName"))) continue;
                    throw new Exception("EBJ Configuration already exists");
                }
                ejbConfigurationID = String.valueOf(configResourceCollection.getChildCount() + 1);
            } else {
                ejbConfigurationID = "1";
            }
            Resource ejbConfigResource = registry.newResource();
            ejbConfigResource.addProperty("serviceName", serviceName);
            ejbConfigResource.addProperty("providerURL", providerURL);
            ejbConfigResource.addProperty("jndiContextClass", jndiContextClass);
            ejbConfigResource.addProperty("userName", userName);
            ejbConfigResource.addProperty("password", password);
            ejbConfigResource.addProperty("beanJNDIName", beanJNDIName);
            ejbConfigResource.addProperty("remoteInterface", remoteInterface);
            ejbConfigResource.addProperty("appServerType", appServerType);
            registry.put("/repository/components/org.wso2.carbon.ejbservices/configurations/" + ejbConfigurationID, ejbConfigResource);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to add EJB Configuration.", (Throwable)e);
            throw e;
        }
    }

    public EJBProviderData[] getEJBConfigurations() throws Exception {
        String configPath = "/repository/components/org.wso2.carbon.ejbservices/configurations/";
        try {
            if (!registry.resourceExists(configPath)) {
                return new EJBProviderData[0];
            }
            Collection configResourceCollection = (Collection)registry.get(configPath);
            String[] configResourcePaths = configResourceCollection.getChildren();
            EJBProviderData[] ejbProviderDataObjs = new EJBProviderData[configResourceCollection.getChildCount()];
            for (int i = 0; i < configResourceCollection.getChildCount(); ++i) {
                String configResourcePath = configResourcePaths[i];
                Resource configResource = registry.get(configResourcePath);
                ejbProviderDataObjs[i] = this.getEJBProviderData(configResource);
            }
            return ejbProviderDataObjs;
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get EJB Configurations", (Throwable)e);
            throw e;
        }
    }

    public EJBProviderData getEJBConfiguration(String serviceName) throws Exception {
        String configPath = "/repository/components/org.wso2.carbon.ejbservices/configurations/";
        if (registry.resourceExists(configPath)) {
            Collection configResourceCollection = (Collection)registry.get(configPath);
            String[] configResourcePaths = configResourceCollection.getChildren();
            for (int i = 0; i < configResourceCollection.getChildCount(); ++i) {
                String configResourcePath = configResourcePaths[i];
                Resource configResource = registry.get(configResourcePath);
                if (!serviceName.equals(configResource.getProperty("providerURL"))) continue;
                EJBProviderData ejbProviderData = new EJBProviderData();
                ejbProviderData.setProviderURL(configResource.getProperty("providerURL"));
                ejbProviderData.setJndiContextClass(configResource.getProperty("jndiContextClass"));
                ejbProviderData.setUserName(configResource.getProperty("userName"));
                ejbProviderData.setPassword(configResource.getProperty("password"));
                ejbProviderData.setBeanJNDIName(configResource.getProperty("beanJNDIName"));
                String remoteInterface = configResource.getProperty("remoteInterface");
                ejbProviderData.setRemoteInterface(remoteInterface);
                ejbProviderData.setServiceName(configResource.getProperty("serviceName"));
                return ejbProviderData;
            }
        }
        return null;
    }

    public void deleteEJBConfiguration(String serviceName) throws Exception {
        String configPath = "/repository/components/org.wso2.carbon.ejbservices/configurations/";
        try {
            registry.beginTransaction();
            if (registry.resourceExists(configPath)) {
                Collection configResourceCollection = (Collection)registry.get(configPath);
                String[] configResourcePaths = configResourceCollection.getChildren();
                for (int i = 0; i < configResourceCollection.getChildCount(); ++i) {
                    String configResourcePath = configResourcePaths[i];
                    Resource configResource = registry.get(configResourcePath);
                    if (!serviceName.equals(configResource.getProperty("serviceName"))) continue;
                    registry.delete(configResourcePath);
                }
            }
            registry.commitTransaction();
            ServiceAdmin serviceAdmin = new ServiceAdmin();
            serviceAdmin.deleteServiceGroups(new String[]{serviceName});
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw e;
        }
    }

    public EJBAppServerData[] getAppServerNameList() {
        EJBAppServerData[] ejbAppServerList = new EJBAppServerData[appServerConfigs.length];
        int i = 0;
        for (EJBAppServerConfig appServerConfig : appServerConfigs) {
            EJBAppServerData ejbAppServerData = new EJBAppServerData();
            ejbAppServerData.setServerId(appServerConfig.getId());
            ejbAppServerData.setServerName(appServerConfig.getName());
            ejbAppServerData.setProviderURL(appServerConfig.getProviderURL());
            ejbAppServerData.setJndiContextClass(appServerConfig.getJndiContextClass());
            ejbAppServerList[i++] = ejbAppServerData;
        }
        return ejbAppServerList;
    }

    public EJBAppServerData[] getEJBAppServerConfigurations() throws Exception {
        String configPath = "/repository/components/org.wso2.carbon.ejbservices/app.servers/";
        try {
            if (!registry.resourceExists(configPath)) {
                return new EJBAppServerData[0];
            }
            Collection configResourceCollection = (Collection)registry.get(configPath);
            String[] configResourcePaths = configResourceCollection.getChildren();
            EJBAppServerData[] ejbAppServerDataObjs = new EJBAppServerData[configResourceCollection.getChildCount()];
            for (int i = 0; i < configResourceCollection.getChildCount(); ++i) {
                String configResourcePath = configResourcePaths[i];
                Resource configResource = registry.get(configResourcePath);
                ejbAppServerDataObjs[i] = new EJBAppServerData();
                ejbAppServerDataObjs[i].setAppServerType(configResource.getProperty("appServerType"));
                ejbAppServerDataObjs[i].setProviderURL(configResource.getProperty("providerURL"));
            }
            return ejbAppServerDataObjs;
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get EJB Configurations", (Throwable)e);
            throw e;
        }
    }

    public String[] getClassNames(String archiveId) throws AxisFault {
        String filePath = this.getFilePathFromArchiveId(archiveId);
        if (filePath != null) {
            try {
                String[] entries = new ArchiveManipulator().check(filePath);
                ArrayList<String> classNames = new ArrayList<String>();
                for (String entry : entries) {
                    if (!entry.endsWith(".class")) continue;
                    entry = entry.replace('/', '.').substring(0, entry.lastIndexOf(".class"));
                    classNames.add(entry);
                }
                return classNames.toArray(new String[classNames.size()]);
            }
            catch (IOException e) {
                String msg = "Could not read archive";
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        return new String[]{""};
    }

    public void createAndDeployEJBService(String archiveId, String serviceName, String[] serviceClasses, String jnpProviderUrl, String beanJNDIName, String remoteInterface) throws Exception {
        String password = null;
        EJBAppServerData ejbAppServerData = this.getEJBAppServerConfiguration(jnpProviderUrl, password);
        if (ejbAppServerData == null) {
            throw new AxisFault("Non-existance Application server configuration");
        }
        try {
            EJBProviderData ejbProviderData = this.getEJBConfiguration(serviceName);
            if (ejbProviderData != null) {
                throw new AxisFault("A Service exists for the provided Service Name(" + serviceName + ").");
            }
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        this.addEJBConfiguration(serviceName, ejbAppServerData.getProviderURL(), ejbAppServerData.getJndiContextClass(), ejbAppServerData.getUserName(), ejbAppServerData.getUserName(), beanJNDIName, remoteInterface, ejbAppServerData.getAppServerType());
        String filePathFromArchiveId = this.getFilePathFromArchiveId(archiveId);
        if (filePathFromArchiveId == null) {
            String msg = "A non-existent file was requested";
            log.warn((Object)msg);
            throw new AxisFault(msg);
        }
        int endIndex = filePathFromArchiveId.lastIndexOf(File.separator);
        String filePath = filePathFromArchiveId.substring(0, endIndex);
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        String unzippeDir = filePath + File.separator + "temp";
        File unzipped = new File(unzippeDir);
        unzipped.mkdirs();
        try {
            archiveManipulator.extract(filePathFromArchiveId, unzippeDir);
        }
        catch (IOException e) {
            throw new AxisFault("Cannot extract archive", (Throwable)e);
        }
        File file = new File(unzippeDir + File.separator + "META-INF" + File.separator + "services.xml");
        file.mkdirs();
        try {
            File absoluteFile = file.getAbsoluteFile();
            if (absoluteFile.exists()) {
                absoluteFile.delete();
            }
            absoluteFile.createNewFile();
            FileOutputStream os = new FileOutputStream(file);
            OMElement servicesXML = this.createServicesXMLForEJBService(serviceName, serviceClasses, ejbAppServerData.getProviderURL(), ejbAppServerData.getJndiContextClass(), ejbAppServerData.getUserName(), password, beanJNDIName, remoteInterface);
            servicesXML.build();
            servicesXML.serialize((OutputStream)os);
        }
        catch (Exception e) {
            String msg = "Cannot write services XML";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String outAARFilename = filePath + File.separator + serviceName + ".aar";
        try {
            archiveManipulator.archiveDir(outAARFilename, unzipped.getPath());
        }
        catch (IOException e) {
            String msg = "Cannot create new AAR archive";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String servicesDir = this.getAxisConfig().getParameter("ServicesDirectory").getValue().toString();
        String repo = this.getAxisConfig().getRepository().getPath() + File.separator + servicesDir;
        try {
            File aarInRepo = new File(repo + File.separator + serviceName + ".aar");
            FileManipulator.copyFile((File)new File(outAARFilename), (File)aarInRepo);
        }
        catch (IOException e) {
            String msg = "Cannot copy AAR file to Repo";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public String uploadService(UploadedFileItem fileItem) throws AxisFault {
        try {
            ConfigurationContext configurationContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
            String fileName = fileItem.getFileName();
            String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
            String serviceUploadDir = configurationContext.getProperty("WORK_DIR") + File.separator + "services" + File.separator + uuid + File.separator;
            File servicesDir = new File(serviceUploadDir);
            servicesDir.mkdirs();
            File uploadedFile = new File(servicesDir, fileName);
            Map fileResourceMap = (Map)configurationContext.getProperty("file.resource.map");
            fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
            FileOutputStream fileOutStream = new FileOutputStream(uploadedFile);
            fileItem.getDataHandler().writeTo((OutputStream)fileOutStream);
            fileOutStream.flush();
            fileOutStream.close();
            return uuid;
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while uploading service artifacts", (Throwable)e);
        }
    }

    public void setServiceParameters(String serviceName, String[] parameters) throws AxisFault {
        for (String parameter : parameters) {
            this.setServiceParameter(serviceName, parameter);
        }
    }

    public String[] getServiceParameters(String serviceName) throws AxisFault {
        if (serviceName == null) {
            String msg = "Invalid Service name";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        AxisService service = this.getAxisService(serviceName);
        if (service == null) {
            String msg = "Service cannot be found for the name : " + serviceName;
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        ArrayList parameters = service.getParameters();
        try {
            ArrayList<String> params = new ArrayList<String>();
            for (Parameter param : parameters) {
                OMElement paramEle = param.getParameterElement();
                if (paramEle == null) continue;
                params.add(paramEle.toString());
            }
            return params.toArray(new String[params.size()]);
        }
        catch (Exception e) {
            String msg = "Error occurred while getting parameters of service : " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public WrappedAllConfigurations getAllConfigurations() throws Exception {
        WrappedAllConfigurations allConfigurations = new WrappedAllConfigurations();
        allConfigurations.setEjbProviderData(this.getEJBConfigurations());
        allConfigurations.setAppServerData(this.getEJBAppServerConfigurations());
        allConfigurations.setAppServerNameList(this.getAppServerNameList());
        return allConfigurations;
    }

    public boolean testAppServerConnection(String providerURL, String jndiContextClass, String userName, String password) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("java.naming.security.principal", userName);
        properties.setProperty("java.naming.security.credentials", password);
        properties.setProperty("java.naming.factory.initial", jndiContextClass);
        properties.setProperty("java.naming.provider.url", providerURL);
        try {
            InitialContext context = new InitialContext(properties);
            return true;
        }
        catch (NamingException e) {
            log.info((Object)"AppServer Connection Test Failed", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void setServiceParameter(String serviceName, String parameterStr) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name service not found : " + serviceName);
        }
        OMElement paramEle = null;
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(parameterStr.getBytes()));
            paramEle = new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (XMLStreamException e) {
            String msg = "Cannot create OMElement from parameter: " + parameterStr;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        Parameter parameter = ParameterUtil.createParameter((OMElement)paramEle);
        if (axisService.getParameter(parameter.getName()) != null) {
            if (!axisService.getParameter(parameter.getName()).isLocked()) {
                axisService.addParameter(parameter);
            }
        } else {
            axisService.addParameter(parameter);
        }
        try {
            PersistenceFactory pf = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
            ServicePersistenceManager spm = pf.getServicePM();
            spm.updateServiceParameter(axisService, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist service parameter change for service " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private AxisService getAxisService(String serviceName) throws AxisFault {
        return this.getAxisConfig().getServiceForActivation(serviceName);
    }

    private OMElement createServicesXMLForEJBService(String serviceName, String[] serviceClasses, String providerURL, String jndiContextClass, String userName, String password, String beanJNDIName, String remoteInterface) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace emptyNS = factory.createOMNamespace("", "");
        OMElement serviceGroupEle = factory.createOMElement("serviceGroup", "", "");
        for (String serviceClass : serviceClasses) {
            OMElement serviceEle = factory.createOMElement("service", "", "");
            OMElement schemaEle = factory.createOMElement("schema", "", "");
            schemaEle.addAttribute(factory.createOMAttribute("elementFormDefaultQualified", emptyNS, "false"));
            serviceEle.addAttribute(factory.createOMAttribute("name", emptyNS, serviceName));
            OMElement msgReceiversEle = factory.createOMElement("messageReceivers", "", "");
            OMElement msgReceiverEle1 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle1.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-only", emptyNS);
            msgReceiverEle1.addAttribute("class", "org.apache.axis2.rpc.receivers.ejb.EJB3InOnlyMessageReceiver", emptyNS);
            OMElement msgReceiverEle2 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle2.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-out", emptyNS);
            msgReceiverEle2.addAttribute("class", "org.apache.axis2.rpc.receivers.ejb.EJB3MessageReceiver", emptyNS);
            msgReceiversEle.addChild((OMNode)msgReceiverEle1);
            msgReceiversEle.addChild((OMNode)msgReceiverEle2);
            OMElement parameterEle1 = factory.createOMElement("parameter", "", "");
            parameterEle1.addAttribute("name", "remoteInterfaceName", emptyNS);
            parameterEle1.setText(remoteInterface);
            OMElement parameterEle3 = factory.createOMElement("parameter", "", "");
            parameterEle3.addAttribute("name", "beanJndiName", emptyNS);
            parameterEle3.setText(beanJNDIName);
            OMElement parameterEle4 = factory.createOMElement("parameter", "", "");
            parameterEle4.addAttribute("name", "providerUrl", emptyNS);
            parameterEle4.setText(providerURL);
            OMElement parameterEle5 = factory.createOMElement("parameter", "", "");
            parameterEle5.addAttribute("name", "jndiContextClass", emptyNS);
            parameterEle5.setText(jndiContextClass);
            OMElement parameterEle6 = factory.createOMElement("parameter", "", "");
            parameterEle6.addAttribute("name", "jndiUser", emptyNS);
            parameterEle6.setText(userName);
            OMElement parameterEle7 = factory.createOMElement("parameter", "", "");
            parameterEle7.addAttribute("name", "jndiPassword", emptyNS);
            parameterEle7.setText(password);
            OMElement parameterEle8 = factory.createOMElement("parameter", "", "");
            parameterEle8.addAttribute("name", "ServiceClass", emptyNS);
            parameterEle8.setText(serviceClass);
            OMElement parameterEle9 = factory.createOMElement("parameter", "", "");
            parameterEle9.addAttribute("name", "serviceType", emptyNS);
            parameterEle9.setText("ejb_service");
            serviceEle.addChild((OMNode)schemaEle);
            serviceEle.addChild((OMNode)msgReceiversEle);
            serviceEle.addChild((OMNode)parameterEle1);
            serviceEle.addChild((OMNode)parameterEle3);
            serviceEle.addChild((OMNode)parameterEle4);
            serviceEle.addChild((OMNode)parameterEle5);
            serviceEle.addChild((OMNode)parameterEle6);
            serviceEle.addChild((OMNode)parameterEle7);
            serviceEle.addChild((OMNode)parameterEle8);
            serviceEle.addChild((OMNode)parameterEle9);
            serviceGroupEle.addChild((OMNode)serviceEle);
        }
        return serviceGroupEle;
    }

    private EJBAppServerData getEJBAppServerConfiguration(String jnpProviderUrl, String password) throws Exception {
        String configPath = "/repository/components/org.wso2.carbon.ejbservices/app.servers/";
        EJBAppServerData appServerData = null;
        try {
            if (!registry.resourceExists(configPath)) {
                return appServerData;
            }
            Collection configResourceCollection = (Collection)registry.get(configPath);
            String[] configResourcePaths = configResourceCollection.getChildren();
            for (int i = 0; i < configResourceCollection.getChildCount(); ++i) {
                String configResourcePath = configResourcePaths[i];
                Resource configResource = registry.get(configResourcePath);
                if (!jnpProviderUrl.equals(configResource.getProperty("providerURL"))) continue;
                appServerData = new EJBAppServerData();
                appServerData.setAppServerType(configResource.getProperty("appServerType"));
                appServerData.setProviderURL(configResource.getProperty("providerURL"));
                appServerData.setJndiContextClass(configResource.getProperty("jndiContextClass"));
                appServerData.setUserName(configResource.getProperty("userName"));
            }
            return appServerData;
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get EJB Configuration", (Throwable)e);
            throw e;
        }
    }

    private EJBProviderData getEJBProviderData(Resource configResource) {
        EJBProviderData ejbProviderData = new EJBProviderData();
        ejbProviderData.setProviderURL(configResource.getProperty("providerURL"));
        ejbProviderData.setJndiContextClass(configResource.getProperty("jndiContextClass"));
        ejbProviderData.setUserName(configResource.getProperty("userName"));
        ejbProviderData.setPassword(configResource.getProperty("password"));
        ejbProviderData.setBeanJNDIName(configResource.getProperty("beanJNDIName"));
        ejbProviderData.setRemoteInterface(configResource.getProperty("remoteInterface"));
        ejbProviderData.setServiceName(configResource.getProperty("serviceName"));
        return ejbProviderData;
    }

    private String getFilePathFromArchiveId(String archiveId) {
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        Map fileResMap = (Map)configCtx.getProperty("file.resource.map");
        return (String)fileResMap.get(archiveId);
    }
}

