/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ejbservices.ui.fileupload;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ejbservices.ui.EJBServicesAdminClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class EJBInterfaceFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".jar", ".zip"};

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        PrintWriter out = response.getWriter();
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/carbon/ejb_service/index.jsp"));
        }
        EJBServicesAdminClient ejbServices = new EJBServicesAdminClient(this.configurationContext, serverURL, cookie);
        try {
            assert (fileItemsMap != null);
            Iterator i$ = fileItemsMap.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String fieldName = o = (String)i$.next();
                FileItemData fileItemData = (FileItemData)((ArrayList)fileItemsMap.get(fieldName)).get(0);
                String fileName = this.getFileName(fileItemData.getFileItem().getName());
                this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                String uuid = ejbServices.uploadService(fileItemData.getDataHandler(), fileName, "");
                response.setContentType("text/html; charset=utf-8");
                out.write("<script type=\"text/javascript\">window.location = \"../" + webContext + "/ejb_service/ejb_provider_wizard_step2.jsp?archiveId=" + uuid + "\"" + "</script>");
            }
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/carbon/ejb_service/index.jsp"));
            return false;
        }
    }
}

