/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ejbservices.ui;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ejbservices.stub.EJBProviderAdminStub;
import org.wso2.carbon.ejbservices.stub.types.carbon.EJBAppServerData;
import org.wso2.carbon.ejbservices.stub.types.carbon.EJBProviderData;
import org.wso2.carbon.ejbservices.stub.types.carbon.UploadedFileItem;
import org.wso2.carbon.ejbservices.stub.types.carbon.WrappedAllConfigurations;
import org.wso2.carbon.ui.CarbonUIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBServicesAdminClient {
    private static final Log log = LogFactory.getLog(EJBServicesAdminClient.class);
    private EJBProviderAdminStub stub;

    public EJBServicesAdminClient(ServletContext servletContext, HttpSession httpSession) throws Exception {
        try {
            ConfigurationContext cc = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
            String cookie = (String)httpSession.getAttribute("wso2carbon.admin.service.cookie");
            String serverURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)httpSession);
            this.stub = new EJBProviderAdminStub(cc, serverURL + "EJBProviderAdmin");
            Options options = this.stub._getServiceClient().getOptions();
            options.setProperty("Cookie", (Object)cookie);
            options.setManageSession(true);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public EJBServicesAdminClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        this.stub = new EJBProviderAdminStub(ctx, serverURL + "EJBProviderAdmin");
        Options options = this.stub._getServiceClient().getOptions();
        options.setProperty("enableMTOM", (Object)"true");
        options.setProperty("Cookie", (Object)cookie);
        options.setTimeOutInMilliSeconds(10000L);
        options.setManageSession(true);
    }

    public String uploadService(DataHandler dataHandler, String fileName, String fileType) throws RemoteException {
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        uploadedFileItem.setDataHandler(dataHandler);
        uploadedFileItem.setFileName(fileName);
        uploadedFileItem.setFileType(fileType);
        return this.stub.uploadService(uploadedFileItem);
    }

    public EJBAppServerData[] getAppServerNameList() throws Exception {
        try {
            return this.stub.getAppServerNameList();
        }
        catch (Exception e) {
            String msg = "Failed to get Application Server Name List. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public EJBAppServerData[] getEJBAppServerConfigurations() throws Exception {
        try {
            return this.stub.getEJBAppServerConfigurations();
        }
        catch (Exception e) {
            String msg = "Failed to get Application Server Configurations. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void addApplicationServer(String providerURL, String jndiContextClass, String userName, String password, String appServerType) throws Exception {
        try {
            this.stub.addApplicationServer(providerURL, jndiContextClass, userName, password, appServerType);
        }
        catch (Exception e) {
            String msg = "Failed to add Application Server. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String[] getClassNames(String archiveId) throws Exception {
        try {
            return this.stub.getClassNames(archiveId);
        }
        catch (Exception e) {
            String msg = "Failed to get Class names. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void createAndDeployEJBService(String archiveId, String serviceName, String[] serviceClasses, String jnpProviderUrl, String beanJNDIName, String remoteInterface) throws Exception {
        try {
            this.stub.createAndDeployEJBService(archiveId, serviceName, serviceClasses, jnpProviderUrl, beanJNDIName, remoteInterface);
        }
        catch (Exception e) {
            String msg = "Failed to Deploy EJB Service. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public EJBProviderData[] getEJBConfigurations() throws Exception {
        try {
            return this.stub.getEJBConfigurations();
        }
        catch (Exception e) {
            String msg = "Failed to get EJB Configurations. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public WrappedAllConfigurations getAllConfigurations() throws Exception {
        try {
            return this.stub.getAllConfigurations();
        }
        catch (Exception e) {
            String msg = "Failed to get All EJB Configurations. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public Map<String, String> getServiceParameters(String serviceName) throws Exception {
        try {
            String[] parameters = this.stub.getServiceParameters(serviceName);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (String parameter : parameters) {
                OMElement paramEle = AXIOMUtil.stringToOM((String)parameter);
                String name = paramEle.getAttributeValue(new QName("", "name"));
                String value = paramEle.getText();
                paramMap.put(name, value);
            }
            return paramMap;
        }
        catch (Exception e) {
            String msg = "Failed to get Service parameters. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void setServiceParameters(String serviceName, String remoteInterfaceName, String beanJndiName, String jndiUser, String jndiPassword, String providerUrl, String serviceType, String jndiContextClass, String serviceClass) throws Exception {
        try {
            String[] parameters = new String[]{this.getParam("remoteInterfaceName", remoteInterfaceName), this.getParam("beanJndiName", beanJndiName), this.getParam("jndiUser", jndiUser), this.getParam("jndiPassword", jndiPassword), this.getParam("providerUrl", providerUrl), this.getParam("serviceType", serviceType), this.getParam("jndiContextClass", jndiContextClass)};
            this.stub.setServiceParameters(serviceName, parameters);
        }
        catch (Exception e) {
            String msg = "Failed to update Service parameters. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    private String getParam(String name, String value) {
        return "<parameter name=\"" + name + "\" locked=\"false\">" + value + "</parameter>";
    }

    public void deleteEJBConfiguration(String serviceName) throws Exception {
        try {
            this.stub.deleteEJBConfiguration(serviceName);
        }
        catch (Exception e) {
            String msg = "Failed to delete EJB Configuration. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean testAppServerConnection(String providerURL, String jndiContextClass, String userName, String password) throws Exception {
        boolean isSuccessful = false;
        try {
            isSuccessful = this.stub.testAppServerConnection(providerURL, jndiContextClass, userName, password);
        }
        catch (Exception e) {
            log.error((Object)"Failed to connect to the given Application Server.", (Throwable)e);
            throw e;
        }
        return isSuccessful;
    }
}

