/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ec2client.utils;

import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import sun.misc.BASE64Decoder;

public class PKCS1 {
    int pos;
    byte[] code;
    BigInteger[] ints;

    RSAPrivateCrtKeySpec keySpec() {
        return new RSAPrivateCrtKeySpec(this.ints[0], this.ints[1], this.ints[2], this.ints[3], this.ints[4], this.ints[5], this.ints[6], this.ints[7]);
    }

    int rdLen() throws IOException {
        int t;
        if ((this.code[this.pos] & 0x80) == 128) {
            int n = this.code[this.pos] & 0x7F;
            ++this.pos;
            t = this.rdLongLen(n);
        } else {
            t = this.code[this.pos];
            ++this.pos;
        }
        return t;
    }

    int rdLongLen(int n) throws IOException {
        int r = 0;
        for (int i = 0; i < n; ++i) {
            r = r << 8 | this.code[this.pos] & 0xFF;
            ++this.pos;
        }
        return r;
    }

    void skipInteger() throws IOException {
        if (this.code[this.pos] != 2) {
            throw new IOException("encountered invalid integer tag " + this.code[this.pos] + " at " + this.pos);
        }
        ++this.pos;
        int len = this.rdLen();
        this.pos += len;
    }

    BigInteger rdInteger() throws IOException {
        if (this.pos >= this.code.length) {
            throw new EOFException("end of file at " + this.pos);
        }
        if (this.code[this.pos] != 2) {
            throw new IOException("encountered invalid integer tag " + this.code[this.pos] + " at " + this.pos);
        }
        ++this.pos;
        int len = this.rdLen();
        byte[] x = new byte[len];
        System.arraycopy(this.code, this.pos, x, 0, len);
        this.pos += len;
        return new BigInteger(x);
    }

    void rdKey(int nb) throws IOException {
        this.ints = new BigInteger[8];
        this.skipInteger();
        for (int i = 0; i < 8; ++i) {
            this.ints[i] = this.rdInteger();
        }
    }

    public void extractIntegers(byte[] data) throws IOException {
        this.pos = 0;
        this.code = data;
        if (this.code[this.pos] != 48) {
            throw new IOException("invalid private key leading tag " + this.code[this.pos]);
        }
        this.pos = 1;
        int nb = this.rdLen();
        this.rdKey(nb);
    }

    char[] readWrappedBody(String name) throws IOException {
        FileReader file = new FileReader(name);
        char[] ba = new char[1024];
        boolean igl = true;
        int p = 0;
        int i = 0;
        while (i < 1024) {
            int ic = file.read();
            char c = (char)ic;
            if (ic < 0) break;
            if (c == '\n') {
                igl = false;
                p = 0;
            } else if (!igl) {
                if (c == '-') {
                    igl = true;
                } else {
                    ba[i] = c;
                    ++i;
                }
            }
            ++p;
        }
        char[] contents = new char[i];
        System.arraycopy(ba, 0, contents, 0, i);
        return contents;
    }

    public byte[] readDecodedBytes(String name) throws IOException {
        char[] ba = this.readWrappedBody(name);
        int n = ba.length;
        return new BASE64Decoder().decodeBuffer(new String(ba, 0, n));
    }

    RSAPrivateCrtKeySpec readKeyFile(String name) throws IOException {
        byte[] data = this.readDecodedBytes(name);
        this.extractIntegers(data);
        return this.keySpec();
    }

    public PrivateKey readKey(String name) throws IOException {
        PrivateKey pk;
        KeyFactory kf;
        RSAPrivateCrtKeySpec sp = this.readKeyFile(name);
        try {
            kf = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("RSA: " + e.toString());
        }
        try {
            pk = kf.generatePrivate(sp);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e.toString());
        }
        return pk;
    }
}

